/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.x509.X509CRLImpl;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Enumeration;
import java.util.Vector;

public class CRLs
implements ASN1Type {
    private static final long serialVersionUID = -236116118091891012L;
    Vector crls = new Vector();

    public void add(X509CRL crl) {
        this.crls.addElement(crl);
    }

    public int size() {
        return this.crls.size();
    }

    public Enumeration elements() {
        return this.crls.elements();
    }

    public void clear() {
        this.crls.removeAllElements();
    }

    public Vector getAsVector() {
        return this.crls;
    }

    public X509CRL[] getCRLs() {
        X509CRL[] ret = null;
        if (this.crls.size() > 0) {
            ret = new X509CRL[this.crls.size()];
            for (int i = 0; i < this.crls.size(); ++i) {
                ret[i] = (X509CRL)this.crls.elementAt(i);
            }
        }
        return ret;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        X509CRLImpl crl = null;
        this.crls.removeAllElements();
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            byte[] dat = dec.decodeAnyAsByteArray();
            try {
                crl = new X509CRLImpl(dat);
            }
            catch (CRLException ex) {
                throw new ASN1Exception(ex);
            }
            this.crls.addElement(crl);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.crls.size(); ++i) {
            X509CRL crl = (X509CRL)this.crls.elementAt(i);
            try {
                enc.encodeAny(crl.getEncoded());
                continue;
            }
            catch (CRLException ex) {
                throw new ASN1Exception(ex);
            }
        }
        enc.endOf(id);
    }
}

