/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DEREncoder;
import com.initech.x509.X509CertImpl;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class Certificates
implements ASN1Type {
    private static final long serialVersionUID = 4520998841307391513L;
    protected Vector certs = new Vector();

    public Certificates() {
    }

    public Certificates(X509Certificate[] crts) {
        this();
        this.add(crts);
    }

    public void add(Certificates crts) {
        for (int i = 0; i < crts.certs.size(); ++i) {
            this.certs.addElement(crts.certs.elementAt(i));
        }
    }

    public void add(X509Certificate crt) {
        this.certs.addElement(crt);
    }

    public void add(X509Certificate[] crts) {
        for (int i = 0; i < crts.length; ++i) {
            this.certs.addElement(crts[i]);
        }
    }

    public int size() {
        return this.certs.size();
    }

    public Enumeration elements() {
        return this.certs.elements();
    }

    public void clear() {
        this.certs.removeAllElements();
    }

    public X509Certificate elementAt(int i) {
        if (i < 0 || i >= this.certs.size()) {
            return null;
        }
        return (X509Certificate)this.certs.elementAt(i);
    }

    public Vector getAsVector() {
        return this.certs;
    }

    public X509Certificate[] getCertificates() {
        X509Certificate[] ret = null;
        if (this.certs.size() > 0) {
            ret = new X509Certificate[this.certs.size()];
            for (int i = 0; i < this.certs.size(); ++i) {
                ret[i] = (X509Certificate)this.certs.elementAt(i);
            }
        }
        return ret;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        X509CertImpl crt = null;
        this.certs.removeAllElements();
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            byte[] dat = dec.decodeAnyAsByteArray();
            try {
                crt = new X509CertImpl(dat);
            }
            catch (CertificateException ex) {
                throw new ASN1Exception(ex);
            }
            this.certs.addElement(crt);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.certs.size(); ++i) {
            X509Certificate crt = (X509Certificate)this.certs.elementAt(i);
            try {
                enc.encodeAny(crt.getEncoded());
                continue;
            }
            catch (CertificateEncodingException ex) {
                throw new ASN1Exception(ex);
            }
        }
        enc.endOf(id);
    }

    public byte[] toPKCS7() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int ci = enc.encodeSequence(true);
        enc.encodeObjectIdentifier(new ASN1OID("1.2.840.113549.1.7.2"));
        int exp = enc.encodeExplicit(ASN1Tag.makeExplicitTag(0), true);
        int sd = enc.encodeSequence(true);
        enc.encodeInteger(1);
        int name = enc.encodeSet();
        enc.endOf(name);
        int type = enc.encodeSequence(true);
        enc.encodeObjectIdentifier(new ASN1OID("1.2.840.113549.1.7.1"));
        enc.endOf(type);
        enc.nextIsImplicit(ASN1Tag.makeExplicitTag(0));
        int contents = enc.encodeSequenceOf(true);
        for (int i = 0; i < this.certs.size(); ++i) {
            X509Certificate crt = (X509Certificate)this.certs.elementAt(i);
            try {
                enc.encodeAny(crt.getEncoded());
                continue;
            }
            catch (CertificateEncodingException ex) {
                throw new ASN1Exception(ex);
            }
        }
        enc.endOf(contents);
        name = enc.encodeSet();
        enc.endOf(name);
        enc.endOf(sd);
        enc.endOf(exp);
        enc.endOf(ci);
        enc.finish();
        return enc.toByteArray();
    }
}

