/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509;

import com.initech.asn1.OIDDictionary;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.Extensions;
import com.initech.x509.X509CRLImpl;
import com.initech.x509.X509CertImpl;
import com.initech.x509.extensions.MultiValueExtension;
import com.initech.x509.extensions.SettableExtension;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ExtensionFactory {
    private static final String propertyBase = "/com/initech/x509/";
    private static final String defaultClassBase = "com.initech.x509.extensions";
    private Properties props;
    private X509Certificate cacert;
    private Extensions certExt = new Extensions();
    private Extensions crlExt = new Extensions();
    private static final String crtExtPrefix = "certificate.extension.";
    private static final String crlExtPrefix = "crl.extension.";
    private static Hashtable CertExtClassCache = new Hashtable();
    private static Hashtable CrlExtClassCache = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadExtensionClass(String pFile, Hashtable cache) throws IOException {
        Properties p = null;
        InputStream is = null;
        try {
            is = ExtensionFactory.class.getResourceAsStream(propertyBase + pFile);
            p = new Properties();
            p.load(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String base = p.getProperty("classBase", defaultClassBase);
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String cname;
            String oid = (String)e.nextElement();
            if (oid.equals("classBase") || (cname = p.getProperty(oid)) == null) continue;
            cname = base + "." + cname;
            Class<?> realClass = null;
            try {
                realClass = Class.forName(cname);
            }
            catch (ClassNotFoundException ex) {
                realClass = null;
            }
            if (realClass == null) {
                try {
                    realClass = Class.forName(cname);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (realClass == null) continue;
            cache.put(oid, realClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionFactory(String propFile, X509Certificate cacert) throws IOException {
        this.props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            this.props.load(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.cacert = cacert;
        this.loadExtensions(crtExtPrefix, CertExtClassCache, this.certExt);
        this.loadExtensions(crlExtPrefix, CrlExtClassCache, this.crlExt);
    }

    public ExtensionFactory(Properties props, X509Certificate cacert) {
        this.props = props;
        this.cacert = cacert;
        this.loadExtensions(crtExtPrefix, CertExtClassCache, this.certExt);
        this.loadExtensions(crlExtPrefix, CrlExtClassCache, this.crlExt);
    }

    private void loadExtensions(String prefix, Hashtable cache, Extensions target) {
        Enumeration e = cache.keys();
        while (e.hasMoreElements()) {
            String value;
            String oid = (String)e.nextElement();
            String name = OIDDictionary.getNamebyOID(oid);
            Extension ext = null;
            boolean critical = false;
            if (name == null) {
                name = oid;
            }
            if ((value = this.props.getProperty(prefix + name)) == null || value.length() <= 0) continue;
            Class extClass = (Class)cache.get(oid);
            try {
                ext = (Extension)extClass.newInstance();
            }
            catch (Exception ignore) {
                continue;
            }
            value = value.trim();
            if (value.startsWith("critical:")) {
                critical = true;
                value = value.substring(9).trim();
            } else if (value.startsWith("critical")) {
                critical = true;
                try {
                    value = value.substring(8);
                }
                catch (Exception ignore) {
                    value = null;
                }
            }
            if (ext instanceof MultiValueExtension) {
                String extPrefix = prefix + name + ".";
                if (!((MultiValueExtension)((Object)ext)).loadExtension(critical, value, this.cacert, extPrefix, this.props)) continue;
                target.add(ext);
                continue;
            }
            if (!(ext instanceof SettableExtension) || !((SettableExtension)((Object)ext)).loadExtension(critical, value, this.cacert)) continue;
            target.add(ext);
        }
    }

    public void setExtensions(Extensions exts) {
        Enumeration e = this.certExt.elements();
        while (e.hasMoreElements()) {
            Extension ext = (Extension)e.nextElement();
            exts.add(ext);
        }
    }

    public void setExtensions(X509Certificate cert) {
        if (cert instanceof X509CertImpl) {
            X509CertImpl c = (X509CertImpl)cert;
            Enumeration e = this.certExt.elements();
            while (e.hasMoreElements()) {
                Extension ext = (Extension)e.nextElement();
                c.addExtension(ext);
            }
        }
    }

    public void setExtensions(X509CRL crl) {
        if (crl instanceof X509CRLImpl) {
            X509CRLImpl c = (X509CRLImpl)crl;
            Enumeration e = this.crlExt.elements();
            while (e.hasMoreElements()) {
                Extension ext = (Extension)e.nextElement();
                c.addExtension(ext);
            }
        }
    }

    static {
        try {
            ExtensionFactory.loadExtensionClass("exts.cert.supported", CertExtClassCache);
            ExtensionFactory.loadExtensionClass("exts.crl.supported", CrlExtClassCache);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

