/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.Extensions;
import com.initech.asn1.useful.Time;
import com.initech.cryptox.util.StringUtil;
import com.initech.x509.X509ExtensionBuilder;
import com.initech.x509.extensions.CRLReason;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Set;

public class X509CRLEntryImpl
extends X509CRLEntry
implements ASN1Type {
    private static final long serialVersionUID = 3028296159661304352L;
    private BigInteger serial = null;
    private Time revDate = new Time();
    private Extensions extns = new Extensions();
    protected byte[] encoded = null;
    protected boolean modified = true;

    public X509CRLEntryImpl() {
    }

    public X509CRLEntryImpl(byte[] data) throws ASN1Exception {
        this();
        DERDecoder dec = new DERDecoder(data);
        this.decode(dec);
        this.encoded = (byte[])data.clone();
        this.modified = false;
    }

    public X509CRLEntryImpl(BigInteger serial, Date time) {
        this();
        this.serial = serial;
        this.revDate.setTime(time);
        this.modified = true;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.serial = dec.decodeInteger();
        this.revDate.decode(dec);
        this.extns.clear();
        if (!dec.nextIsOptional(48)) {
            this.extns.decode(dec);
        }
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeInteger(this.serial);
        this.revDate.encode(enc);
        if (this.extns.size() > 0) {
            enc.encodeAny(this.extns.getEncoded());
        }
        enc.endOf(id);
    }

    public boolean equals(Object other) {
        if (other instanceof X509CRLEntry) {
            byte[] a = null;
            byte[] b = null;
            try {
                a = this.getEncoded();
                b = ((X509CRLEntry)other).getEncoded();
            }
            catch (Exception e) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public BigInteger getSerialNumber() {
        return this.serial;
    }

    public Date getRevocationDate() {
        return this.revDate.getTime();
    }

    public boolean hasExtensions() {
        return this.extns.size() > 0;
    }

    public void setSerial(BigInteger sn) {
        this.modified = true;
        this.serial = sn;
    }

    public void setRevDate(Date d) {
        this.modified = true;
        this.revDate.setTime(d);
    }

    public void setReason(int reason) {
        this.addExtension(new CRLReason(reason));
    }

    public byte[] getEncoded() throws CRLException {
        try {
            if (this.modified || this.encoded == null) {
                DEREncoder enc = new DEREncoder();
                this.encode(enc);
                this.encoded = enc.toByteArray();
                this.modified = false;
            }
        }
        catch (ASN1Exception e) {
            throw new CRLException(e.toString());
        }
        return this.encoded;
    }

    public void toString(StringBuffer buf, int n) {
        StringUtil.indent(buf, n);
        buf.append("Serial : 0x");
        buf.append(this.serial.toString(16));
        buf.append('\n');
        StringUtil.indent(buf, n);
        buf.append("Revoked At : ");
        buf.append(this.revDate.getTime());
        buf.append('\n');
        if (this.extns.size() > 0) {
            X509ExtensionBuilder builder = new X509ExtensionBuilder();
            StringUtil.indent(buf, n);
            buf.append("X509v3 Extensions :");
            buf.append('\n');
            for (int i = 0; i < this.extns.size(); ++i) {
                Extension ext = this.extns.elementAt(i);
                ext = builder.build(ext);
                ext.toString(buf, n + 1);
            }
        }
    }

    public String toString(int n) {
        StringBuffer buf = new StringBuffer(64);
        this.toString(buf, n);
        return new String(buf);
    }

    public String toString() {
        return this.toString(0);
    }

    public Set getCriticalExtensionOIDs() {
        return this.extns.getCriticalOIDs();
    }

    public byte[] getExtensionValue(String oid) {
        return this.extns.getExtensionValue(oid);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.extns.getNonCriticalOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public Extension getExtension(String oid) {
        return this.extns.getExtension(oid);
    }

    public void addExtension(Extension ext) {
        this.modified = true;
        this.extns.add(ext);
    }

    public void clearExtension() {
        this.modified = true;
        this.extns.clear();
    }

    public void removeExtension(String oid) {
        this.modified = true;
        this.extns.remove(oid);
    }
}

