/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.Extensions;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.Time;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import com.initech.x509.X509CRLEntryImpl;
import com.initech.x509.X509CertImpl;
import com.initech.x509.X509ExtensionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class X509CRLImpl
extends X509CRL
implements ASN1Type {
    private static final long serialVersionUID = -1248985522264229773L;
    protected int version;
    protected AlgorithmID sigAlg = new AlgorithmID();
    protected Name issuer = new Name();
    protected Time thisUpdate = new Time();
    protected Time nextUpdate = null;
    protected Vector entries = new Vector();
    protected Extensions extensions = new Extensions();
    protected AlgorithmID signatureAlg = new AlgorithmID();
    protected ASN1BitString signature;
    protected byte[] encoded;
    protected boolean modified;
    protected byte[] encodedTBSCertList = null;
    protected boolean tbsModified = true;

    public X509CRLImpl() {
    }

    public X509CRLImpl(InputStream is) throws CRLException, IOException {
        this();
        try {
            this.decode(is);
        }
        catch (ASN1Exception ex) {
            Throwable e = ex.getCause();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new CRLException("X509CRL." + ex.toString());
        }
        catch (Exception e) {
            throw new CRLException("X509CRL." + e.toString());
        }
    }

    public X509CRLImpl(byte[] data) throws CRLException {
        this();
        try {
            this.decode(data);
        }
        catch (Exception e) {
            throw new CRLException("X509CRL." + e.toString());
        }
    }

    public void decode(byte[] array) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(array);
        this.decode(dec);
        this.encoded = (byte[])array.clone();
        this.modified = false;
    }

    public void decode(InputStream in) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(in);
        this.decode(dec);
    }

    private void decodeTBSCertList(byte[] b) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(b);
        int tbsList = dec.decodeSequence();
        if (dec.nextIsOptional(2)) {
            this.version = 1;
        } else {
            this.version = dec.decodeIntegerAsInt();
            ++this.version;
        }
        this.sigAlg.decode(dec);
        this.issuer.decode(dec);
        this.thisUpdate.decode(dec);
        int t = dec.peekNextTag();
        if (t == 23 || t == 24) {
            if (this.nextUpdate == null) {
                this.nextUpdate = new Time();
            }
            this.nextUpdate.decode(dec);
        } else {
            this.nextUpdate = null;
        }
        this.entries.removeAllElements();
        if (!dec.nextIsOptional(16)) {
            int entId = dec.decodeSequenceOf();
            while (!dec.endOf(entId)) {
                X509CRLEntryImpl entry = new X509CRLEntryImpl();
                entry.decode(dec);
                this.entries.addElement(entry);
            }
        }
        if (!dec.nextIsOptional(ASN1Tag.makeExplicitTag(0))) {
            int extId = dec.decodeExplicit(ASN1Tag.makeExplicitTag(0));
            this.extensions.decode(dec);
            dec.endOf(extId);
        }
        dec.endOf(tbsList);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        boolean allow = dec.IndefiniteLengthAllowed();
        dec.allowIndefiniteLength(false);
        int id = dec.decodeSequence();
        this.encodedTBSCertList = dec.decodeAnyAsByteArray();
        this.tbsModified = false;
        this.decodeTBSCertList(this.encodedTBSCertList);
        this.signatureAlg.decode(dec);
        this.signature = dec.decodeBitString();
        dec.endOf(id);
        dec.allowIndefiniteLength(allow);
    }

    private byte[] encodeTBSCertList() throws ASN1Exception {
        if (!this.tbsModified && this.encodedTBSCertList != null) {
            return this.encodedTBSCertList;
        }
        DEREncoder enc = new DEREncoder();
        int tbsList = enc.encodeSequence();
        if (this.extensions.size() > 0) {
            this.version = 2;
        } else if (this.version < 2) {
            this.version = 1;
        }
        if (this.version > 1) {
            enc.encodeInteger(this.version - 1);
        }
        this.sigAlg.encode(enc);
        this.issuer.encode(enc);
        this.thisUpdate.encode(enc);
        if (this.nextUpdate != null) {
            this.nextUpdate.encode(enc);
        }
        if (this.entries.size() > 0) {
            int entId = enc.encodeSequenceOf();
            for (int i = 0; i < this.entries.size(); ++i) {
                X509CRLEntry entry = (X509CRLEntry)this.entries.elementAt(i);
                try {
                    enc.encodeAny(entry.getEncoded());
                    continue;
                }
                catch (CRLException ex) {
                    throw new ASN1Exception(ex.toString());
                }
            }
            enc.endOf(entId);
        }
        if (this.extensions.size() > 0) {
            int ext = enc.encodeExplicit(ASN1Tag.makeContextTag(0));
            enc.encodeAny(this.extensions.getEncoded());
            enc.endOf(ext);
        }
        enc.endOf(tbsList);
        this.encodedTBSCertList = enc.toByteArray();
        enc.finish();
        this.tbsModified = false;
        return this.encodedTBSCertList;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeAny(this.encodeTBSCertList());
        this.sigAlg.encode(enc);
        enc.encodeBitString(this.signature);
        enc.endOf(id);
    }

    public boolean equals(Object other) {
        if (other instanceof X509CRL) {
            byte[] a = null;
            byte[] b = null;
            try {
                a = this.getEncoded();
                b = ((X509CRL)other).getEncoded();
            }
            catch (Exception e) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public int getVersion() {
        return this.version;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.issuer.getEncoded());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getNextUpdate() {
        if (this.nextUpdate == null) {
            return null;
        }
        if (this.nextUpdate.getTime().before(this.thisUpdate.getTime())) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.setTime(this.nextUpdate.getTime());
            cal.add(1, 100);
            return new Date(cal.getTime().getTime());
        }
        return this.nextUpdate.getTime();
    }

    public Date getThisUpdate() {
        return this.thisUpdate.getTime();
    }

    public byte[] getTBSCertList() throws CRLException {
        byte[] ret = null;
        try {
            ret = this.encodeTBSCertList();
        }
        catch (ASN1Exception ex) {
            throw new CRLException(ex.toString());
        }
        if (ret == null) {
            throw new CRLException("Unable to encode TBSCertList");
        }
        return ret;
    }

    public byte[] getSignature() {
        return this.signature.getAsByteArray();
    }

    public String getSigAlgName() {
        return this.sigAlg.getAlgName();
    }

    public String getSigAlgOID() {
        return this.sigAlg.getAlg();
    }

    public byte[] getSigAlgParams() {
        return this.sigAlg.getParameter();
    }

    public void setSignature(byte[] sig) {
        if (this.signature == null) {
            this.signature = new ASN1BitString();
        }
        this.signature.setByteArray(sig);
        this.modified = true;
    }

    public void setSigAlg(AlgorithmID sigAlgId) {
        this.sigAlg = (AlgorithmID)sigAlgId.clone();
        this.signatureAlg = (AlgorithmID)sigAlgId.clone();
        this.tbsModified = true;
        this.modified = true;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger serial) {
        for (int i = 0; i < this.entries.size(); ++i) {
            X509CRLEntry entry = (X509CRLEntry)this.entries.elementAt(i);
            if (!serial.equals(entry.getSerialNumber())) continue;
            return entry;
        }
        return null;
    }

    public Set getRevokedCertificates() {
        if (this.entries.size() > 0) {
            return new HashSet(this.entries);
        }
        return null;
    }

    public boolean isRevoked(Certificate cert) {
        X509CertImpl target = null;
        if (cert instanceof X509CertImpl) {
            target = (X509CertImpl)cert;
        } else {
            try {
                target = new X509CertImpl(cert.getEncoded());
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (!this.issuer.equals(target.getIssuerDN())) {
            return false;
        }
        return this.getRevokedCertificate(target.getSerialNumber()) != null;
    }

    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, InitechProvider.NAME);
    }

    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = null;
        sig = sigProvider == null ? Signature.getInstance(this.getSigAlgName(), InitechProvider.NAME) : Signature.getInstance(this.getSigAlgName(), sigProvider);
        sig.initVerify(key);
        sig.update(this.getTBSCertList());
        boolean verify = sig.verify(this.getSignature());
        if (!verify) {
            throw new CRLException("Bad Signature");
        }
    }

    public boolean hasExtensions() {
        return this.extensions.size() > 0;
    }

    public byte[] getEncoded() throws CRLException {
        try {
            if (this.tbsModified || this.modified || this.encoded == null) {
                DEREncoder enc = new DEREncoder();
                this.encode(enc);
                this.encoded = enc.toByteArray();
                enc.finish();
                this.modified = false;
            }
        }
        catch (ASN1Exception ex) {
            throw new CRLException(ex.toString());
        }
        return this.encoded;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(8192);
        buf.append("Version : ");
        buf.append(this.version);
        buf.append('\n');
        buf.append("Signature Algorithm : ");
        buf.append(this.sigAlg.getAlgName());
        buf.append('\n');
        buf.append("Issuer : ");
        buf.append(this.issuer.toString());
        buf.append('\n');
        buf.append("This Update : ");
        buf.append(this.thisUpdate.toString());
        buf.append('\n');
        if (this.nextUpdate != null) {
            buf.append("Next Update : ");
            buf.append(this.nextUpdate.toString());
            buf.append('\n');
        }
        buf.append("CRL Entries : ");
        buf.append(this.entries.size());
        buf.append(" entries\n");
        for (int i = 0; i < this.entries.size(); ++i) {
            Object entry = this.entries.elementAt(i);
            if (entry instanceof X509CRLEntryImpl) {
                ((X509CRLEntryImpl)entry).toString(buf, 1);
                continue;
            }
            buf.append(entry.toString());
        }
        if (this.extensions.size() > 0) {
            X509ExtensionBuilder builder = new X509ExtensionBuilder();
            buf.append("X509v3 Extensions :\n");
            for (int i = 0; i < this.extensions.size(); ++i) {
                Extension ext = this.extensions.elementAt(i);
                ext = builder.build(ext);
                ext.toString(buf, 1);
            }
        }
        buf.append("SignatureAlgorithm : ");
        buf.append(this.signatureAlg.getAlgName());
        buf.append('\n');
        buf.append("Signature : ");
        buf.append(this.signature.getUnusedBits());
        buf.append(" unused bits\n");
        buf.append(Hex.prettyDump(this.signature.getAsByteArray(), 48, ' ', 1));
        buf.append('\n');
        return new String(buf);
    }

    public Set getCriticalExtensionOIDs() {
        return this.extensions.getCriticalOIDs();
    }

    public byte[] getExtensionValue(String oid) {
        return this.extensions.getExtensionValue(oid);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.extensions.getNonCriticalOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public void sign(PrivateKey key, AlgorithmID ai) throws CRLException, InvalidKeyException, NoSuchAlgorithmException {
        this.sign(key, ai, InitechProvider.NAME);
    }

    public void sign(PrivateKey key, AlgorithmID ai, String provider) throws CRLException, InvalidKeyException, NoSuchAlgorithmException {
        Signature sig = null;
        try {
            sig = provider == null ? Signature.getInstance(ai.getAlgName(), InitechProvider.NAME) : Signature.getInstance(ai.getAlgName(), provider);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            throw new CRLException(e.toString());
        }
        this.sigAlg = ai;
        try {
            sig.initSign(key);
            byte[] enc_crl = this.getTBSCertList();
            sig.update(this.getTBSCertList());
            byte[] crl_sig = sig.sign();
            if (this.signature == null) {
                this.signature = new ASN1BitString();
            }
            this.signature.setByteArray(crl_sig);
            this.signatureAlg = ai;
        }
        catch (SignatureException e) {
            throw new CRLException(e.toString());
        }
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public Extension getExtension(String oid) {
        return this.extensions.getExtension(oid);
    }

    public void addExtension(Extension ext) {
        this.tbsModified = true;
        this.extensions.add(ext);
    }

    public void clearExtensions() {
        this.tbsModified = true;
        this.extensions.clear();
    }

    public void removeExtension(String oid) {
        this.tbsModified = true;
        this.extensions.remove(oid);
    }

    public void setVersion(int v) {
        this.tbsModified = true;
        this.version = v;
    }

    public void setThisUpdate(Date t) {
        this.tbsModified = true;
        this.thisUpdate.setTime(t);
    }

    public void setNextUpdate(Date t) {
        this.tbsModified = true;
        if (this.nextUpdate == null) {
            this.nextUpdate = new Time();
        }
        this.nextUpdate.setTime(t);
    }

    public void setIssuerDN(Name d) {
        this.tbsModified = true;
        this.issuer = d;
    }

    public void setIssuerDN(String d) {
        this.tbsModified = true;
        this.issuer.set(d);
    }

    public void add(X509CRLEntry ent) {
        this.tbsModified = true;
        this.entries.addElement(ent);
    }

    public int getCRLEntrySize() {
        return this.entries.size();
    }
}

