/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.Extensions;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.asn1.useful.Time;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import com.initech.x509.X509ExtensionBuilder;
import com.initech.x509.X509SubjectName;
import com.initech.x509.extensions.BasicConstraints;
import com.initech.x509.extensions.KeyUsage;
import com.initech.x509.extensions.SubjectAltName;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;

public class X509CertImpl
extends X509Certificate
implements ASN1Type,
X509SubjectName {
    protected int version = 1;
    protected BigInteger serial = null;
    protected AlgorithmID sigAlg = new AlgorithmID();
    protected Name issuer = new Name();
    protected Time notBefore = new Time();
    protected Time notAfter = new Time();
    protected Name subject = new Name();
    protected PublicKeyInfo keyInfo = new PublicKeyInfo();
    protected byte[] issuerUID = null;
    protected byte[] subjectUID = null;
    protected Extensions exts = new Extensions();
    protected AlgorithmID signatureAlg = new AlgorithmID();
    protected ASN1BitString signature = new ASN1BitString();
    protected byte[] encodedTBSCert = null;
    protected boolean tbsModified = true;
    protected byte[] encoded;
    protected boolean modified;
    protected PublicKey pubKey;
    protected int basicConstraints = -2;
    protected boolean[] keyusage = null;

    public X509CertImpl() {
    }

    public X509CertImpl(InputStream is) throws CertificateException, IOException {
        this();
        try {
            this.decode(is);
        }
        catch (ASN1Exception ex) {
            Throwable e = ex.getCause();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new CertificateException("X509Certificate." + ex.toString());
        }
        catch (Exception e) {
            throw new CertificateException("X509Certificate." + e.toString());
        }
    }

    public X509CertImpl(byte[] array) throws CertificateException {
        this();
        try {
            this.decode(array);
        }
        catch (Exception e) {
            throw new CertificateException("X509Certificate." + e.toString());
        }
    }

    public void decode(byte[] array) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(array);
        this.decode(dec);
        this.encoded = (byte[])array.clone();
        this.modified = false;
    }

    public void decode(InputStream in) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(in);
        this.decode(dec);
    }

    private void decodeTBSCert(byte[] b) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(b);
        int tbsCert = dec.decodeSequence();
        if (dec.nextIsOptional(ASN1Tag.makeExplicitTag(0))) {
            this.version = 1;
        } else {
            int verExp = dec.decodeExplicit(ASN1Tag.makeContextTag(0));
            this.version = dec.decodeIntegerAsInt();
            dec.endOf(verExp);
            ++this.version;
        }
        this.serial = dec.decodeInteger();
        this.sigAlg.decode(dec);
        this.issuer.decode(dec);
        int valid = dec.decodeSequence();
        this.notBefore.decode(dec);
        this.notAfter.decode(dec);
        dec.endOf(valid);
        this.subject.decode(dec);
        this.keyInfo.decode(dec);
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(1))) {
            this.issuerUID = null;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(1));
            this.issuerUID = dec.decodeOctetString();
        }
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(2))) {
            this.subjectUID = null;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(2));
            this.subjectUID = dec.decodeOctetString();
        }
        if (dec.nextIsOptional(ASN1Tag.makeExplicitTag(3))) {
            this.exts.clear();
        } else {
            int ext = dec.decodeExplicit(ASN1Tag.makeContextTag(3));
            this.exts.decode(dec);
            dec.endOf(ext);
        }
        dec.endOf(tbsCert);
    }

    private byte[] encodeTBSCert() throws ASN1Exception {
        if (!this.tbsModified && this.encodedTBSCert != null) {
            return this.encodedTBSCert;
        }
        DEREncoder enc = new DEREncoder();
        int tbsCert = enc.encodeSequence();
        this.version = this.exts.size() > 0 ? 3 : (this.issuerUID != null || this.subjectUID != null ? 2 : 1);
        if (this.version > 1) {
            int verExp = enc.encodeExplicit(ASN1Tag.makeContextTag(0));
            enc.encodeInteger(this.version - 1);
            enc.endOf(verExp);
        }
        enc.encodeInteger(this.serial);
        this.sigAlg.encode(enc);
        this.issuer.encode(enc);
        int valid = enc.encodeSequence();
        this.notBefore.encode(enc);
        this.notAfter.encode(enc);
        enc.endOf(valid);
        this.subject.encode(enc);
        enc.encodeAny(this.keyInfo.getEncoded());
        if (this.issuerUID != null) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(1));
            enc.encodeOctetString(this.issuerUID, 0, this.issuerUID.length);
        }
        if (this.subjectUID != null) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(2));
            enc.encodeOctetString(this.subjectUID, 0, this.subjectUID.length);
        }
        if (this.exts.size() > 0) {
            int ext = enc.encodeExplicit(ASN1Tag.makeContextTag(3));
            enc.encodeAny(this.exts.getEncoded());
            enc.endOf(ext);
        }
        enc.endOf(tbsCert);
        this.encodedTBSCert = enc.toByteArray();
        enc.finish();
        this.tbsModified = false;
        return this.encodedTBSCert;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeAny(this.encodeTBSCert());
        this.sigAlg.encode(enc);
        enc.encodeBitString(this.signature);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        boolean allow = dec.IndefiniteLengthAllowed();
        dec.allowIndefiniteLength(false);
        int id = dec.decodeSequence();
        this.encodedTBSCert = dec.decodeAnyAsByteArray();
        this.tbsModified = false;
        this.decodeTBSCert(this.encodedTBSCert);
        this.signatureAlg.decode(dec);
        this.signature = dec.decodeBitString();
        dec.endOf(id);
        dec.allowIndefiniteLength(allow);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            if (this.tbsModified || this.modified || this.encoded == null) {
                DEREncoder enc = new DEREncoder();
                this.encode(enc);
                this.encoded = enc.toByteArray();
                enc.finish();
                this.modified = false;
            }
        }
        catch (ASN1Exception ex) {
            throw new CertificateEncodingException(ex.toString());
        }
        return this.encoded;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Calendar date = Calendar.getInstance();
        this.checkValidity(date.getTime());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.notBefore.getTime().after(date)) {
            throw new CertificateNotYetValidException();
        }
        if (this.notAfter.getTime().before(date)) {
            throw new CertificateExpiredException();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public BigInteger getSerialNumber() {
        return this.serial;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.issuer.getEncoded());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Principal getSubjectDN() {
        return this.subject;
    }

    public X500Principal getSubjectX500Principal() {
        try {
            return new X500Principal(this.subject.getEncoded());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getNotBefore() {
        return new Date(this.notBefore.getTime().getTime());
    }

    public Date getNotAfter() {
        if (this.notAfter.getTime().before(this.notBefore.getTime())) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.setTime(this.notAfter.getTime());
            cal.add(1, 100);
            return new Date(cal.getTime().getTime());
        }
        return new Date(this.notAfter.getTime().getTime());
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        byte[] ret = null;
        try {
            ret = this.encodeTBSCert();
        }
        catch (ASN1Exception ex) {
            throw new CertificateEncodingException(ex.toString());
        }
        if (ret == null) {
            throw new CertificateEncodingException("Unable to encode TBSCertificate");
        }
        return ret;
    }

    public byte[] getSignature() {
        return this.signature.getAsByteArray();
    }

    public String getSigAlgName() {
        return this.sigAlg.getAlgName();
    }

    public String getSigAlgOID() {
        return this.sigAlg.getAlg();
    }

    public byte[] getSigAlgParams() {
        return this.sigAlg.getParameter();
    }

    public void setSignature(byte[] sig) {
        this.signature.setByteArray(sig);
        this.modified = true;
    }

    public void setSigAlg(AlgorithmID sigAlgId) {
        this.sigAlg = (AlgorithmID)sigAlgId.clone();
        this.signatureAlg = (AlgorithmID)sigAlgId.clone();
        this.tbsModified = true;
        this.modified = true;
    }

    public boolean[] getIssuerUniqueID() {
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        return null;
    }

    public boolean[] getKeyUsage() {
        if (this.keyusage == null) {
            try {
                byte[] v = this.getExtensionValue("2.5.29.15");
                if (v == null) {
                    this.keyusage = null;
                } else {
                    KeyUsage ku = new KeyUsage(v);
                    this.keyusage = ku.getBooleanArray();
                }
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
                this.keyusage = null;
            }
        }
        return this.keyusage;
    }

    public int getBasicConstraints() {
        if (this.basicConstraints == -2) {
            try {
                BasicConstraints bc;
                byte[] v = this.getExtensionValue("2.5.29.19");
                this.basicConstraints = v == null ? -1 : ((bc = new BasicConstraints(v)).isCA() ? bc.getPathLen() : -1);
            }
            catch (Exception ignore) {
                this.basicConstraints = -1;
            }
        }
        return this.basicConstraints;
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, InitechProvider.NAME);
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = null;
        sig = sigProvider == null ? Signature.getInstance(this.getSigAlgName(), InitechProvider.NAME) : Signature.getInstance(this.getSigAlgName(), sigProvider);
        if (!this.sigAlg.getAlg().equals(this.signatureAlg.getAlg())) {
            throw new CertificateException("Unmatched signature algorithm");
        }
        sig.initVerify(key);
        sig.update(this.getTBSCertificate());
        boolean verify = sig.verify(this.getSignature());
        if (!verify) {
            throw new CertificateException("Bad Signature");
        }
    }

    public PublicKey getPublicKey() {
        if (this.pubKey == null) {
            try {
                this.pubKey = this.keyInfo.getPublicKey();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.pubKey = null;
            }
        }
        return this.pubKey;
    }

    public void setPublicKey(PublicKey pkey) throws InvalidKeyException {
        this.tbsModified = true;
        this.keyInfo.setPublicKey(pkey);
        this.pubKey = pkey;
    }

    public void setPublicKeyAlg(AlgorithmID alg) {
        this.tbsModified = true;
        this.keyInfo.setAlgorithm(alg);
    }

    public Set getCriticalExtensionOIDs() {
        return this.exts.getCriticalOIDs();
    }

    public byte[] getExtensionValue(ASN1OID oid) {
        return this.exts.getExtensionValue(oid);
    }

    public byte[] getExtensionValue(String oid) {
        return this.exts.getExtensionValue(oid);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.exts.getNonCriticalOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public int hashCode() {
        if (this.serial == null || this.issuer == null) {
            return 0;
        }
        return this.serial.hashCode() ^ this.issuer.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X509Certificate)) {
            return false;
        }
        X509Certificate other = (X509Certificate)o;
        if (!this.serial.equals(other.getSerialNumber())) {
            return false;
        }
        return this.issuer.equals(other.getIssuerDN());
    }

    public void sign(PrivateKey key, AlgorithmID ai) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException {
        this.sign(key, ai, InitechProvider.NAME);
    }

    public void sign(PrivateKey key, AlgorithmID ai, String provider) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException {
        Signature sig = null;
        try {
            sig = provider == null ? Signature.getInstance(ai.getAlgName(), InitechProvider.NAME) : Signature.getInstance(ai.getAlgName(), provider);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            throw new CertificateException(e.toString());
        }
        this.sigAlg = (AlgorithmID)ai.clone();
        this.signatureAlg = (AlgorithmID)ai.clone();
        this.tbsModified = true;
        try {
            sig.initSign(key);
            sig.update(this.getTBSCertificate());
            this.signature.setByteArray(sig.sign());
        }
        catch (SignatureException e) {
            throw new CertificateException(e.toString());
        }
        this.modified = true;
    }

    public Extension getExtension(String oid) {
        return this.exts.getExtension(oid);
    }

    public Extensions getExtensions() {
        return this.exts;
    }

    public void addExtension(Extension ext) {
        this.tbsModified = true;
        this.exts.add(ext);
    }

    public void clearExtensions() {
        this.tbsModified = true;
        this.exts.clear();
    }

    public void removeExtension(String oid) {
        this.tbsModified = true;
        this.exts.remove(oid);
    }

    public boolean isSelfSigned() {
        if (this.subject == null || this.issuer == null) {
            return false;
        }
        if (this.subject.isNullDN() || this.issuer.isNullDN()) {
            return false;
        }
        return this.subject.equals(this.issuer);
    }

    public void setSerialNumber(BigInteger serial) {
        this.tbsModified = true;
        this.serial = serial;
    }

    public void setNotBefore(Date t) {
        this.tbsModified = true;
        this.notBefore.setTime(t);
    }

    public void setNotAfter(Date t) {
        this.tbsModified = true;
        this.notAfter.setTime(t);
    }

    public void setForceGeneralizedTime() {
        this.tbsModified = true;
        this.notBefore.setForceGeneralizedTime(true);
        this.notAfter.setForceGeneralizedTime(true);
    }

    public void setIssuerDN(Name d) {
        this.tbsModified = true;
        this.issuer = d;
    }

    public void setIssuerDN(String d) {
        this.tbsModified = true;
        this.issuer = new Name(d);
    }

    public void setSubjectDN(Name d) {
        this.tbsModified = true;
        this.subject = d;
    }

    public void setSubjectDN(String d) {
        this.tbsModified = true;
        this.subject = new Name(d);
    }

    public Name getSubjectName() throws CertificateException {
        return this.subject;
    }

    public SubjectAltName getSubjectAltName() throws CertificateException {
        try {
            byte[] b = this.getExtensionValue("2.5.29.17");
            SubjectAltName san = new SubjectAltName(b);
            return san;
        }
        catch (Exception ex) {
            throw new CertificateException(ex.getMessage());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("Version : ");
        buf.append(this.version);
        buf.append('\n');
        buf.append("Serial Number : 0x");
        buf.append(this.serial.toString(16));
        buf.append('\n');
        buf.append("Signature Algorithm : ");
        buf.append(this.sigAlg.getAlgName());
        buf.append('\n');
        buf.append("Issuer : ");
        buf.append(this.issuer.toString());
        buf.append('\n');
        buf.append("Not Before : ");
        buf.append(this.notBefore.toString());
        buf.append('\n');
        buf.append("Not After : ");
        buf.append(this.notAfter.toString());
        buf.append('\n');
        buf.append("Subject : ");
        buf.append(this.subject.toString());
        buf.append('\n');
        buf.append("Public Key : ");
        buf.append(this.keyInfo.getAlgName());
        buf.append('\n');
        buf.append(Hex.prettyDump(this.keyInfo.getPublicKeyAsByteArray(), 48, ' ', 1));
        buf.append('\n');
        if (this.issuerUID != null) {
            buf.append("Issuer User Identifier : ");
            buf.append(Hex.dumpHex(this.issuerUID));
            buf.append('\n');
        }
        if (this.subjectUID != null) {
            buf.append("Subject User Identifier : ");
            buf.append(Hex.dumpHex(this.subjectUID));
            buf.append('\n');
        }
        if (this.exts.size() > 0) {
            X509ExtensionBuilder builder = new X509ExtensionBuilder();
            buf.append("X509v3 Extensions :");
            buf.append('\n');
            for (int i = 0; i < this.exts.size(); ++i) {
                Extension ext = this.exts.elementAt(i);
                ext = builder.build(ext);
                ext.toString(buf, 1);
            }
        }
        buf.append("SignatureAlgorithm : ");
        buf.append(this.signatureAlg.getAlgName());
        buf.append('\n');
        buf.append("Signature : ");
        buf.append(this.signature.getUnusedBits());
        buf.append(" unused bits\n");
        buf.append(Hex.prettyDump(this.signature.getAsByteArray(), 48, ' ', 1));
        buf.append('\n');
        return new String(buf);
    }
}

