/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.BERDecoder;
import com.initech.cryptox.util.PEMInputStream;
import com.initech.x509.CRLs;
import com.initech.x509.Certificates;
import com.initech.x509.X509CRLImpl;
import com.initech.x509.X509CertImpl;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;

public class X509CertificateFactory
extends CertificateFactorySpi {
    public Certificate engineGenerateCertificate(InputStream inStream) throws CertificateException {
        X509CertImpl ret = null;
        InputStream in = null;
        in = inStream.markSupported() ? inStream : new BufferedInputStream(inStream);
        in.mark(30);
        try {
            return new X509CertImpl(in);
        }
        catch (Exception e) {
            try {
                in.reset();
            }
            catch (IOException ex) {
                throw new CertificateException(ex.toString());
            }
            try {
                PEMInputStream pin = new PEMInputStream(in, "CERTIFICATE");
                ret = new X509CertImpl(pin);
            }
            catch (Exception e2) {
                throw new CertificateException("X509CertImpl.decode() :" + e2.toString());
            }
            return ret;
        }
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        InputStream in = null;
        in = inStream.markSupported() ? inStream : new BufferedInputStream(inStream);
        in.mark(30);
        dummyPKCS7 dummy = new dummyPKCS7();
        try {
            BERDecoder dec = new BERDecoder(in);
            dummy.decode(dec, 0);
            return dummy.certs.getAsVector();
        }
        catch (ASN1Exception ex) {
            try {
                in.reset();
            }
            catch (IOException e) {
                throw new CertificateException(e.toString());
            }
            try {
                PEMInputStream pin = new PEMInputStream(in, "PKCS7");
                BERDecoder dec = new BERDecoder(pin);
                dummy.decode(dec, 0);
            }
            catch (Exception ex2) {
                throw new CertificateException(ex2.toString());
            }
            return dummy.certs.getAsVector();
        }
    }

    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        X509CRLImpl ret = null;
        InputStream in = null;
        in = inStream.markSupported() ? inStream : new BufferedInputStream(inStream);
        in.mark(30);
        try {
            return new X509CRLImpl(in);
        }
        catch (Exception e) {
            try {
                in.reset();
            }
            catch (IOException ex) {
                throw new CRLException(ex.toString());
            }
            try {
                PEMInputStream pin = new PEMInputStream(in, "X509 CRL");
                ret = new X509CRLImpl(pin);
            }
            catch (Exception e2) {
                throw new CRLException("X509CRLImpl.decode() :" + e2.toString());
            }
            return ret;
        }
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        InputStream in = null;
        in = inStream.markSupported() ? inStream : new BufferedInputStream(inStream);
        in.mark(30);
        dummyPKCS7 dummy = new dummyPKCS7();
        try {
            BERDecoder dec = new BERDecoder(in);
            dummy.decode(dec, 1);
            return dummy.crls.getAsVector();
        }
        catch (ASN1Exception ex) {
            try {
                in.reset();
            }
            catch (IOException e) {
                throw new CRLException(e.toString());
            }
            try {
                PEMInputStream pin = new PEMInputStream(in, "PKCS7");
                BERDecoder dec = new BERDecoder(pin);
                dummy.decode(dec, 1);
            }
            catch (Exception ex2) {
                throw new CRLException(ex2.toString());
            }
            return dummy.crls.getAsVector();
        }
    }

    protected class dummyPKCS7 {
        Certificates certs = new Certificates();
        CRLs crls = new CRLs();

        protected dummyPKCS7() {
        }

        public void decode(ASN1Decoder dec, int mode) throws ASN1Exception {
            int sd;
            int exp;
            int ci = dec.decodeSequence();
            ASN1OID type = dec.decodeObjectIdentifier();
            if ("1.2.840.113549.1.7.2".equals(type.get())) {
                exp = dec.decodeExplicit(ASN1Tag.makeContextTag(0));
                sd = dec.decodeSequence();
                dec.skipNextTag();
                dec.skipNextTag();
                dec.skipNextTag();
                if (!dec.nextIsOptional(ASN1Tag.makeExplicitTag(0))) {
                    if (mode == 0) {
                        dec.nextIsImplicit(ASN1Tag.makeContextTag(0));
                        this.certs.decode(dec);
                    } else {
                        dec.skipNextTag();
                    }
                }
                if (!dec.nextIsOptional(ASN1Tag.makeExplicitTag(1))) {
                    if (mode == 1) {
                        dec.nextIsImplicit(ASN1Tag.makeExplicitTag(1));
                        this.crls.decode(dec);
                    } else {
                        dec.skipNextTag();
                    }
                }
            } else {
                throw new ASN1Exception("no Certificates, Crl found");
            }
            dec.skipNextTag();
            dec.endOf(sd);
            dec.endOf(exp);
            dec.endOf(ci);
        }
    }
}

