/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509;

import com.initech.asn1.ASN1OID;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.ExtensionBuilder;
import com.initech.x509.extensions.AuthorityInfoAccess;
import com.initech.x509.extensions.AuthorityKeyIdentifier;
import com.initech.x509.extensions.BasicConstraints;
import com.initech.x509.extensions.CRLDistPoints;
import com.initech.x509.extensions.CRLNumber;
import com.initech.x509.extensions.CRLReason;
import com.initech.x509.extensions.CertificatePolicies;
import com.initech.x509.extensions.DeltaCRLIndicator;
import com.initech.x509.extensions.ExtKeyUsage;
import com.initech.x509.extensions.HoldInstruction;
import com.initech.x509.extensions.InhibitAnyPolicy;
import com.initech.x509.extensions.InvalidityDate;
import com.initech.x509.extensions.IssuerAltName;
import com.initech.x509.extensions.IssuingDistPoint;
import com.initech.x509.extensions.KeyUsage;
import com.initech.x509.extensions.NameConstraints;
import com.initech.x509.extensions.PolicyConstraints;
import com.initech.x509.extensions.PolicyMappings;
import com.initech.x509.extensions.PrivKeyUsagePeriod;
import com.initech.x509.extensions.SubjectAltName;
import com.initech.x509.extensions.SubjectInfoAccess;
import com.initech.x509.extensions.SubjectKeyIdentifier;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public final class X509ExtensionBuilder
implements ExtensionBuilder {
    private static Hashtable exts = new Hashtable(32);

    public Extension build(String oid, byte[] value) {
        return this.build(oid, false, value);
    }

    public Extension build(ASN1OID oid, byte[] value) {
        return this.build(oid.get(), false, value);
    }

    public Extension build(ASN1OID oid, boolean critical, byte[] value) {
        return this.build(oid.get(), critical, value);
    }

    public Extension build(String oid, boolean critical, byte[] value) {
        Extension ret;
        try {
            Constructor con = (Constructor)exts.get(oid);
            if (con == null) {
                Extension ret2 = new Extension();
                ret2.setExtensionID(oid);
                ret2.setCritical(critical);
                ret2.setExtension(value);
                return ret2;
            }
            Object[] param = new Object[]{value};
            ret = (Extension)con.newInstance(param);
            ret.setCritical(critical);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ret = new Extension();
            ret.setExtensionID(oid);
            ret.setCritical(critical);
            ret.setExtension(value);
        }
        return ret;
    }

    public Extension build(Extension ext) {
        Extension ret;
        try {
            Constructor con = (Constructor)exts.get(ext.getExtOID());
            if (con == null) {
                return ext;
            }
            Object[] param = new Object[]{ext.getExtValue()};
            ret = (Extension)con.newInstance(param);
            ret.setCritical(ext.isCritical());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ret = ext;
        }
        return ret;
    }

    private static void addExtension(String oid, Class c, Class[] param) {
        try {
            Constructor con = c.getConstructor(param);
            if (con != null) {
                exts.put(oid, con);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Class[] param = new Class[]{byte[].class};
        X509ExtensionBuilder.addExtension("1.3.6.1.5.5.7.1.1", AuthorityInfoAccess.class, param);
        X509ExtensionBuilder.addExtension("1.3.6.1.5.5.7.1.11", SubjectInfoAccess.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.14", SubjectKeyIdentifier.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.15", KeyUsage.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.16", PrivKeyUsagePeriod.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.17", SubjectAltName.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.18", IssuerAltName.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.19", BasicConstraints.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.20", CRLNumber.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.21", CRLReason.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.23", HoldInstruction.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.24", InvalidityDate.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.27", DeltaCRLIndicator.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.28", IssuingDistPoint.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.30", NameConstraints.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.31", CRLDistPoints.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.32", CertificatePolicies.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.33", PolicyMappings.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.35", AuthorityKeyIdentifier.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.36", PolicyConstraints.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.37", ExtKeyUsage.class, param);
        X509ExtensionBuilder.addExtension("2.5.29.54", InhibitAnyPolicy.class, param);
    }
}

