/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.GeneralName;
import com.initech.x509.extensions.AuthorityInfoAccess;
import com.initech.x509.extensions.SubjectInfoAccess;
import java.net.URL;

public class AccessDescription
extends ASN1Object {
    private static final long serialVersionUID = 5069432451493966052L;
    private ASN1OID method;
    private GeneralName loc;

    public AccessDescription() {
        this.method = new ASN1OID();
        this.loc = new GeneralName();
    }

    public AccessDescription(ASN1OID oid, GeneralName name) {
        this.method = oid;
        this.loc = name;
    }

    public AccessDescription(String oid, GeneralName name) {
        this(new ASN1OID(oid), name);
    }

    public AccessDescription(ASN1OID oid, URL url) {
        this.method = oid;
        this.loc = new GeneralName();
        this.loc.set(url);
    }

    public ASN1OID getMethod() {
        return this.method;
    }

    public GeneralName getName() {
        return this.loc;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeObjectIdentifier(this.method);
        this.loc.encode(enc);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.method = dec.decodeObjectIdentifier();
        this.loc.decode(dec);
        dec.endOf(id);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(40);
        if (this.method.equals(AuthorityInfoAccess.ocsp)) {
            buf.append("OCSP - ");
        } else if (this.method.equals(AuthorityInfoAccess.caIssuers)) {
            buf.append("CA Issuers - ");
        } else if (this.method.equals(SubjectInfoAccess.timestamping)) {
            buf.append("Timstamping - ");
        } else if (this.method.equals(SubjectInfoAccess.caRepository)) {
            buf.append("CA Repository - ");
        } else {
            buf.append(this.method.getName());
            buf.append(" - ");
        }
        buf.append(this.loc.toString(false, true));
        return new String(buf);
    }
}

