/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.GeneralName;
import com.initech.x509.extensions.AccessDescription;
import com.initech.x509.extensions.MultiValueExtension;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class AuthorityInfoAccess
extends Extension
implements MultiValueExtension {
    private static final long serialVersionUID = 1910712165291186212L;
    public static final String OID = "1.3.6.1.5.5.7.1.1";
    public static final ASN1OID ocsp = new ASN1OID("1.3.6.1.5.5.7.48.1");
    public static final ASN1OID caIssuers = new ASN1OID("1.3.6.1.5.5.7.48.2");
    public static final ASN1OID dvcs = new ASN1OID("1.3.6.1.5.5.7.48.4");
    private Vector acDescs;

    public AuthorityInfoAccess() {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.acDescs = new Vector();
    }

    public AuthorityInfoAccess(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void add(AccessDescription ad) {
        this.modified = true;
        this.acDescs.addElement(ad);
    }

    public Enumeration elements() {
        return this.acDescs.elements();
    }

    public void clear() {
        this.modified = true;
        this.acDescs.removeAllElements();
    }

    public int size() {
        return this.acDescs.size();
    }

    public GeneralName get(int idx) {
        if (idx < 0 || idx >= this.acDescs.size()) {
            return null;
        }
        return ((AccessDescription)this.acDescs.get(idx)).getName();
    }

    public GeneralName[] get(ASN1OID oid) {
        Vector<GeneralName> v = new Vector<GeneralName>(this.acDescs.size());
        for (int i = 0; i < this.acDescs.size(); ++i) {
            AccessDescription ad = (AccessDescription)this.acDescs.get(i);
            if (!oid.equals(ad.getMethod())) continue;
            v.addElement(ad.getName());
        }
        GeneralName[] ret = new GeneralName[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ret[i] = (GeneralName)v.get(i);
        }
        return ret;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.acDescs.size(); ++i) {
            AccessDescription ad = (AccessDescription)this.acDescs.elementAt(i);
            ad.encode(enc);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        this.acDescs.removeAllElements();
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            AccessDescription ad = new AccessDescription();
            ad.decode(dec);
            this.acDescs.addElement(ad);
        }
    }

    protected boolean shouldOmitted() {
        return this.acDescs.size() == 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert, String prefix, Properties props) {
        String value;
        this.acDescs.removeAllElements();
        this.setCritical(critical);
        int i = 1;
        while ((value = props.getProperty(prefix + i)) != null) {
            String oid = value.substring(0, value.indexOf(44));
            oid = oid.trim();
            String raw = value.substring(value.indexOf(44) + 1);
            raw = raw.trim();
            GeneralName gn = new GeneralName();
            gn.setFromString(raw);
            this.add(new AccessDescription(oid, gn));
            ++i;
        }
        return i > 1;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Authority Information Access:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.shouldOmitted()) {
            this.indent(buf, n + 1);
            buf.append("<empty>\n");
        } else {
            for (int i = 0; i < this.acDescs.size(); ++i) {
                AccessDescription ad = (AccessDescription)this.acDescs.elementAt(i);
                this.indent(buf, n + 1);
                buf.append(ad);
                buf.append('\n');
            }
        }
    }
}

