/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNames;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import com.initech.x509.extensions.SettableExtension;
import com.initech.x509.extensions.SubjectKeyIdentifier;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;

public class AuthorityKeyIdentifier
extends Extension
implements SettableExtension {
    private static final long serialVersionUID = -8245335339737951805L;
    public static final String OID = "2.5.29.35";
    private byte[] id = null;
    private GeneralNames aci = new GeneralNames();
    private BigInteger acsn;
    private boolean issuer = false;
    private static MessageDigest md;
    public static final int MATCH_NOT_MATCHED = -1;
    public static final int MATCH_NOT_SURE = 0;
    public static final int MATCH_MATCHED = 1;

    public AuthorityKeyIdentifier() {
        this.setExtensionID(OID);
        this.setCritical(false);
    }

    public AuthorityKeyIdentifier(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public AuthorityKeyIdentifier(PublicKey key) throws InvalidKeyException {
        this();
        this.setKID(key);
    }

    public synchronized void setKID(PublicKey key) throws InvalidKeyException {
        byte[] e = key.getEncoded();
        if (e == null) {
            throw new InvalidKeyException();
        }
        try {
            PublicKeyInfo pki = new PublicKeyInfo(e);
            e = pki.getPublicKeyAsByteArray();
        }
        catch (ASN1Exception ex) {
            throw new InvalidKeyException(ex.toString());
        }
        md.update(e);
        this.id = md.digest();
        md.reset();
    }

    public void setKID(byte[] kid) {
        this.modified = true;
        this.id = (byte[])kid.clone();
    }

    public void setCertSerial(BigInteger sn) {
        this.modified = true;
        this.acsn = sn;
    }

    public byte[] getKID() {
        if (this.id == null) {
            return null;
        }
        return (byte[])this.id.clone();
    }

    public BigInteger getCertSerial() {
        return this.acsn;
    }

    public void clearCertIssuer() {
        this.modified = true;
        this.aci.clear();
    }

    public void addCertIssuer(GeneralName gn) {
        this.modified = true;
        this.aci.add(gn);
    }

    public Enumeration getCertIssuer() {
        return this.aci.elements();
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id1 = enc.encodeSequence();
        if (this.id != null) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(0));
            enc.encodeOctetString(this.id);
        }
        if (this.aci.size() > 0) {
            enc.nextIsImplicit(ASN1Tag.makeExplicitTag(1));
            this.aci.encode(enc);
        }
        if (this.acsn != null) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(2));
            enc.encodeInteger(this.acsn);
        }
        enc.endOf(id1);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        this.issuer = false;
        DERDecoder dec = new DERDecoder(this.extVal);
        int id1 = dec.decodeSequence();
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(0))) {
            this.id = null;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(0));
            this.id = dec.decodeOctetString();
        }
        if (dec.nextIsOptional(ASN1Tag.makeExplicitTag(1))) {
            this.aci.clear();
        } else {
            dec.nextIsImplicit(ASN1Tag.makeExplicitTag(1));
            this.aci.decode(dec);
            this.issuer = true;
        }
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(2))) {
            this.acsn = null;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(2));
            this.acsn = dec.decodeInteger();
            this.issuer = true;
        }
        dec.endOf(id1);
    }

    protected boolean shouldOmitted() {
        return this.id == null && this.aci.size() == 0 && this.acsn == null;
    }

    public void setFromCertificate(X509Certificate cacert) {
        if (this.issuer) {
            GeneralName dummy = new GeneralName();
            dummy.set(4, ((Object)cacert.getSubjectDN()).toString());
            this.aci.add(dummy);
            this.acsn = cacert.getSerialNumber();
        } else {
            byte[] kid = cacert.getExtensionValue("2.5.29.14");
            if (kid == null) {
                PublicKey pkey = cacert.getPublicKey();
                try {
                    this.setKID(pkey);
                }
                catch (Exception ignore) {}
            } else {
                try {
                    SubjectKeyIdentifier skid = new SubjectKeyIdentifier(kid);
                    this.id = skid.getKID();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public int match(X509Certificate cert) {
        try {
            byte[] b_ski;
            int result = 0;
            if (this.id != null && (b_ski = cert.getExtensionValue("2.5.29.14")) != null) {
                SubjectKeyIdentifier ski = new SubjectKeyIdentifier(b_ski);
                if (!Arrays.equals(ski.getKID(), this.id)) {
                    return -1;
                }
                result = 1;
            }
            if (this.acsn != null) {
                if (!this.acsn.equals(cert.getSerialNumber())) {
                    return -1;
                }
                result = 1;
            }
            if (this.aci.size() > 0) {
                GeneralName gn = null;
                Principal p = cert.getSubjectDN();
                gn = p instanceof Name ? new GeneralName((Name)p) : new GeneralName(new Name(((Object)p).toString()));
                if (!this.aci.contains(gn)) {
                    return -1;
                }
                result = 1;
            }
            return result;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert) {
        this.setCritical(critical);
        if (rawValue.toLowerCase().equals("issuer:always")) {
            this.issuer = true;
        }
        this.setFromCertificate(cacert);
        return true;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Authority Key Identifier:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.id != null) {
            this.indent(buf, n + 1);
            buf.append("Key ID: ");
            Hex.dumpHex(buf, this.id, 0, this.id.length, ':');
            buf.append('\n');
        }
        if (this.issuer) {
            if (this.aci.size() > 0) {
                this.indent(buf, n + 1);
                buf.append("Certificate Issuer Names:\n");
                this.aci.toString(buf, n + 2, true);
            }
            if (this.acsn != null) {
                this.indent(buf, n + 1);
            }
            buf.append("Serial Number : 0x");
            buf.append(this.acsn.toString(16));
            buf.append('\n');
        }
    }

    static {
        try {
            md = MessageDigest.getInstance("SHA1", InitechProvider.NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

