/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.x509.extensions.SettableExtension;
import java.security.cert.X509Certificate;

public class BasicConstraints
extends Extension
implements SettableExtension {
    private static final long serialVersionUID = 8030367459063921189L;
    public static final String OID = "2.5.29.19";
    private boolean ca = false;
    private int pathlen = -1;
    private boolean allowFalseEnc = true;

    public BasicConstraints() {
        this(true, false, -1);
    }

    public BasicConstraints(boolean critical, boolean ca, int len) {
        this.setExtensionID(OID);
        this.setCritical(critical);
        this.setCA(ca);
        this.setPathLen(len);
    }

    public BasicConstraints(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public boolean isCA() {
        return this.ca;
    }

    public int getPathLen() {
        return this.ca && this.pathlen < 0 ? Integer.MAX_VALUE : this.pathlen;
    }

    public void setCA(boolean ca) {
        this.modified = true;
        this.ca = ca;
    }

    public void setPathLen(int len) {
        this.modified = true;
        this.pathlen = len;
    }

    public void allowInvalidEncoding() {
        this.allowFalseEnc = true;
    }

    public void disallowInvalidEncoding() {
        this.allowFalseEnc = false;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequence();
        if (this.ca) {
            enc.encodeBoolean(this.ca);
        }
        if (this.pathlen >= 0) {
            enc.encodeInteger(this.pathlen);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequence();
        this.ca = dec.nextIsDefault(1) ? false : dec.decodeBoolean();
        this.pathlen = dec.nextIsOptional(2) ? -1 : dec.decodeIntegerAsInt();
        dec.endOf(id);
    }

    protected boolean shouldOmitted() {
        if (this.allowFalseEnc) {
            return false;
        }
        return !this.ca && this.pathlen < 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert) {
        int idx;
        this.setCritical(critical);
        rawValue = rawValue.toLowerCase();
        if (rawValue.indexOf("ca:true") >= 0) {
            this.ca = true;
        }
        if ((idx = rawValue.indexOf("pathlen:")) >= 0) {
            try {
                this.pathlen = Integer.parseInt(rawValue.substring(idx + 8));
            }
            catch (Exception e) {
                this.pathlen = -1;
            }
        }
        return true;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Basic Constraints:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        buf.append("CA : ");
        if (this.ca) {
            buf.append("TRUE\n");
        } else {
            buf.append("FALSE\n");
        }
        if (this.ca) {
            this.indent(buf, n + 1);
            buf.append("PATHLEN : ");
            if (this.pathlen < 0) {
                buf.append("INFINITE");
            } else {
                buf.append(this.pathlen);
            }
            buf.append('\n');
        }
    }
}

