/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.cryptox.util.StringUtil;
import com.initech.x509.extensions.DistPoint;
import com.initech.x509.extensions.MultiValueExtension;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class CRLDistPoints
extends Extension
implements MultiValueExtension {
    private static final long serialVersionUID = -1798228072753447972L;
    public static final String OID = "2.5.29.31";
    private Vector distPts;

    public CRLDistPoints() {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.distPts = new Vector(4);
    }

    public CRLDistPoints(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void add(DistPoint dp) {
        this.modified = true;
        this.distPts.addElement(dp);
    }

    public void add(String[] uris, int[] reason, String[] names) {
        int i;
        this.modified = true;
        DistPoint dp = new DistPoint();
        for (i = 0; i < uris.length; ++i) {
            dp.addDistPointURI(uris[i]);
        }
        if (reason != null) {
            for (i = 0; i < reason.length; ++i) {
                dp.setReason(reason[i]);
            }
        }
        for (i = 0; i < names.length; ++i) {
            dp.addIssuer(names[i]);
        }
        this.distPts.addElement(dp);
    }

    public void clear() {
        this.modified = true;
        this.distPts.removeAllElements();
    }

    public Enumeration elements() {
        return this.distPts.elements();
    }

    public DistPoint elementAt(int i) {
        if (i < 0 || i > this.distPts.size() - 1) {
            return null;
        }
        return (DistPoint)this.distPts.elementAt(i);
    }

    public int size() {
        return this.distPts.size();
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.distPts.size(); ++i) {
            DistPoint dp = (DistPoint)this.distPts.elementAt(i);
            dp.encode(enc);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        this.distPts.removeAllElements();
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            DistPoint dp = new DistPoint();
            dp.decode(dec);
            this.distPts.addElement(dp);
        }
    }

    protected boolean shouldOmitted() {
        return this.distPts.size() == 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert, String prefix, Properties props) {
        int major = 1;
        int minor = 1;
        while (true) {
            String value;
            DistPoint dp = new DistPoint();
            minor = 1;
            while ((value = props.getProperty(prefix + major + ".URI." + minor)) != null) {
                dp.addDistPointURI(value);
                ++minor;
            }
            if (minor <= 1) break;
            value = props.getProperty(prefix + major + ".reasons");
            if (value != null) {
                dp.setReasons(value);
            }
            minor = 1;
            while ((value = props.getProperty(prefix + major + ".issuer." + minor)) != null) {
                dp.addIssuer(value);
                ++minor;
            }
            this.distPts.addElement(dp);
            ++major;
        }
        return this.distPts.size() > 0;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 CRL Distribution Points:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.distPts.size() == 0) {
            this.indent(buf, n + 1);
            buf.append("<empty>\n");
        } else {
            for (int i = 0; i < this.distPts.size(); ++i) {
                DistPoint dp = (DistPoint)this.distPts.elementAt(i);
                StringUtil.indent(buf, n + 1);
                buf.append("DistributionPoint:\n");
                dp.toString(buf, n + 2);
            }
        }
    }
}

