/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import java.math.BigInteger;

public class CRLNumber
extends Extension {
    private static final long serialVersionUID = -3357088218931413133L;
    public static final String OID = "2.5.29.20";
    private BigInteger number = null;

    public CRLNumber() {
        this.setExtensionID(OID);
        this.setCritical(false);
    }

    public CRLNumber(BigInteger n) {
        this();
        this.number = n;
    }

    public CRLNumber(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void setCRLNumber(BigInteger n) {
        this.modified = true;
        this.number = n;
    }

    public BigInteger getCRLNumber() {
        return this.number;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        enc.encodeInteger(this.number);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        this.number = dec.decodeInteger();
    }

    protected boolean shouldOmitted() {
        return this.number == null;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 CRL Number:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        if (this.shouldOmitted()) {
            buf.append("<empty>\n");
        } else {
            buf.append("0x");
            buf.append(this.number.toString(16));
            buf.append('\n');
        }
    }
}

