/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;

public class CRLReason
extends Extension {
    private static final long serialVersionUID = 1080289119649303067L;
    public static final String OID = "2.5.29.21";
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private int reason = 0;

    public CRLReason() {
        this.setExtensionID(OID);
        this.setCritical(false);
    }

    public CRLReason(int reason) {
        this();
        this.reason = reason;
    }

    public CRLReason(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void setCRLReason(int r) {
        this.modified = true;
        this.reason = r;
    }

    public int getCRLReason() {
        return this.reason;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        enc.encodeEnumeration(this.reason);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        this.reason = dec.decodeEnumeration();
    }

    protected boolean shouldOmitted() {
        return this.reason == 0;
    }

    public static int getCRLReason(String r) {
        int ret = 0;
        if (r.equalsIgnoreCase("KEYCOMPROMISE")) {
            ret = 1;
        } else if (r.equalsIgnoreCase("CACOMPROMISE")) {
            ret = 2;
        } else if (r.equalsIgnoreCase("AFFILIATIONCHANGED")) {
            ret = 3;
        } else if (r.equalsIgnoreCase("SUPERSEDED")) {
            ret = 4;
        } else if (r.equalsIgnoreCase("CESSATIONOFOPERATION")) {
            ret = 5;
        } else if (r.equalsIgnoreCase("CERTIFICATEHOLD")) {
            ret = 6;
        } else if (r.equalsIgnoreCase("REMOVEFROMCRL")) {
            ret = 8;
        } else if (r.equalsIgnoreCase("PRIVILEGEWITHDRAWN")) {
            ret = 9;
        } else if (r.equalsIgnoreCase("AACOMPROMISE")) {
            ret = 10;
        }
        return ret;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 CRL Reason:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        switch (this.reason) {
            case 0: {
                buf.append("Unspecified\n");
                break;
            }
            case 1: {
                buf.append("Key Compromise\n");
                break;
            }
            case 2: {
                buf.append("CA Compromise\n");
                break;
            }
            case 3: {
                buf.append("Affiliation Changed\n");
                break;
            }
            case 4: {
                buf.append("Superseded\n");
                break;
            }
            case 5: {
                buf.append("Cessation Of Operation\n");
                break;
            }
            case 6: {
                buf.append("Certificate Hold\n");
                break;
            }
            case 8: {
                buf.append("Remove From CRL\n");
                break;
            }
            case 9: {
                buf.append("Privilege Withdrawn\n");
                break;
            }
            case 10: {
                buf.append("AA Compromise\n");
            }
        }
    }
}

