/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.x509.extensions.MultiValueExtension;
import com.initech.x509.extensions.PolicyInfo;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class CertificatePolicies
extends Extension
implements MultiValueExtension {
    private static final long serialVersionUID = 3739757046105978778L;
    public static final String OID = "2.5.29.32";
    public static final PolicyInfo anyPolicy = new PolicyInfo(PolicyInfo.anyPolicy);
    private Vector policies;

    public CertificatePolicies() {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.policies = new Vector();
    }

    public CertificatePolicies(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void add(PolicyInfo info) {
        this.modified = true;
        this.policies.addElement(info);
    }

    public void clear() {
        this.modified = true;
        this.policies.removeAllElements();
    }

    public Enumeration elements() {
        return this.policies.elements();
    }

    public int size() {
        return this.policies.size();
    }

    public PolicyInfo policyAt(int i) {
        if (i < 0 || i >= this.policies.size()) {
            return null;
        }
        return (PolicyInfo)this.policies.elementAt(i);
    }

    public ASN1OID[] getPolicyIDs() {
        ASN1OID[] oids = new ASN1OID[this.policies.size()];
        for (int i = 0; i < oids.length; ++i) {
            oids[i] = this.policyAt(i).getPolicyID();
        }
        return oids;
    }

    public PolicyInfo getPolicy(ASN1OID oid) {
        for (int i = 0; i < this.policies.size(); ++i) {
            PolicyInfo pi = (PolicyInfo)this.policies.elementAt(i);
            if (!pi.equals(oid)) continue;
            return pi;
        }
        return null;
    }

    public boolean containsAnyPolicy() {
        for (int i = 0; i < this.policies.size(); ++i) {
            PolicyInfo pi = (PolicyInfo)this.policies.elementAt(i);
            if (!pi.equals(anyPolicy)) continue;
            return true;
        }
        return false;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.policies.size(); ++i) {
            PolicyInfo pi = (PolicyInfo)this.policies.elementAt(i);
            pi.encode(enc);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        this.policies.removeAllElements();
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            PolicyInfo pi = new PolicyInfo();
            pi.decode(dec);
            this.policies.addElement(pi);
        }
    }

    protected boolean shouldOmitted() {
        return this.policies.size() == 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert, String prefix, Properties props) {
        int major = 1;
        while (true) {
            PolicyInfo pi = new PolicyInfo();
            String value = props.getProperty(prefix + major + ".policyid");
            if (value == null) break;
            pi.setPolicyID(value);
            pi.loadQualifiers(prefix + major + ".qualifier.", props, pi);
            this.policies.addElement(pi);
            ++major;
        }
        return this.policies.size() > 0;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Certificate Policies:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.shouldOmitted()) {
            this.indent(buf, n + 1);
            buf.append("<empty>\n");
        } else {
            for (int i = 0; i < this.policies.size(); ++i) {
                PolicyInfo pi = (PolicyInfo)this.policies.elementAt(i);
                this.indent(buf, n + 1);
                buf.append("Policy Information:\n");
                pi.toString(buf, n + 2);
            }
        }
    }
}

