/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.useful.GeneralNames;
import com.initech.asn1.useful.RDN;
import com.initech.cryptox.util.StringUtil;

class DPN
implements ASN1Type {
    private static final long serialVersionUID = -4716011844948793128L;
    protected GeneralNames fullName = new GeneralNames();
    protected RDN rname = new RDN();
    protected int selected = -1;
    private int[] taglist = new int[]{160, 161};

    DPN() {
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(0, this.taglist);
        if (!this.rname.isNull()) {
            enc.nextIsImplicit(this.taglist[1]);
            this.rname.encode(enc);
        } else {
            enc.nextIsImplicit(this.taglist[0]);
            this.fullName.encode(enc);
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.fullName.clear();
        this.rname.clear();
        int tag = dec.decodeChoice(this.taglist);
        if (tag == this.taglist[0]) {
            dec.nextIsImplicit(this.taglist[0]);
            this.fullName.decode(dec);
            this.selected = 0;
        } else if (tag == this.taglist[1]) {
            dec.nextIsImplicit(this.taglist[1]);
            this.rname.decode(dec);
            this.selected = 1;
        } else {
            throw new ASN1Exception("Unexpected tag: " + ASN1Tag.tagToString(tag));
        }
    }

    public void toString(StringBuffer buf, int n) {
        if (this.rname.isNull()) {
            if (this.fullName.size() == 0) {
                StringUtil.indent(buf, n);
                buf.append("Full Name : <empty>\n");
            } else {
                StringUtil.indent(buf, n);
                buf.append("Full Name :\n");
                this.fullName.toString(buf, n + 1, true);
            }
        } else {
            StringUtil.indent(buf, n);
            buf.append("Name Relative to CRL Issuer : ");
            buf.append(this.rname.toString());
            buf.append('\n');
        }
    }
}

