/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import java.math.BigInteger;

public class DeltaCRLIndicator
extends Extension {
    private static final long serialVersionUID = -7860748558162661139L;
    public static final String OID = "2.5.29.27";
    private BigInteger number = null;

    public DeltaCRLIndicator() {
        this.setExtensionID(OID);
        this.setCritical(false);
    }

    public DeltaCRLIndicator(BigInteger n) {
        this();
        this.number = n;
    }

    public DeltaCRLIndicator(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void setDeltaCRLIndicator(BigInteger n) {
        this.modified = true;
        this.number = n;
    }

    public BigInteger getDeltaCRLIndicator() {
        return this.number;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        enc.encodeInteger(this.number);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        this.number = dec.decodeInteger();
    }

    protected boolean shouldOmitted() {
        return this.number == null;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Delta CRL Indicator:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        if (this.shouldOmitted()) {
            buf.append("<empty>\n");
        } else {
            buf.append("0x");
            buf.append(this.number.toString(16));
            buf.append('\n');
        }
    }
}

