/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNames;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.RDN;
import com.initech.cryptox.util.StringUtil;
import com.initech.x509.extensions.DPN;
import com.initech.x509.extensions.ReasonFlags;

public class DistPoint
extends ASN1Object {
    private static final long serialVersionUID = 3159464150588282555L;
    private DPN dpn = null;
    private ReasonFlags reasons = null;
    private GeneralNames issuer = new GeneralNames();
    private static final int DPN_TAG = 160;
    private static final int REASON_TAG = 129;
    private static final int ISSUER_TAG = 162;

    public void setReason(int reason) {
        this.modified = true;
        if (this.reasons == null) {
            this.reasons = new ReasonFlags();
        }
        this.reasons.set(reason);
    }

    public void unsetReason(int reason) {
        this.modified = true;
        if (this.reasons == null) {
            this.reasons = new ReasonFlags();
        }
        this.reasons.unset(reason);
    }

    public void setReasons(String reason) {
        this.modified = true;
        if (this.reasons == null) {
            this.reasons = new ReasonFlags();
        }
        this.reasons.setReasons(reason);
    }

    public boolean isAReason(int query) {
        if (this.reasons == null) {
            return true;
        }
        return this.reasons.isAReason(query);
    }

    public void addIssuer(String name) {
        this.modified = true;
        GeneralName t = new GeneralName();
        t.setFromString(name);
        this.issuer.add(t);
    }

    public void addIssuer(Name name) {
        this.modified = true;
        GeneralName t = new GeneralName(name);
        this.issuer.add(t);
    }

    public void addDistPointURI(String[] uri) {
        for (int i = 0; i < uri.length; ++i) {
            this.addDistPointURI(uri[i]);
        }
    }

    public void addDistPointURI(String uri) {
        this.modified = true;
        GeneralName name = new GeneralName();
        name.set(6, uri);
        if (this.dpn == null) {
            this.dpn = new DPN();
        }
        this.dpn.fullName.add(name);
        this.dpn.selected = 0;
    }

    public void addDistPointName(String n) {
        this.modified = true;
        GeneralName name = new GeneralName();
        name.set(4, n);
        if (this.dpn == null) {
            this.dpn = new DPN();
        }
        this.dpn.fullName.add(name);
        this.dpn.selected = 0;
    }

    public void setDistPointRDN(String name) throws IllegalArgumentException {
        this.modified = true;
        if (this.dpn == null) {
            this.dpn = new DPN();
        }
        this.dpn.rname.set(name);
        this.dpn.selected = 1;
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public boolean containsFullName() {
        return this.dpn != null && this.dpn.selected == 0;
    }

    public GeneralNames getFullName() {
        if (this.dpn == null || this.dpn.selected == 1) {
            return null;
        }
        return this.dpn.fullName;
    }

    public RDN getRDN() {
        if (this.dpn == null || this.dpn.selected == 0) {
            return null;
        }
        return this.dpn.rname;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        if (this.dpn != null) {
            int exp = enc.encodeExplicit(160);
            this.dpn.encode(enc);
            enc.endOf(exp);
        }
        if (this.reasons != null) {
            enc.nextIsImplicit(129);
            this.reasons.encode(enc);
        }
        if (this.issuer.size() > 0) {
            enc.nextIsImplicit(162);
            this.issuer.encode(enc);
        }
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        if (dec.nextIsOptional(160)) {
            this.dpn = null;
        } else {
            this.dpn = new DPN();
            int exp = dec.decodeExplicit(160);
            this.dpn.decode(dec);
            dec.endOf(exp);
        }
        if (dec.nextIsOptional(129)) {
            this.reasons = null;
        } else {
            this.reasons = new ReasonFlags();
            dec.nextIsImplicit(129);
            this.reasons.decode(dec);
        }
        if (dec.nextIsOptional(162)) {
            this.issuer.clear();
        } else {
            dec.nextIsImplicit(162);
            this.issuer.decode(dec);
        }
        dec.endOf(id);
    }

    protected boolean shouldOmitted() {
        return this.dpn == null && this.reasons == null && this.issuer.size() == 0;
    }

    public void toString(StringBuffer buf, int n) {
        if (this.dpn != null) {
            StringUtil.indent(buf, n);
            buf.append("Distribution Point Name:\n");
            this.dpn.toString(buf, n + 1);
        }
        if (this.reasons != null && !this.reasons.isClean()) {
            StringUtil.indent(buf, n);
            buf.append("Reasons :\n");
            StringUtil.indent(buf, n + 1);
            buf.append(this.reasons.toString());
            buf.append('\n');
        }
        if (this.issuer.size() > 0) {
            StringUtil.indent(buf, n);
            buf.append("CRL Issuer :\n");
            this.issuer.toString(buf, n + 1, true);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(40);
        this.toString(buf, 0);
        return new String(buf);
    }
}

