/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.OIDDictionary;
import com.initech.asn1.useful.Extension;
import com.initech.x509.extensions.SettableExtension;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExtKeyUsage
extends Extension
implements SettableExtension {
    private static final long serialVersionUID = 3264856312796481315L;
    public static final String OID = "2.5.29.37";
    public static final String SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    public static final String CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    public static final String CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    public static final String EMAIL_PROTECTION = "1.3.6.1.5.5.7.3.4";
    public static final String IPSEC_END_SYSTEM = "1.3.6.1.5.5.7.3.5";
    public static final String IPSEC_TUNNEL = "1.3.6.1.5.5.7.3.6";
    public static final String IPSEC_USER = "1.3.6.1.5.5.7.3.7";
    public static final String TIME_STAMPING = "1.3.6.1.5.5.7.3.8";
    public static final String OCSP_SIGNING = "1.3.6.1.5.5.7.3.9";
    public static final String KISA_HSM = "1.2.410.200004.10.1.2";
    public static final String ANY_EXTENDED_KEY_USAGE = "2.5.29.37.0";
    public static final ASN1OID anyExtendedKeyUsage = new ASN1OID("2.5.29.37.0");
    private Vector ids = new Vector();
    private Hashtable lookup = new Hashtable();

    public ExtKeyUsage() {
        this(false);
    }

    public ExtKeyUsage(boolean c) {
        this.setExtensionID(OID);
        this.setCritical(c);
    }

    public ExtKeyUsage(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public boolean isProperUsage(ASN1OID purpose) {
        return this.lookup.get(purpose.get()) != null;
    }

    public boolean isProperUsage(String purpose) {
        String id = purpose;
        if (!ASN1OID.isOID(id) && (id = OIDDictionary.getOIDbyName(purpose)) == null) {
            return false;
        }
        return this.lookup.get(id) != null;
    }

    public boolean containsAnyExtendedKeyUsage() {
        return this.lookup.get(anyExtendedKeyUsage) != null;
    }

    public void addUsage(ASN1OID oid) {
        this.ids.addElement(oid);
        this.lookup.put(oid.get(), oid);
    }

    public void addUsage(String purpose) {
        String id = purpose;
        if (!ASN1OID.isOID(id) && (id = OIDDictionary.getOIDbyName(purpose)) == null) {
            throw new IllegalArgumentException("Invalid Object Identifier : " + purpose);
        }
        this.modified = true;
        this.addUsage(new ASN1OID(id));
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequenceOf();
        Enumeration e = this.ids.elements();
        while (e.hasMoreElements()) {
            ASN1OID i = (ASN1OID)e.nextElement();
            enc.encodeObjectIdentifier(i);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        this.ids.removeAllElements();
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            ASN1OID i = dec.decodeObjectIdentifier();
            this.ids.addElement(i);
            this.lookup.put(i.get(), i);
        }
    }

    protected boolean shouldOmitted() {
        return this.ids.size() == 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert) {
        this.setCritical(critical);
        StringTokenizer st = new StringTokenizer(rawValue, "\t\n\r\f, ");
        while (st.hasMoreTokens()) {
            String p = st.nextToken();
            if (!ASN1OID.isOID(p) && (p = OIDDictionary.getOIDbyName(p)) == null) continue;
            this.addUsage(p);
        }
        return this.ids.size() > 0;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Extended Key Usage:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        if (this.ids.size() == 0) {
            buf.append("<empty>");
        } else {
            for (int i = 0; i < this.ids.size(); ++i) {
                ASN1OID oid = (ASN1OID)this.ids.elementAt(i);
                buf.append(oid.getName());
                if (i >= this.ids.size() - 1) continue;
                buf.append(',');
                buf.append(' ');
            }
        }
        buf.append('\n');
    }
}

