/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.useful.GeneralName;
import com.initech.cryptox.util.StringUtil;

public class GeneralSubTree
implements ASN1Type {
    private static final long serialVersionUID = 2957014951930634629L;
    GeneralName base = new GeneralName();
    int min = 0;
    int max = -1;

    public GeneralSubTree() {
    }

    public GeneralSubTree(GeneralName b, int min, int max) {
        this.base = b;
        this.setMinumum(min);
        this.setMaximum(max);
    }

    public GeneralName getName() {
        return this.base;
    }

    public GeneralName getBase() {
        return this.base;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setBase(GeneralName n) {
        this.base = n;
    }

    public void setMinumum(int min) {
        this.min = min > 0 ? min : 0;
    }

    public void setMaximum(int max) {
        int n = this.max = max < 0 ? -1 : max;
        if (max < this.min) {
            max = -1;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof GeneralSubTree)) {
            return false;
        }
        GeneralSubTree ogst = (GeneralSubTree)o;
        if (!this.base.equals(ogst.base)) {
            return false;
        }
        if (this.min != ogst.min) {
            return false;
        }
        return this.max == ogst.max;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq = enc.encodeSequence();
        this.base.encode(enc);
        if (this.min > 0) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(0));
            enc.encodeInteger(this.min);
        }
        if (this.max >= 0) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(1));
            enc.encodeInteger(this.min);
        }
        enc.endOf(seq);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq = dec.decodeSequence();
        this.base.decode(dec);
        if (dec.nextIsDefault(ASN1Tag.makeContextTag(0))) {
            this.min = 0;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(0));
            this.min = dec.decodeIntegerAsInt();
        }
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(1))) {
            this.max = -1;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(1));
            this.max = dec.decodeIntegerAsInt();
        }
        dec.endOf(seq);
    }

    public void toString(StringBuffer buf, int n) {
        StringUtil.indent(buf, n);
        buf.append("Base : ");
        buf.append(this.base.toString(true, true));
        buf.append('\n');
        StringUtil.indent(buf, n);
        buf.append("Minimum : ");
        buf.append(this.min);
        buf.append('\n');
        if (this.max >= 0) {
            StringUtil.indent(buf, n);
            buf.append("Maximum : ");
            buf.append(this.max);
            buf.append('\n');
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(40);
        this.toString(buf, 0);
        return new String(buf);
    }
}

