/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.DNSName;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.asn1.useful.IPAddressName;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.RFC822Name;
import com.initech.asn1.useful.URIName;
import com.initech.x509.extensions.GeneralSubTree;
import java.util.ArrayList;

public class GeneralSubTrees
implements Cloneable {
    ArrayList names;

    GeneralSubTrees(ArrayList v) {
        this.names = v;
    }

    public GeneralSubTrees() {
        this.names = new ArrayList(4);
    }

    public void add(GeneralSubTree gst) {
        this.names.add(gst);
    }

    public void remove(GeneralSubTree gst) {
        this.names.remove(gst);
    }

    public void remove(int i) {
        this.names.remove(i);
    }

    public void clear() {
        this.names.clear();
    }

    public int size() {
        return this.names.size();
    }

    public boolean isEmpty() {
        return this.names.size() == 0;
    }

    public GeneralName getName(int i) {
        if (i < 0 || i > this.names.size() - 1) {
            return null;
        }
        GeneralSubTree gst = (GeneralSubTree)this.names.get(i);
        return gst == null ? null : gst.getName();
    }

    public GeneralNameInterface getGeneralNameInterface(int i) {
        GeneralName gn = this.getName(i);
        if (gn == null) {
            return null;
        }
        return gn.getGeneralNameInterface();
    }

    public GeneralSubTree getGeneralSubTree(int i) {
        if (i < 0 || i > this.names.size() - 1) {
            return null;
        }
        return (GeneralSubTree)this.names.get(i);
    }

    public static GeneralSubTrees getWidestSubTrees() {
        GeneralSubTrees trees = new GeneralSubTrees();
        trees.add(new GeneralSubTree(new GeneralName(new Name()), 0, -1));
        trees.add(new GeneralSubTree(new GeneralName(new RFC822Name("")), 0, -1));
        trees.add(new GeneralSubTree(new GeneralName(new URIName("")), 0, -1));
        trees.add(new GeneralSubTree(new GeneralName(new DNSName("")), 0, -1));
        trees.add(new GeneralSubTree(new GeneralName(new IPAddressName((byte[])null)), 0, -1));
        return trees;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.names.size(); ++i) {
            GeneralSubTree gst = (GeneralSubTree)this.names.get(i);
            gst.encode(enc);
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.names.clear();
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            GeneralSubTree gst = new GeneralSubTree();
            gst.decode(dec);
            this.names.add(gst);
        }
    }

    private void minimize() {
        for (int i = 0; i < this.names.size(); ++i) {
            GeneralNameInterface gni = this.getGeneralNameInterface(i);
            boolean remove = false;
            block7: for (int j = i + 1; j < this.names.size(); ++j) {
                GeneralNameInterface gni2 = this.getGeneralNameInterface(j);
                switch (gni.constrains(gni2)) {
                    case -1: 
                    case 3: {
                        continue block7;
                    }
                    case 0: {
                        remove = true;
                        break block7;
                    }
                    case 2: {
                        this.names.remove(j);
                        --j;
                        continue block7;
                    }
                    case 1: {
                        remove = true;
                        break block7;
                    }
                }
            }
            if (!remove) continue;
            this.names.remove(i);
            --i;
        }
    }

    public void union(GeneralSubTrees gs) {
        if (gs != null) {
            for (int i = 0; i < gs.size(); ++i) {
                this.names.add(gs.getGeneralSubTree(i));
            }
            this.minimize();
        }
    }

    public GeneralSubTrees intersect(GeneralSubTrees gsts) {
        if (gsts == null) {
            return (GeneralSubTrees)this.clone();
        }
        if (this.names.size() == 0 || gsts.size() == 0) {
            return (GeneralSubTrees)this.clone();
        }
        GeneralSubTrees ret = new GeneralSubTrees();
        this.minimize();
        gsts.minimize();
        GeneralSubTrees my = (GeneralSubTrees)this.clone();
        GeneralSubTrees other = (GeneralSubTrees)gsts.clone();
        for (int i = 0; i < my.size(); ++i) {
            GeneralSubTree gst = my.getGeneralSubTree(i);
            GeneralNameInterface gni = gst.getName().getGeneralNameInterface();
            boolean intersectFound = false;
            block6: for (int j = 0; j < other.size(); ++j) {
                GeneralSubTree gst2 = other.getGeneralSubTree(j);
                GeneralNameInterface gni2 = gst2.getName().getGeneralNameInterface();
                switch (gni.constrains(gni2)) {
                    case 0: 
                    case 1: {
                        ret.add(gst);
                        intersectFound = true;
                        continue block6;
                    }
                    case 2: {
                        ret.add(gst2);
                        intersectFound = true;
                        continue block6;
                    }
                    case 3: {
                        intersectFound = true;
                        continue block6;
                    }
                }
            }
            if (intersectFound) continue;
            ret.add(gst);
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        this.toString(buf, 1);
        return new String(buf);
    }

    public void toString(StringBuffer buf, int n) {
        for (int i = 0; i < this.names.size(); ++i) {
            GeneralSubTree gst = (GeneralSubTree)this.names.get(i);
            gst.toString(buf, n);
        }
    }

    public Object clone() {
        ArrayList v = (ArrayList)this.names.clone();
        return new GeneralSubTrees(v);
    }
}

