/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;

public class HoldInstruction
extends Extension {
    private static final long serialVersionUID = -102780043126333506L;
    public static final String OID = "2.5.29.23";
    public static final ASN1OID none = new ASN1OID("1.2.840.10040.2.1");
    public static final ASN1OID callIssuer = new ASN1OID("1.2.840.10040.2.2");
    public static final ASN1OID reject = new ASN1OID("1.2.840.10040.2.3");
    private ASN1OID code = new ASN1OID();

    public HoldInstruction() {
        this.setExtensionID(OID);
        this.setCritical(false);
    }

    public HoldInstruction(String oid) {
        this();
        this.code.set(oid);
    }

    public HoldInstruction(ASN1OID oid) {
        this();
        this.code = oid;
    }

    public HoldInstruction(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void setInstruction(ASN1OID oid) {
        this.modified = true;
        this.code = oid;
    }

    public ASN1OID getInstruction() {
        return this.code;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        enc.encodeObjectIdentifier(this.code);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        this.code = dec.decodeObjectIdentifier();
    }

    protected boolean shouldOmitted() {
        return this.code.get() == null;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Hold Instruction:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        if (this.shouldOmitted()) {
            buf.append("<empty>\n");
        } else {
            if (this.code.equals(none)) {
                buf.append("None");
            } else if (this.code.equals(callIssuer)) {
                buf.append("Call Issuer");
            } else if (this.code.equals(reject)) {
                buf.append("Reject");
            } else {
                buf.append(this.code.get());
            }
            buf.append('\n');
        }
    }
}

