/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;

public class InhibitAnyPolicy
extends Extension {
    private static final long serialVersionUID = 6499234109829472452L;
    public static final String OID = "2.5.29.54";
    private int skipCerts = -1;

    public InhibitAnyPolicy() {
        this.setExtensionID(OID);
        this.setCritical(false);
    }

    public InhibitAnyPolicy(int n) {
        this();
        this.skipCerts = n;
    }

    public InhibitAnyPolicy(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void setSkipCerts(int n) {
        this.modified = true;
        this.skipCerts = n;
    }

    public int getSkipCerts() {
        return this.skipCerts;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        enc.encodeInteger(this.skipCerts);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        this.skipCerts = dec.decodeIntegerAsInt();
    }

    protected boolean shouldOmitted() {
        return this.skipCerts < 0;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Inhibit Any Policy:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        if (this.shouldOmitted()) {
            buf.append("<empty>\n");
        } else {
            buf.append("Inhibit : ");
            buf.append(this.skipCerts);
            buf.append('\n');
        }
    }
}

