/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import java.util.Date;

public class InvalidityDate
extends Extension {
    private static final long serialVersionUID = -3894587981542599756L;
    public static final String OID = "2.5.29.24";
    private Date invd;

    public InvalidityDate() {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.invd = new Date();
    }

    public InvalidityDate(Date d) {
        this();
        this.invd = new Date(d.getTime());
    }

    public InvalidityDate(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void setInvalidityDate(Date d) {
        this.modified = true;
        this.invd = new Date(d.getTime());
    }

    public Date getInvalidityDate() {
        return new Date(this.invd.getTime());
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        enc.encodeGeneralizedTime(this.invd);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        this.invd = dec.decodeGeneralizedTime();
    }

    protected boolean shouldOmitted() {
        return this.invd == null;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Invalidity Date:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        if (this.shouldOmitted()) {
            buf.append("<empty>\n");
        } else {
            buf.append(this.invd);
            buf.append('\n');
        }
    }
}

