/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.asn1.useful.GeneralNames;
import com.initech.x509.extensions.MultiValueExtension;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;

public class IssuerAltName
extends Extension
implements MultiValueExtension {
    private static final long serialVersionUID = -6997898687320624878L;
    public static final String OID = "2.5.29.18";
    private GeneralNames names;

    public IssuerAltName() {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.names = new GeneralNames();
    }

    public IssuerAltName(GeneralNames ns) {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.names = ns;
    }

    public IssuerAltName(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void add(GeneralName name) {
        this.modified = true;
        this.names.add(name);
    }

    public void add(GeneralNameInterface gni) {
        this.modified = true;
        this.names.add(new GeneralName(gni));
    }

    public void add(int id, String val) {
        this.modified = true;
        GeneralName gn = new GeneralName();
        gn.set(id, val);
        this.names.add(gn);
    }

    public void clear() {
        this.names.clear();
    }

    public int size() {
        return this.names.size();
    }

    public Enumeration elements() {
        return this.names.elements();
    }

    public GeneralName elementAt(int i) {
        return this.names.elementAt(i);
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        this.names.encode(enc);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        this.names.decode(dec);
    }

    protected boolean shouldOmitted() {
        return this.names.size() == 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert, String prefix, Properties props) {
        String value;
        this.setCritical(critical);
        int i = 1;
        while ((value = props.getProperty(prefix + i)) != null) {
            GeneralName dummy = new GeneralName();
            dummy.setFromString(value);
            this.names.add(dummy);
            ++i;
        }
        return i > 1;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Issuer Alternative Name:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.shouldOmitted()) {
            this.indent(buf, n + 1);
            buf.append("<empty>\n");
        } else {
            this.names.toString(buf, n + 1, true);
        }
    }
}

