/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNames;
import com.initech.asn1.useful.RDN;
import com.initech.x509.extensions.DPN;
import com.initech.x509.extensions.MultiValueExtension;
import com.initech.x509.extensions.ReasonFlags;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;

public class IssuingDistPoint
extends Extension
implements MultiValueExtension {
    private static final long serialVersionUID = -2722452103227324151L;
    public static final String OID = "2.5.29.28";
    private DPN dpn = null;
    private boolean onlyUsrcrt = false;
    private boolean onlyCAcrt = false;
    private ReasonFlags onlySomeReasons = null;
    private boolean indirect = false;
    private boolean onlyAC = false;

    public IssuingDistPoint() {
        this.setExtensionID(OID);
        this.setCritical(true);
    }

    public IssuingDistPoint(byte[] data) throws ASN1Exception {
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void setContainUserCert(boolean id) {
        this.modified = true;
        this.onlyUsrcrt = id;
    }

    public void setContainCACert(boolean id) {
        this.modified = true;
        this.onlyCAcrt = id;
    }

    public void setIndirect(boolean id) {
        this.modified = true;
        this.indirect = id;
    }

    public void setReason(int f) {
        this.modified = true;
        if (this.onlySomeReasons == null) {
            this.onlySomeReasons = new ReasonFlags();
        }
        this.onlySomeReasons.set(f);
    }

    public void unsetReason(int f) {
        this.modified = true;
        if (this.onlySomeReasons == null) {
            this.onlySomeReasons = new ReasonFlags();
        }
        this.onlySomeReasons.unset(f);
    }

    public void addDistPoint(GeneralName gn) {
        this.modified = true;
        if (this.dpn == null) {
            this.dpn = new DPN();
        }
        this.dpn.fullName.add(gn);
    }

    public void clearDistPoint() {
        this.modified = true;
        this.dpn.fullName.clear();
    }

    public int sizeDistPoint() {
        return this.dpn.fullName.size();
    }

    public Enumeration elementDistPoint() {
        return this.dpn.fullName.elements();
    }

    public boolean containsFullName() {
        return this.dpn != null && this.dpn.selected == 0;
    }

    public GeneralNames getFullName() {
        if (this.dpn == null || this.dpn.selected == 1) {
            return null;
        }
        return this.dpn.fullName;
    }

    public RDN getRDN() {
        if (this.dpn == null || this.dpn.selected == 0) {
            return null;
        }
        return this.dpn.rname;
    }

    public boolean containDistPoint() {
        return this.dpn != null;
    }

    public boolean containOnlyUserCert() {
        return this.onlyUsrcrt;
    }

    public boolean containOnlyCACert() {
        return this.onlyCAcrt;
    }

    public boolean containOnlyAttributeCert() {
        return this.onlyAC;
    }

    public boolean isIndirect() {
        return this.indirect;
    }

    public boolean containReason(int f) {
        if (this.onlySomeReasons == null) {
            return true;
        }
        return this.onlySomeReasons.isAReason(f);
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int seq = enc.encodeSequence();
        int exp = enc.encodeExplicit(ASN1Tag.makeContextTag(0));
        this.dpn.encode(enc);
        enc.endOf(exp);
        if (this.onlyUsrcrt) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(1));
            enc.encodeBoolean(this.onlyUsrcrt);
        }
        if (this.onlyCAcrt) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(2));
            enc.encodeBoolean(this.onlyUsrcrt);
        }
        if (this.onlySomeReasons != null) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(3));
            this.onlySomeReasons.encode(enc);
        }
        if (this.indirect) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(4));
            enc.encodeBoolean(this.onlyUsrcrt);
        }
        if (this.onlyAC) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(5));
            enc.encodeBoolean(this.onlyAC);
        }
        enc.endOf(seq);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        int seq = dec.decodeSequence();
        if (dec.nextIsOptional(ASN1Tag.makeExplicitTag(0))) {
            this.dpn = null;
        } else {
            int exp = dec.decodeExplicit(ASN1Tag.makeExplicitTag(0));
            if (this.dpn == null) {
                this.dpn = new DPN();
            }
            this.dpn.decode(dec);
            dec.endOf(exp);
        }
        if (dec.nextIsDefault(ASN1Tag.makeContextTag(1))) {
            this.onlyUsrcrt = false;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(1));
            this.onlyUsrcrt = dec.decodeBoolean();
        }
        if (dec.nextIsDefault(ASN1Tag.makeContextTag(2))) {
            this.onlyCAcrt = false;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(2));
            this.onlyCAcrt = dec.decodeBoolean();
        }
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(3))) {
            this.onlySomeReasons = null;
        } else {
            this.onlySomeReasons = new ReasonFlags();
            dec.nextIsImplicit(ASN1Tag.makeContextTag(3));
            this.onlySomeReasons.decode(dec);
        }
        if (dec.nextIsDefault(ASN1Tag.makeContextTag(4))) {
            this.indirect = false;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(4));
            this.indirect = dec.decodeBoolean();
        }
        if (dec.nextIsDefault(ASN1Tag.makeContextTag(5))) {
            this.onlyAC = false;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(5));
            this.onlyAC = dec.decodeBoolean();
        }
        dec.endOf(seq);
    }

    protected boolean shouldOmitted() {
        return this.dpn == null && !this.onlyUsrcrt && !this.onlyCAcrt && !this.indirect;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert, String prefix, Properties props) {
        this.setCritical(critical);
        String val = props.getProperty(prefix + "onlyUserCerts");
        this.onlyUsrcrt = val == null ? false : Boolean.getBoolean(val);
        val = props.getProperty(prefix + "onlyCACerts");
        this.onlyCAcrt = val == null ? false : Boolean.getBoolean(val);
        val = props.getProperty(prefix + "indirect");
        this.indirect = val == null ? false : Boolean.getBoolean(val);
        val = props.getProperty(prefix + "onlySomeReasons");
        if (val != null) {
            this.onlySomeReasons = new ReasonFlags();
            this.onlySomeReasons.setReasons(val);
        }
        this.dpn.fullName.clear();
        int major = 1;
        while ((val = props.getProperty(prefix + "distPoint." + major)) != null) {
            GeneralName gn = new GeneralName();
            gn.setFromString(val);
            this.dpn.fullName.add(gn);
        }
        return true;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Issuing Distribution Point:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.dpn != null) {
            this.indent(buf, n + 1);
            buf.append("Distribution Point:");
            buf.append('\n');
            this.dpn.toString(buf, n + 2);
        }
        if (this.onlyUsrcrt) {
            this.indent(buf, n + 1);
            buf.append("Only contains user certificates\n");
        }
        if (this.onlyCAcrt) {
            this.indent(buf, n + 1);
            buf.append("Only contains CA certificates\n");
        }
        if (this.onlySomeReasons != null && !this.onlySomeReasons.isClean()) {
            this.indent(buf, n + 1);
            buf.append("Only contains following Reasons : ");
            buf.append(this.onlySomeReasons.toString());
            buf.append('\n');
        }
        if (this.indirect) {
            this.indent(buf, n + 1);
            buf.append("Indirect CRL\n");
        }
        if (this.onlyAC) {
            this.indent(buf, n + 1);
            buf.append("Only contains Attribute Certificates\n");
        }
    }
}

