/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.Extension;
import com.initech.x509.extensions.SettableExtension;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;

public class KeyUsage
extends Extension
implements SettableExtension {
    private static final long serialVersionUID = 8592566733349673179L;
    public static final String OID = "2.5.29.15";
    public static final int DIGITAL_SIGNATURE = 32768;
    public static final int NON_REPUDIATION = 16384;
    public static final int KEY_ENCIPHERMENT = 8192;
    public static final int DATA_ENCIPHERMENT = 4096;
    public static final int KEY_AGREEMENT = 2048;
    public static final int KEY_CERT_SIGN = 1024;
    public static final int CRL_SIGN = 512;
    public static final int ENCIPHER_ONLY = 256;
    public static final int DECIPHER_ONLY = 128;
    private byte unusedbits = 0;
    private int usage = 0;
    private static final byte[] CLEARMASKS = new byte[]{-1, -2, -4, -8, -16, -32, -64, -128, 0};

    public KeyUsage() {
        this(true, 0);
    }

    public KeyUsage(boolean c, int usage) {
        this.setExtensionID(OID);
        this.setCritical(c);
        this.unusedbits = 0;
        this.usage = usage;
    }

    public KeyUsage(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public boolean isProperUsage(int usage) {
        return (this.usage & usage) != 0;
    }

    public void setUsage(int usage) {
        this.modified = true;
        this.unusedbits = 0;
        this.usage |= usage;
    }

    public void clearUsage(int usage) {
        this.modified = true;
        this.unusedbits = 0;
        this.usage &= ~usage;
    }

    public boolean[] getBooleanArray() {
        boolean[] r = new boolean[]{(this.usage & 0x8000) != 0, (this.usage & 0x4000) != 0, (this.usage & 0x2000) != 0, (this.usage & 0x1000) != 0, (this.usage & 0x800) != 0, (this.usage & 0x400) != 0, (this.usage & 0x200) != 0, (this.usage & 0x100) != 0, (this.usage & 0x80) != 0};
        return r;
    }

    protected void encodeExtValue() throws ASN1Exception {
        byte i;
        int bytes = (this.usage & 0xFF) > 0 ? 2 : 1;
        byte[] val = new byte[3 + bytes];
        val[0] = 3;
        val[1] = (byte)(bytes == 2 ? 3 : 2);
        byte u = bytes == 2 ? (byte)(this.usage & 0xFF) : (byte)(this.usage >>> 8 & 0xFF);
        int p = 1;
        for (i = this.unusedbits; i < 9 && (u & p) == 0; i = (byte)(i + 1)) {
            p <<= 1;
        }
        val[2] = this.unusedbits = i;
        val[3] = (byte)(this.usage >>> 8 & 0xFF);
        if (bytes == 2) {
            val[4] = (byte)(this.usage & 0xFF);
            val[4] = (byte)(val[4] & CLEARMASKS[this.unusedbits]);
        } else {
            val[3] = (byte)(val[3] & CLEARMASKS[this.unusedbits]);
        }
        this.extVal = val;
    }

    protected void decodeExtValue() throws ASN1Exception {
        byte[] val = this.extVal;
        byte len = val[1];
        if (val[0] != 3) {
            throw new ASN1Exception("Illegal Encoding");
        }
        this.unusedbits = val[2];
        this.usage = val[3] << 8 & 0xFFFF;
        if (len >= 5) {
            this.usage |= val[4] & 0xFF;
        }
    }

    protected boolean shouldOmitted() {
        return this.usage == 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert) {
        this.setCritical(critical);
        StringTokenizer st = new StringTokenizer(rawValue, "\t\n\r\f, ");
        while (st.hasMoreTokens()) {
            String p = st.nextToken().toLowerCase();
            if (p.equals("digitalsignature")) {
                this.usage |= 0x8000;
                continue;
            }
            if (p.equals("nonrepudiation")) {
                this.usage |= 0x4000;
                continue;
            }
            if (p.equals("keyencipherment")) {
                this.usage |= 0x2000;
                continue;
            }
            if (p.equals("dataencipherment")) {
                this.usage |= 0x1000;
                continue;
            }
            if (p.equals("keyagreement")) {
                this.usage |= 0x800;
                continue;
            }
            if (p.equals("keycertsign")) {
                this.usage |= 0x400;
                continue;
            }
            if (p.equals("crlsign")) {
                this.usage |= 0x200;
                continue;
            }
            if (p.equals("encipheronly")) {
                this.usage |= 0x100;
                continue;
            }
            if (!p.equals("decipheronly")) continue;
            this.usage |= 0x80;
        }
        return true;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Key Usage:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        if (this.isProperUsage(32768)) {
            buf.append("Digital Signature, ");
        }
        if (this.isProperUsage(16384)) {
            buf.append("Non Repudiation, ");
        }
        if (this.isProperUsage(8192)) {
            buf.append("Key Encipherment, ");
        }
        if (this.isProperUsage(4096)) {
            buf.append("Data Encipherment, ");
        }
        if (this.isProperUsage(2048)) {
            buf.append("Key Agreement, ");
        }
        if (this.isProperUsage(1024)) {
            buf.append("Certificate Sign, ");
        }
        if (this.isProperUsage(512)) {
            buf.append("CRL Sign, ");
        }
        if (this.isProperUsage(256)) {
            buf.append("Encipher Only, ");
        }
        if (this.isProperUsage(128)) {
            buf.append("Decipher Only");
        }
        if (buf.charAt(buf.length() - 1) == ' ') {
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append('\n');
    }
}

