/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.asn1.useful.Name;
import com.initech.x509.X509CertImpl;
import com.initech.x509.X509SubjectName;
import com.initech.x509.extensions.GeneralSubTree;
import com.initech.x509.extensions.GeneralSubTrees;
import com.initech.x509.extensions.MultiValueExtension;
import com.initech.x509.extensions.SubjectAltName;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class NameConstraints
extends Extension
implements MultiValueExtension {
    private static final long serialVersionUID = 5813447559000882861L;
    public static final String OID = "2.5.29.30";
    private GeneralSubTrees permST = new GeneralSubTrees();
    private GeneralSubTrees exclST = new GeneralSubTrees();

    public NameConstraints() {
        this.setExtensionID(OID);
        this.setCritical(true);
    }

    public NameConstraints(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public GeneralSubTrees getPermittedSubTrees() {
        return this.permST;
    }

    public GeneralSubTrees getExcludedSubTrees() {
        return this.exclST;
    }

    public int sizeOfPermittedSubTree() {
        return this.permST.size();
    }

    public int sizeOfExcludedSubTree() {
        return this.exclST.size();
    }

    public void clearPermittedSubTree() {
        this.modified = true;
        this.permST.clear();
    }

    public void clearExcludedSubTree() {
        this.modified = true;
        this.exclST.clear();
    }

    public void addPermittedSubTree(GeneralSubTree gst) {
        this.modified = true;
        this.permST.add(gst);
    }

    public void addPermittedSubTree(GeneralName base, int min) {
        this.modified = true;
        this.permST.add(new GeneralSubTree(base, min, -1));
    }

    public void addPermittedSubTree(GeneralName base, int min, int max) {
        this.modified = true;
        this.permST.add(new GeneralSubTree(base, min, max));
    }

    public void addExcludedSubTree(GeneralSubTree gst) {
        this.modified = true;
        this.exclST.add(gst);
    }

    public void addExcludedSubTree(GeneralName base, int min) {
        this.modified = true;
        this.exclST.add(new GeneralSubTree(base, min, -1));
    }

    public void addExcludedSubTree(GeneralName base, int min, int max) {
        this.modified = true;
        this.exclST.add(new GeneralSubTree(base, min, max));
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequence();
        if (this.permST.size() > 0) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(0));
            this.permST.encode(enc);
        }
        if (this.exclST.size() > 0) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(1));
            this.exclST.encode(enc);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequence();
        if (!dec.nextIsOptional(ASN1Tag.makeExplicitTag(0))) {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(0));
            this.permST.decode(dec);
        } else {
            this.permST.clear();
        }
        if (!dec.nextIsOptional(ASN1Tag.makeExplicitTag(1))) {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(1));
            this.exclST.decode(dec);
        } else {
            this.exclST.clear();
        }
        dec.endOf(id);
    }

    protected boolean shouldOmitted() {
        return this.permST.size() == 0 && this.exclST.size() == 0;
    }

    private void loadSubTrees(String prefix, Properties props, GeneralSubTrees tree) {
        String base;
        int major = 1;
        int min = 0;
        int max = -1;
        tree.clear();
        while ((base = props.getProperty(prefix + major + ".base")) != null) {
            min = 0;
            max = -1;
            String minStr = props.getProperty(prefix + major + ".min");
            String maxStr = props.getProperty(prefix + major + ".max");
            if (minStr != null) {
                min = Integer.parseInt(minStr);
                int n = min = min < 0 ? 0 : min;
            }
            if (maxStr != null) {
                max = Integer.parseInt(maxStr);
                max = max < 0 ? -1 : max;
                max = max < min ? -1 : max;
            }
            GeneralName gn = new GeneralName();
            gn.setFromString(base);
            GeneralSubTree gst = new GeneralSubTree(gn, min, max);
            tree.add(gst);
            ++major;
        }
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert, String prefix, Properties props) {
        this.loadSubTrees(prefix + "permit.", props, this.permST);
        this.loadSubTrees(prefix + "exclude.", props, this.exclST);
        return this.permST.size() > 0 || this.exclST.size() > 0;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Name Constraints:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.shouldOmitted()) {
            this.indent(buf, n + 1);
            buf.append("<empty>");
        } else {
            if (this.permST.size() > 0) {
                this.indent(buf, n + 1);
                buf.append("Permitted Sub Trees:\n");
                this.permST.toString(buf, n + 2);
            }
            if (this.exclST.size() > 0) {
                this.indent(buf, n + 1);
                buf.append("Excluded Sub Trees:\n");
                this.exclST.toString(buf, n + 2);
            }
        }
    }

    public void merge(NameConstraints nc) {
        GeneralSubTrees excl = nc.getExcludedSubTrees();
        this.exclST.union(excl);
        GeneralSubTrees perm = nc.getPermittedSubTrees();
        if (this.permST.size() == 0) {
            this.permST = GeneralSubTrees.getWidestSubTrees();
        }
        this.permST = this.permST.intersect(perm);
    }

    public boolean verify(X509SubjectName c) throws CertificateException {
        if (c == null) {
            return false;
        }
        Name subject = c.getSubjectName();
        if (!this.verify(subject)) {
            return false;
        }
        SubjectAltName san = c.getSubjectAltName();
        if (san != null) {
            for (int i = 0; i < san.size(); ++i) {
                GeneralName gn = san.elementAt(i);
                GeneralNameInterface gni = gn.getGeneralNameInterface();
                if (this.verify(gni)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean verify(X509Certificate c) throws IOException {
        if (c == null) {
            return false;
        }
        try {
            X509CertImpl cert = c instanceof X509CertImpl ? (X509CertImpl)c : new X509CertImpl(c.getEncoded());
            Name subject = (Name)cert.getSubjectDN();
            if (!this.verify(subject)) {
                return false;
            }
            byte[] b = cert.getExtensionValue("2.5.29.17");
            if (b == null) {
                return true;
            }
            SubjectAltName san = new SubjectAltName(b);
            for (int i = 0; i < san.size(); ++i) {
                GeneralName gn = san.elementAt(i);
                GeneralNameInterface gni = gn.getGeneralNameInterface();
                if (this.verify(gni)) continue;
                return false;
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to verify Certificate : " + ex.getMessage());
        }
        return true;
    }

    public boolean verify(GeneralNameInterface gni) {
        if (gni == null) {
            return false;
        }
        if (this.permST == null) {
            return false;
        }
        if (this.exclST.size() > 0) {
            for (int i = 0; i < this.exclST.size(); ++i) {
                GeneralNameInterface base = this.exclST.getGeneralNameInterface(i);
                switch (base.constrains(gni)) {
                    case 0: 
                    case 2: {
                        return false;
                    }
                }
            }
        }
        boolean ok = false;
        if (this.permST.size() > 0) {
            block8: for (int i = 0; i < this.permST.size(); ++i) {
                GeneralNameInterface base = this.permST.getGeneralNameInterface(i);
                switch (base.constrains(gni)) {
                    case 1: 
                    case 3: {
                        ok = true;
                        continue block8;
                    }
                    case 0: 
                    case 2: {
                        return true;
                    }
                }
            }
            if (ok) {
                return false;
            }
        }
        return true;
    }
}

