/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import com.initech.x509.extensions.SettableExtension;
import java.security.cert.X509Certificate;

public class PolicyConstraints
extends Extension
implements SettableExtension {
    private static final long serialVersionUID = 2458171565904922134L;
    public static final String OID = "2.5.29.36";
    private int reqExpPol = -1;
    private int inPolMap = -1;

    public PolicyConstraints() {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.reqExpPol = -1;
        this.inPolMap = -1;
    }

    public PolicyConstraints(int r, int i) {
        this();
        this.reqExpPol = r;
        this.inPolMap = i;
        this.modified = true;
    }

    public PolicyConstraints(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void setRequireExplicitPolicy(int r) {
        this.modified = true;
        r = this.reqExpPol;
    }

    public void setInhibitPolicyMapping(int i) {
        this.modified = true;
        this.inPolMap = i;
    }

    public int getRequireExplicitPolicy() {
        return this.reqExpPol < 0 ? -1 : this.reqExpPol;
    }

    public int getInhibitPolicyMapping() {
        return this.inPolMap < 0 ? -1 : this.inPolMap;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequence();
        if (this.reqExpPol >= 0) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(0));
            enc.encodeInteger(this.reqExpPol);
        }
        if (this.inPolMap >= 0) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(1));
            enc.encodeInteger(this.inPolMap);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequence();
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(0))) {
            this.reqExpPol = -1;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(0));
            this.reqExpPol = dec.decodeIntegerAsInt();
        }
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(1))) {
            this.inPolMap = -1;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(1));
            this.inPolMap = dec.decodeIntegerAsInt();
        }
        dec.endOf(id);
    }

    protected boolean shouldOmitted() {
        return this.reqExpPol < 0 && this.inPolMap < 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert) {
        this.setCritical(critical);
        return true;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Policy Constraints:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.reqExpPol < 0 && this.inPolMap < 0) {
            this.indent(buf, n + 1);
            buf.append("<empty>\n");
        }
        if (this.reqExpPol >= 0) {
            this.indent(buf, n + 1);
            buf.append("Require Explicit Policy : ");
            buf.append(this.reqExpPol);
            buf.append('\n');
        }
        if (this.inPolMap >= 0) {
            this.indent(buf, n + 1);
            buf.append("Inhibit Policy Mapping : ");
            buf.append(this.inPolMap);
            buf.append('\n');
        }
    }
}

