/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Type;
import com.initech.cryptox.util.StringUtil;
import com.initech.x509.extensions.PolicyQualifier;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolicyInfo
implements ASN1Type {
    private static final long serialVersionUID = -7089779213510151377L;
    public static final ASN1OID anyPolicy = new ASN1OID("2.5.29.32.0");
    public static final String ANY_POLICY = "2.5.29.32.0";
    private ASN1OID policyId = new ASN1OID();
    private Vector qualifiers = new Vector();

    public PolicyInfo() {
    }

    public PolicyInfo(ASN1OID id) {
        this.policyId = (ASN1OID)id.clone();
    }

    public PolicyInfo(String id) {
        this.policyId.set(id);
    }

    public PolicyInfo(String id, PolicyQualifier pq) {
        this.policyId.set(id);
        this.qualifiers.addElement(pq);
    }

    public void clearQualifiers() {
        this.qualifiers.removeAllElements();
    }

    public int sizeQualifiers() {
        return this.qualifiers.size();
    }

    public Enumeration elementsQualifiers() {
        return this.qualifiers.elements();
    }

    public void setPolicyID(ASN1OID id) {
        this.policyId = (ASN1OID)id.clone();
    }

    public void setPolicyID(String id) {
        this.policyId.set(id);
    }

    public void addQualifier(PolicyQualifier pq) {
        this.qualifiers.addElement(pq);
    }

    public ASN1OID getPolicyID() {
        return this.policyId;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq = enc.encodeSequence();
        enc.encodeObjectIdentifier(this.policyId);
        if (this.qualifiers.size() > 0) {
            int pqs = enc.encodeSequenceOf();
            for (int i = 0; i < this.qualifiers.size(); ++i) {
                PolicyQualifier pq = (PolicyQualifier)this.qualifiers.elementAt(i);
                pq.encode(enc);
            }
            enc.endOf(pqs);
        }
        enc.endOf(seq);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq = dec.decodeSequence();
        this.policyId = dec.decodeObjectIdentifier();
        this.qualifiers.removeAllElements();
        if (!dec.nextIsOptional(16)) {
            int pqs = dec.decodeSequenceOf();
            while (!dec.endOf(pqs)) {
                PolicyQualifier pq = new PolicyQualifier();
                pq.decode(dec);
                this.qualifiers.addElement(pq);
            }
            dec.endOf(pqs);
        }
        dec.endOf(seq);
    }

    protected void loadQualifiers(String prefix, Properties props, PolicyInfo pi) {
        int major = 1;
        Vector<Integer> notNum = new Vector<Integer>();
        while (true) {
            String expText = null;
            String cps = null;
            String org = null;
            String ns = null;
            notNum.removeAllElements();
            cps = props.getProperty(prefix + major + ".cps");
            expText = props.getProperty(prefix + major + ".unotice.explicitText");
            org = props.getProperty(prefix + major + ".unotice.noticeref.org");
            ns = props.getProperty(prefix + major + ".unotice.noticeref.noticenumber");
            if (cps == null && expText == null && org == null && ns == null) break;
            PolicyQualifier pq = new PolicyQualifier();
            if (cps != null) {
                pq.setCPSURI(cps);
            } else {
                if (ns != null) {
                    StringTokenizer st = new StringTokenizer(ns, " ,\n\t\r");
                    while (st.hasMoreTokens()) {
                        notNum.addElement(new Integer(st.nextToken()));
                    }
                }
                pq.setUserNotice(expText, org, notNum);
            }
            pi.addQualifier(pq);
            ++major;
        }
    }

    public boolean isAnyPolicy() {
        return this.policyId.equals(anyPolicy);
    }

    public boolean equals(Object obj) {
        return obj instanceof ASN1OID ? this.policyId.equals((ASN1OID)obj) : obj instanceof PolicyInfo && this.policyId.equals(((PolicyInfo)obj).getPolicyID());
    }

    public int hashCode() {
        return this.policyId.hashCode();
    }

    public void toString(StringBuffer buf, int n) {
        StringUtil.indent(buf, n);
        buf.append("Policy Identifier : ");
        buf.append(this.policyId.get());
        buf.append('\n');
        if (this.qualifiers.size() > 0) {
            for (int i = 0; i < this.qualifiers.size(); ++i) {
                PolicyQualifier pq = (PolicyQualifier)this.qualifiers.elementAt(i);
                StringUtil.indent(buf, n + 1);
                buf.append("Policy Qualifier:\n");
                pq.toString(buf, n + 2);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        this.toString(buf, 0);
        return new String(buf);
    }
}

