/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.Extension;
import com.initech.x509.extensions.MultiValueExtension;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PolicyMappings
extends Extension
implements MultiValueExtension {
    private static final long serialVersionUID = -1022670652068524960L;
    public static final String OID = "2.5.29.33";
    private Vector mapping;

    public PolicyMappings() {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.mapping = new Vector(4);
    }

    public PolicyMappings(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void add(ASN1OID issuer, ASN1OID subject) {
        this.modified = true;
        this.mapping.addElement(new PolicyMapping(issuer, subject));
    }

    public void add(PolicyMapping pm) {
        this.modified = true;
        this.mapping.addElement(pm);
    }

    public Enumeration elements() {
        return this.mapping.elements();
    }

    public void clear() {
        this.modified = true;
        this.mapping.removeAllElements();
    }

    public int size() {
        return this.mapping.size();
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.mapping.size(); ++i) {
            PolicyMapping pm = (PolicyMapping)this.mapping.elementAt(i);
            pm.encode(enc);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        this.mapping.removeAllElements();
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            PolicyMapping pm = new PolicyMapping();
            pm.decode(dec);
            this.mapping.addElement(pm);
        }
    }

    protected boolean shouldOmitted() {
        return this.mapping.size() == 0;
    }

    public boolean loadExtension(boolean critical, String rawValue, X509Certificate cacert, String prefix, Properties props) {
        String value;
        this.mapping.removeAllElements();
        this.setCritical(critical);
        int i = 1;
        while ((value = props.getProperty(prefix + i)) != null) {
            String issuer = value.substring(0, value.indexOf(44));
            issuer = issuer.trim();
            String subject = value.substring(value.indexOf(44) + 1);
            subject = subject.trim();
            this.add(new ASN1OID(issuer), new ASN1OID(subject));
            ++i;
        }
        return i > 1;
    }

    public void toString(StringBuffer buf, int n) {
        buf.append("X509v3 Policy Mappings:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.mapping.size() == 0) {
            this.indent(buf, n + 1);
            buf.append("<empty>\n");
        } else {
            for (int i = 0; i < this.mapping.size(); ++i) {
                this.indent(buf, n + 1);
                buf.append(this.mapping.elementAt(i));
                buf.append('\n');
            }
        }
    }

    public class PolicyMapping
    extends ASN1Object {
        protected ASN1OID issuer = new ASN1OID();
        protected ASN1OID subject = new ASN1OID();

        public PolicyMapping() {
        }

        public PolicyMapping(ASN1OID i, ASN1OID s) {
            this.issuer.set(i);
            this.subject.set(s);
            this.modified = true;
        }

        public ASN1OID getIssuerPolicy() {
            return this.issuer;
        }

        public ASN1OID getSubjectPolicy() {
            return this.subject;
        }

        public void setIssuerPolicy(ASN1OID i) {
            this.modified = true;
            this.issuer.set(i);
        }

        public void setSubjectPolicy(ASN1OID i) {
            this.modified = true;
            this.subject.set(i);
        }

        public void encode(ASN1Encoder enc) throws ASN1Exception {
            int id = enc.encodeSequence();
            enc.encodeObjectIdentifier(this.issuer);
            enc.encodeObjectIdentifier(this.subject);
            enc.endOf(id);
        }

        public void decode(ASN1Decoder dec) throws ASN1Exception {
            int id = dec.decodeSequence();
            this.issuer = dec.decodeObjectIdentifier();
            this.subject = dec.decodeObjectIdentifier();
            dec.endOf(id);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(40);
            buf.append("Issuer : ");
            buf.append(this.issuer.get());
            buf.append(' ');
            buf.append('-');
            buf.append(' ');
            buf.append("Subject : ");
            buf.append(this.subject.get());
            return new String(buf);
        }
    }
}

