/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Any;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1StringFactory;
import com.initech.asn1.ASN1Type;
import com.initech.cryptox.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class PolicyQualifier
implements ASN1Type {
    private static final long serialVersionUID = 1493852410746538913L;
    public static final int CPS = 0;
    public static final int UserNotice = 1;
    private static final ASN1OID[] oids = new ASN1OID[]{new ASN1OID("1.3.6.1.5.5.7.2.1"), new ASN1OID("1.3.6.1.5.5.7.2.2")};
    private int[] expTxtTag;
    private int selected = -1;
    private String cpsuri = null;
    private String explicitText = null;
    private String org = null;
    private Vector noticeNums = new Vector();

    public PolicyQualifier() {
        this.expTxtTag = new int[1];
        this.expTxtTag[0] = -1;
    }

    public void setCPSURI(String uri) {
        this.selected = 0;
        this.cpsuri = uri;
    }

    public void setCPSURI(URL uri) {
        this.selected = 0;
        this.cpsuri = uri.toString();
    }

    public void setUserNotice(String expText, String org, Vector arr) {
        this.selected = 1;
        this.explicitText = expText == null ? null : new String(expText);
        this.org = org == null ? null : new String(org);
        this.noticeNums.removeAllElements();
        if (arr != null) {
            for (int i = 0; i < arr.size(); ++i) {
                this.noticeNums.addElement(arr.elementAt(i));
            }
        }
    }

    public int getQulifierInfoType() {
        return this.selected;
    }

    public String getCPSURI() {
        if (this.cpsuri == null) {
            return null;
        }
        return new String(this.cpsuri);
    }

    public URL getCPSURIAsURL() throws MalformedURLException {
        if (this.cpsuri == null) {
            return null;
        }
        return new URL(this.cpsuri);
    }

    public String getExplicitText() {
        if (this.explicitText == null) {
            return null;
        }
        return new String(this.explicitText);
    }

    public String getOrganization() {
        if (this.org == null) {
            return null;
        }
        return new String(this.org);
    }

    public int[] getNoticeReferences() {
        if (this.noticeNums.size() == 0) {
            return null;
        }
        int[] ret = new int[this.noticeNums.size()];
        for (int i = 0; i < this.noticeNums.size(); ++i) {
            Integer n = (Integer)this.noticeNums.elementAt(i);
            ret[i] = n;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        if (this.selected < 0) {
            return;
        }
        int seq = enc.encodeSequence();
        enc.encodeObjectIdentifier(oids[this.selected]);
        if (this.selected == 0) {
            enc.encodeIA5String(this.cpsuri);
        } else {
            int unseq = enc.encodeSequence();
            if (this.org != null && this.noticeNums.size() > 0) {
                int nrseq = enc.encodeSequence();
                enc.encodeUTF8String(this.org);
                int nnseq = enc.encodeSequenceOf();
                for (int i = 0; i < this.noticeNums.size(); ++i) {
                    Integer n = (Integer)this.noticeNums.elementAt(i);
                    enc.encodeInteger(n);
                }
                enc.endOf(nnseq);
                enc.endOf(nrseq);
            }
            if (this.explicitText != null) {
                int t;
                if (this.expTxtTag[0] < 0 && ((t = ASN1StringFactory.identifyStringTag(this.explicitText)) == 19 || t == 18)) {
                    this.expTxtTag[0] = 26;
                }
                ASN1Any.encodeAsString(enc, this.explicitText, this.expTxtTag[0]);
            }
            enc.endOf(unseq);
        }
        enc.endOf(seq);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.cpsuri = null;
        this.explicitText = null;
        this.org = null;
        this.noticeNums.removeAllElements();
        int seq = dec.decodeSequence();
        ASN1OID s = dec.decodeObjectIdentifier();
        if (s.equals(oids[0])) {
            this.selected = 0;
            this.cpsuri = dec.decodeIA5String();
        } else if (s.equals(oids[1])) {
            this.selected = 1;
            int unseq = dec.decodeSequence();
            if (!dec.nextIsOptional(16)) {
                int nrseq = dec.decodeSequence();
                this.org = dec.decodeUTF8String();
                int nnseq = dec.decodeSequenceOf();
                while (!dec.endOf(nnseq)) {
                    int n = dec.decodeIntegerAsInt();
                    this.noticeNums.addElement(new Integer(n));
                }
                dec.endOf(nrseq);
            }
            if (!dec.endOf(unseq)) {
                this.explicitText = ASN1Any.decodeAsString(dec, this.expTxtTag);
                dec.endOf(unseq);
            }
        } else {
            this.selected = -1;
            dec.skipNextTag();
        }
        dec.endOf(seq);
    }

    public void toString(StringBuffer buf, int n) {
        if (this.selected == 0) {
            StringUtil.indent(buf, n);
            buf.append("CPS : ");
            buf.append(this.cpsuri);
            buf.append('\n');
        } else {
            StringUtil.indent(buf, n);
            buf.append("User Notice :\n");
            if (this.org != null) {
                StringUtil.indent(buf, n + 1);
                buf.append("Organization : ");
                buf.append(this.org);
                buf.append('\n');
                if (this.noticeNums.size() > 0) {
                    StringUtil.indent(buf, n + 1);
                    buf.append("Notice Numbers : ");
                    for (int i = 0; i < this.noticeNums.size(); ++i) {
                        Integer num = (Integer)this.noticeNums.elementAt(i);
                        buf.append(Integer.toString(10));
                        if (i >= this.noticeNums.size() - 1) continue;
                        buf.append(", ");
                    }
                    buf.append('\n');
                }
            }
            if (this.explicitText != null) {
                StringUtil.indent(buf, n + 1);
                buf.append("Explicit Text : ");
                buf.append(this.explicitText);
                buf.append('\n');
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        this.toString(buf, 0);
        return new String(buf);
    }
}

