/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import java.util.Date;

public class PrivKeyUsagePeriod
extends Extension {
    private static final long serialVersionUID = 8991703481411069993L;
    public static final String OID = "2.5.29.16";
    private Date notBefore = null;
    private Date notAfter = null;

    public PrivKeyUsagePeriod() {
        this.setExtensionID(OID);
        this.setCritical(false);
    }

    public PrivKeyUsagePeriod(Date nb, Date na) {
        this();
        this.notBefore = nb != null ? new Date(nb.getTime()) : null;
        this.notAfter = na != null ? new Date(na.getTime()) : null;
    }

    public PrivKeyUsagePeriod(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public Date getNotBefore() {
        return this.notBefore != null ? new Date(this.notBefore.getTime()) : null;
    }

    public Date getNotAfter() {
        return this.notAfter != null ? new Date(this.notAfter.getTime()) : null;
    }

    public void setNotBefore(Date nb) {
        this.modified = true;
        this.notBefore = nb != null ? new Date(nb.getTime()) : null;
    }

    public void setNotAfter(Date na) {
        this.modified = true;
        this.notAfter = na != null ? new Date(na.getTime()) : null;
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequence();
        if (this.notBefore != null) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(0));
            enc.encodeGeneralizedTime(this.notBefore);
        }
        if (this.notAfter != null) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(1));
            enc.encodeGeneralizedTime(this.notAfter);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequence();
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(0))) {
            this.notAfter = null;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(0));
            this.notAfter = dec.decodeGeneralizedTime();
        }
        if (dec.nextIsOptional(ASN1Tag.makeContextTag(1))) {
            this.notAfter = null;
        } else {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(1));
            this.notAfter = dec.decodeGeneralizedTime();
        }
        dec.endOf(id);
    }

    protected boolean shouldOmitted() {
        return this.notBefore == null && this.notAfter == null;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Private Key Usage Period:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.shouldOmitted()) {
            this.indent(buf, n + 1);
            buf.append("<empty>\n");
        } else {
            if (this.notBefore != null) {
                this.indent(buf, n + 1);
                buf.append("Not Before : ");
                buf.append(this.notBefore);
                buf.append('\n');
            }
            if (this.notAfter != null) {
                this.indent(buf, n + 1);
                buf.append("Not After : ");
                buf.append(this.notAfter);
                buf.append('\n');
            }
        }
    }
}

