/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import java.util.StringTokenizer;

public class ReasonFlags
implements ASN1Type {
    private static final long serialVersionUID = -6942317272332608332L;
    public static final int UNUSED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int PRIVILEGE_WITHDRAWN = 7;
    public static final int AA_COMPROMISE = 8;
    private boolean[] flags = new boolean[9];

    public ReasonFlags() {
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = false;
        }
    }

    public boolean isClean() {
        for (int i = 0; i < this.flags.length; ++i) {
            if (!this.flags[i]) continue;
            return false;
        }
        return true;
    }

    public void unset(int f) {
        if (f >= this.flags.length) {
            boolean[] n = new boolean[f];
            System.arraycopy(this.flags, 0, n, 0, this.flags.length);
            for (int i = this.flags.length; i < f; ++i) {
                n[i] = false;
            }
            this.flags = n;
        }
        this.flags[f] = false;
    }

    public void set(int f) {
        if (f >= this.flags.length) {
            boolean[] n = new boolean[f];
            System.arraycopy(this.flags, 0, n, 0, this.flags.length);
            for (int i = this.flags.length; i < f; ++i) {
                n[i] = false;
            }
            this.flags = n;
        }
        this.flags[f] = true;
    }

    public boolean isAReason(int f) {
        if (f >= this.flags.length) {
            return false;
        }
        return this.flags[f];
    }

    public boolean[] getReason() {
        return (boolean[])this.flags.clone();
    }

    public int getReasonAsInt() {
        int ret = 0;
        int mask = 512;
        for (int i = 0; i < this.flags.length; ++i) {
            if (this.flags[i]) {
                ret |= mask;
            }
            mask >>>= 1;
        }
        return ret;
    }

    public int getFirstReason() {
        int i;
        for (i = 0; i < this.flags.length && !this.flags[i]; ++i) {
        }
        if (i == this.flags.length) {
            i = 1;
        }
        return i;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        ASN1BitString b = new ASN1BitString();
        b.setFromBooleanArray(this.flags, true);
        enc.encodeBitString(b);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        ASN1BitString b = dec.decodeBitString();
        this.flags = b.getAsBooleanArray();
    }

    public void setReasons(String value) {
        StringTokenizer st = new StringTokenizer(value, "\t\n\r\f, ");
        this.clear();
        while (st.hasMoreTokens()) {
            String p = st.nextToken().toLowerCase();
            if (p.equals("keycompromise")) {
                this.set(1);
                continue;
            }
            if (p.equals("cacompromise")) {
                this.set(2);
                continue;
            }
            if (p.equals("affiliationchanged")) {
                this.set(3);
                continue;
            }
            if (p.equals("superseded")) {
                this.set(4);
                continue;
            }
            if (p.equals("cessationofoperation")) {
                this.set(5);
                continue;
            }
            if (p.equals("certificatehold")) {
                this.set(6);
                continue;
            }
            if (p.equals("privilegewithdrawn")) {
                this.set(7);
                continue;
            }
            if (!p.equals("aacompromise")) continue;
            this.set(8);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        if (this.flags[0]) {
            buf.append("Unused, ");
        }
        if (this.flags[1]) {
            buf.append("Key Compromise, ");
        }
        if (this.flags[2]) {
            buf.append("CA Compromise, ");
        }
        if (this.flags[3]) {
            buf.append("Affiliation Changed, ");
        }
        if (this.flags[4]) {
            buf.append("Superseded, ");
        }
        if (this.flags[5]) {
            buf.append("Cessation Of Operation, ");
        }
        if (this.flags[6]) {
            buf.append("Cetificate Hold, ");
        }
        if (this.flags[7]) {
            buf.append("Privilege Withdrawn, ");
        }
        if (this.flags[8]) {
            buf.append("AA Compromise");
        }
        if (buf.charAt(buf.length() - 1) == ' ') {
            buf.delete(buf.length() - 2, buf.length());
        }
        return new String(buf);
    }
}

