/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Attribute;
import com.initech.asn1.useful.Extension;
import java.util.Enumeration;
import java.util.Vector;

public class SubjectDirectoryAttributes
extends Extension {
    private static final long serialVersionUID = -3435678781859382671L;
    public static final String OID = "2.5.29.9";
    private Vector attr;

    public SubjectDirectoryAttributes() {
        this.setExtensionID(OID);
        this.setCritical(false);
        this.attr = new Vector();
    }

    public SubjectDirectoryAttributes(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public void add(Attribute at) {
        if (!this.attr.contains(at)) {
            this.modified = true;
            this.attr.add(at);
        }
    }

    public int size() {
        return this.attr.size();
    }

    public Enumeration elements() {
        return this.attr.elements();
    }

    public Attribute elementAt(int i) {
        if (i < 0 || i >= this.attr.size()) {
            return null;
        }
        return (Attribute)this.attr.elementAt(i);
    }

    public void clear() {
        this.attr.removeAllElements();
    }

    public boolean contains(Attribute at) {
        return this.attr.contains(at);
    }

    protected void encodeExtValue() throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.attr.size(); ++i) {
            Attribute at = (Attribute)this.attr.elementAt(i);
            at.encode(enc);
        }
        enc.endOf(id);
        this.extVal = enc.toByteArray();
    }

    protected void decodeExtValue() throws ASN1Exception {
        this.attr.removeAllElements();
        DERDecoder dec = new DERDecoder(this.extVal);
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            Attribute at = new Attribute();
            at.decode(dec);
            this.attr.addElement(at);
        }
    }

    protected boolean shouldOmitted() {
        return this.attr.size() == 0;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Subject Directory Attributes:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        if (this.shouldOmitted()) {
            this.indent(buf, n + 1);
            buf.append("<empty>\n");
        } else {
            for (int i = 0; i < this.attr.size(); ++i) {
                Attribute at = (Attribute)this.attr.elementAt(i);
                this.indent(buf, n + 1);
                buf.append("Attribute:\n");
                at.toString(buf, n + 2);
            }
        }
    }
}

