/*
 * Decompiled with CFR 0.152.
 */
package com.initech.x509.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PublicKey;

public class SubjectKeyIdentifier
extends Extension {
    private static final long serialVersionUID = 2532579520039304532L;
    public static final String OID = "2.5.29.14";
    private byte[] id = null;
    private static MessageDigest md;

    public SubjectKeyIdentifier() {
        this.setExtensionID(OID);
        this.setCritical(false);
    }

    public SubjectKeyIdentifier(byte[] data) throws ASN1Exception {
        this();
        this.extVal = (byte[])data.clone();
        this.decodeExtValue0();
    }

    public SubjectKeyIdentifier(PublicKey key) throws InvalidKeyException {
        this();
        this.setKID(key);
    }

    public synchronized void setKID(PublicKey key) throws InvalidKeyException {
        byte[] e = key.getEncoded();
        if (e == null) {
            throw new InvalidKeyException();
        }
        try {
            PublicKeyInfo pki = new PublicKeyInfo(e);
            e = pki.getPublicKeyAsByteArray();
        }
        catch (ASN1Exception ex) {
            throw new InvalidKeyException(ex.toString());
        }
        md.update(e);
        this.id = md.digest();
        md.reset();
        this.modified = true;
    }

    public void setKID(byte[] kid) {
        this.modified = true;
        this.id = (byte[])kid.clone();
    }

    public byte[] getKID() {
        if (this.id == null) {
            return null;
        }
        return (byte[])this.id.clone();
    }

    protected void encodeExtValue() throws ASN1Exception {
        byte[] val = new byte[2 + this.id.length];
        val[0] = 4;
        val[1] = (byte)this.id.length;
        System.arraycopy(this.id, 0, val, 2, this.id.length);
        this.extVal = val;
    }

    protected void decodeExtValue() throws ASN1Exception {
        if (this.extVal[0] != 4) {
            throw new ASN1Exception("Invalid Key ID");
        }
        byte[] val = new byte[this.extVal[1]];
        System.arraycopy(this.extVal, 2, val, 0, this.extVal[1]);
        this.id = val;
    }

    protected boolean shouldOmitted() {
        return this.id == null;
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 Subject Key Identifier:");
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append('\n');
        this.indent(buf, n + 1);
        buf.append("Key ID: ");
        Hex.dumpHex(buf, this.id, 0, this.id.length, ':');
        buf.append('\n');
    }

    static {
        try {
            md = MessageDigest.getInstance("SHA1", InitechProvider.NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

