/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.ocsp;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.core.crypto.INIMessageDigest;
import com.initech.core.ocsp.OCSPException;
import com.initech.pki.util.Hex;
import com.initech.x509.X509CertImpl;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class CertID
extends ASN1Object {
    public AlgorithmID hashAlg;
    public byte[] idh;
    public byte[] ikh;
    public BigInteger serial;

    public CertID() {
        this.hashAlg = null;
        this.idh = null;
        this.ikh = null;
        this.serial = null;
    }

    public CertID(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws OCSPException {
        this(AlgorithmID.SHA1, x509Certificate, x509Certificate2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public CertID(AlgorithmID var1_2, X509Certificate var2_3, X509Certificate var3_4) throws OCSPException {
        block8: {
            super();
            try {
                if (!(var2_3 /* !! */  instanceof X509CertImpl)) break block8;
            }
            catch (Exception var0_1) {
                throw new OCSPException(var0_1);
            }
            var2_3 /* !! */  = (X509CertImpl)var2_3 /* !! */ ;
            var4_5 /* !! */  = var2_3 /* !! */ ;
            ** GOTO lbl14
        }
        var4_5 /* !! */  = v0;
        v0 = new X509CertImpl(var2_3 /* !! */ .getEncoded());
lbl14:
        // 2 sources

        v1 = this;
        v2 = var1_2 /* !! */ ;
        v3 = var3_4;
        v4 /* !! */  = var4_5 /* !! */ ;
        v5 /* !! */  = v4 /* !! */ ;
        this = (Name)v4 /* !! */ .getSubjectDN();
        var1_2 /* !! */  = v5 /* !! */ .getPublicKey();
        var2_3 /* !! */  = v3.getSerialNumber();
        v1.set(v2, (Name)this, (PublicKey)var1_2 /* !! */ , (BigInteger)var2_3 /* !! */ );
    }

    public CertID(Name name, PublicKey publicKey, X509Certificate serializable) throws OCSPException {
        CertID certID = certID2;
        certID2();
        try {
            CertID certID2 = AlgorithmID.SHA1;
        }
        catch (Exception exception) {
            throw new OCSPException(exception);
        }
        serializable = serializable.getSerialNumber();
        certID.set((AlgorithmID)certID2, name, publicKey, (BigInteger)serializable);
    }

    public CertID(AlgorithmID algorithmID, Name name, PublicKey publicKey, X509Certificate x509Certificate) throws OCSPException {
        this();
        try {
            this.set(algorithmID, name, publicKey, x509Certificate.getSerialNumber());
            return;
        }
        catch (Exception exception) {
            throw new OCSPException(exception);
        }
    }

    public static boolean byteCompare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public void set(AlgorithmID algorithmID, Name object, PublicKey publicKey, BigInteger bigInteger) throws OCSPException {
        INIMessageDigest iNIMessageDigest;
        PublicKeyInfo publicKeyInfo;
        INIMessageDigest iNIMessageDigest2;
        BigInteger bigInteger2;
        try {
            CertID certID = object2;
            bigInteger2 = bigInteger;
            CertID certID2 = object2;
            CertID certID3 = certID2;
            CertID certID4 = certID2;
            certID2.hashAlg = (AlgorithmID)algorithmID.clone();
        }
        catch (Exception exception) {
            throw new OCSPException(exception);
        }
        Object object2 = iNIMessageDigest2;
        AlgorithmID algorithmID2 = algorithmID;
        ((INIMessageDigest)object2)();
        object2 = object.getEncoded();
        certID4.idh = iNIMessageDigest2.doDigest((byte[])object2, algorithmID2.getAlgName());
        object2 = publicKeyInfo;
        publicKeyInfo = new PublicKeyInfo(publicKey);
        object = iNIMessageDigest;
        AlgorithmID algorithmID3 = algorithmID;
        object();
        object2 = object2.getPublicKeyAsByteArray();
        certID3.ikh = iNIMessageDigest.doDigest((byte[])object2, algorithmID3.getAlgName());
        certID.serial = bigInteger2;
    }

    public boolean isMatched(CertID certID) throws OCSPException {
        return this.equals((Object)certID);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CertID)) {
            return false;
        }
        if (((CertID)((Object)(object = (CertID)((Object)object)))).getHashAlg().equals(((CertID)((Object)object)).getHashAlg())) {
            if (!CertID.byteCompare(this.idh, ((CertID)((Object)object)).idh)) {
                return false;
            }
            if (!CertID.byteCompare(this.ikh, ((CertID)((Object)object)).ikh)) {
                return false;
            }
            return this.serial.equals(((CertID)((Object)object)).serial);
        }
        return false;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        ASN1Encoder aSN1Encoder2 = aSN1Encoder;
        CertID certID = this;
        int n2 = aSN1Encoder.encodeSequence();
        certID.hashAlg.encode(aSN1Encoder);
        aSN1Encoder.encodeOctetString(certID.idh);
        aSN1Encoder.encodeOctetString(this.ikh);
        aSN1Encoder2.encodeInteger(this.serial);
        aSN1Encoder2.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        int n2 = aSN1Decoder.decodeSequence();
        if (this.hashAlg == null) {
            AlgorithmID algorithmID;
            AlgorithmID algorithmID2 = algorithmID;
            algorithmID = new AlgorithmID();
            this.hashAlg = algorithmID2;
        }
        this.hashAlg.decode(aSN1Decoder);
        this.idh = aSN1Decoder.decodeOctetString();
        this.ikh = aSN1Decoder.decodeOctetString();
        this.serial = aSN1Decoder.decodeInteger();
        aSN1Decoder.endOf(n2);
    }

    public String getHashAlgName() {
        return this.hashAlg.getAlgName();
    }

    public String getHashAlg() {
        return this.hashAlg.getAlg();
    }

    public BigInteger getSerialNumber() {
        return this.serial;
    }

    public byte[] getIssuerDNhash() {
        Object object = object.idh;
        if (object.idh != null) {
            return (byte[])object.clone();
        }
        return null;
    }

    public byte[] getIssuerKeyhash() {
        Object object = object.ikh;
        if (object.ikh != null) {
            return (byte[])object.clone();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3 = stringBuffer2 = stringBuffer;
        StringBuffer stringBuffer4 = stringBuffer2;
        StringBuffer stringBuffer5 = stringBuffer2;
        StringBuffer stringBuffer6 = stringBuffer2;
        stringBuffer6(80);
        stringBuffer6.append("[CertID/Hash : ");
        stringBuffer5.append(this.hashAlg.getAlgName());
        stringBuffer5.append(", Issuer DN Hash : ");
        stringBuffer4.append(Hex.dumpHex(this.idh));
        stringBuffer4.append(", Issuer Key Hash : ");
        stringBuffer3.append(Hex.dumpHex(this.ikh));
        stringBuffer3.append(", Serial : 0x");
        stringBuffer.append(this.serial.toString(16));
        stringBuffer.append(']');
        return new String(stringBuffer2);
    }
}

