/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger;

import com.initech.inibase.logger.Layout;
import com.initech.inibase.logger.WriterAppender;
import com.initech.inibase.logger.helpers.LogLog;
import java.io.OutputStreamWriter;

public class ConsoleAppender
extends WriterAppender {
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";
    public String target = "System.out";

    public ConsoleAppender() {
    }

    public ConsoleAppender(Layout layout) {
        this(layout, SYSTEM_OUT);
    }

    public ConsoleAppender(Layout layout, String string) {
        this.layout = layout;
        if (SYSTEM_OUT.equals(string)) {
            this.setWriter(new OutputStreamWriter(System.out));
            return;
        }
        if (SYSTEM_ERR.equalsIgnoreCase(string)) {
            this.setWriter(new OutputStreamWriter(System.err));
            return;
        }
        ConsoleAppender.a(string);
    }

    public static void a(String string) {
        LogLog.warn("[" + string + "] should be System.out or System.err.");
        LogLog.warn("Using previously set target, System.out by default.");
    }

    public void setTarget(String string) {
        String string2 = string.trim();
        if (SYSTEM_OUT.equalsIgnoreCase(string2)) {
            this.target = SYSTEM_OUT;
            return;
        }
        if (SYSTEM_ERR.equalsIgnoreCase(string2)) {
            this.target = SYSTEM_ERR;
            return;
        }
        ConsoleAppender.a(string);
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public void activateOptions() {
        if (this.target.equals(SYSTEM_OUT)) {
            this.setWriter(new OutputStreamWriter(System.out));
            return;
        }
        this.setWriter(new OutputStreamWriter(System.err));
    }

    @Override
    public final void closeWriter() {
    }
}

