/*
 * Decompiled with CFR 0.152.
 */
package com.initech.keystore.initechKeyStore;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Name;
import com.initech.cryptox.spec.PBEKeySpec;
import com.initech.keystore.EnhancedKeyStoreException;
import com.initech.keystore.initechKeyStore.TBMKeyStore;
import com.initech.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import com.initech.x509.X509CertImpl;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class PublicKeyEntry
implements ASN1Type {
    public EncryptedPrivateKeyInfo a;
    public Name b;
    public BigInteger c;
    public byte[] d;
    public Certificate[] e;

    public PublicKeyEntry() {
        Name name;
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        PublicKeyEntry publicKeyEntry = encryptedPrivateKeyInfo;
        encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo();
        v1.a = publicKeyEntry;
        publicKeyEntry = name;
        name = new Name();
        v1.b = publicKeyEntry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PublicKeyEntry(PrivateKey privateKey, Certificate[] pBEKeySpec, AlgorithmID algorithmID, char[] object) throws EnhancedKeyStoreException {
        PrivateKeyInfo privateKeyInfo;
        PBEKeySpec pBEKeySpec2;
        PBEKeySpec pBEKeySpec3 = pBEKeySpec;
        pBEKeySpec = pBEKeySpec2;
        try {
            pBEKeySpec2 = new PBEKeySpec(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EnhancedKeyStoreException(exception.toString());
        }
        PrivateKeyInfo privateKeyInfo2 = privateKeyInfo;
        privateKeyInfo = new PrivateKeyInfo(privateKey);
        this.a = new EncryptedPrivateKeyInfo(privateKeyInfo2, pBEKeySpec, algorithmID);
        Certificate[] certificateArray = PublicKeyEntry.sortCertificate((Certificate[])pBEKeySpec3);
        this.e = certificateArray;
        privateKey = TBMKeyStore.getIssuerAndSerialNumber(certificateArray[0]);
        if (privateKey == null) throw new EnhancedKeyStoreException("IssuerAndSerialNumber\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        this.b = privateKey.getName();
        this.c = privateKey.getSerialNumber();
        this.d = TBMKeyStore.getSubjectKeyIdentifier(this.e[0]);
    }

    public PublicKeyEntry(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] certificateArray) {
        this.a = encryptedPrivateKeyInfo;
        this.e = PublicKeyEntry.sortCertificate(certificateArray);
        encryptedPrivateKeyInfo = TBMKeyStore.getIssuerAndSerialNumber(this.e[0]);
        if (encryptedPrivateKeyInfo != null) {
            this.b = encryptedPrivateKeyInfo.getName();
            this.c = encryptedPrivateKeyInfo.getSerialNumber();
            this.d = TBMKeyStore.getSubjectKeyIdentifier(this.e[0]);
        }
    }

    public static Certificate[] sortCertificate(Certificate[] certificateArray) {
        int n2 = 1;
        int n3 = 0;
        Certificate[] certificateArray2 = new Certificate[certificateArray.length];
        Certificate[] certificateArray3 = certificateArray2;
        certificateArray2[0] = null;
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            X509Certificate x509Certificate = (X509Certificate)certificateArray[i2];
            for (int i3 = 0; i3 < certificateArray.length; ++i3) {
                X509Certificate x509Certificate2 = (X509Certificate)certificateArray[i3];
                if (((Object)x509Certificate.getSubjectDN()).toString().equals(((Object)x509Certificate2.getIssuerDN()).toString())) {
                    if (i2 == i3) {
                        n3 = i2;
                    }
                    n2 = 0;
                    break;
                }
                n2 = 1;
            }
            if (n2 == 0) continue;
            certificateArray3[0] = certificateArray[i2];
        }
        if (certificateArray3[0] == null) {
            certificateArray3[0] = certificateArray[n3];
        }
        for (n3 = 0; n3 < certificateArray.length - 1; ++n3) {
            X509Certificate x509Certificate = (X509Certificate)certificateArray3[n3];
            for (int i4 = 0; i4 < certificateArray.length; ++i4) {
                X509Certificate x509Certificate3 = (X509Certificate)certificateArray[i4];
                if (((Object)x509Certificate.getIssuerDN()).toString().equals(((Object)x509Certificate3.getSubjectDN()).toString())) {
                    n2 = n3 + 1;
                    certificateArray3[n2] = certificateArray[i4];
                    n2 = 0;
                    break;
                }
                n2 = 1;
            }
            if (n2 != 0) break;
        }
        return certificateArray3;
    }

    public PrivateKey getPrivateKey(char[] cArray) throws EnhancedKeyStoreException {
        try {
            return this.a.decrypt(new PBEKeySpec(cArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EnhancedKeyStoreException(exception.toString());
        }
    }

    public Certificate[] getCertChain() {
        return this.e;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        ASN1Encoder aSN1Encoder2 = aSN1Encoder;
        PublicKeyEntry publicKeyEntry = this;
        int n2 = aSN1Encoder.encodeSequence();
        publicKeyEntry.a.encode(aSN1Encoder);
        publicKeyEntry.b.encode(aSN1Encoder);
        aSN1Encoder.encodeInteger(publicKeyEntry.c);
        aSN1Encoder2.encodeOctetString(this.d);
        int n3 = aSN1Encoder2.encodeSequenceOf();
        int n4 = 0;
        while (true) {
            block6: {
                byte[] byArray;
                Certificate[] certificateArray;
                int n5;
                try {
                    n5 = n4;
                    certificateArray = this.e;
                }
                catch (Exception exception) {
                    throw new ASN1Exception(exception.toString());
                }
                {
                    if (n5 >= this.e.length) break;
                    if (certificateArray[n4] instanceof X509CertImpl) {
                        ((X509CertImpl)certificateArray[n4]).encode(aSN1Encoder);
                        break block6;
                    }
                    byArray = certificateArray[n4].getEncoded();
                }
                {
                    new X509CertImpl(byArray).encode(aSN1Encoder);
                }
            }
            ++n4;
        }
        ASN1Encoder aSN1Encoder3 = aSN1Encoder;
        aSN1Encoder3.endOf(n3);
        aSN1Encoder3.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        Vector<X509CertImpl> vector;
        PublicKeyEntry publicKeyEntry = this;
        int n2 = aSN1Decoder.decodeSequence();
        publicKeyEntry.a.decode(aSN1Decoder);
        publicKeyEntry.b.decode(aSN1Decoder);
        this.c = aSN1Decoder.decodeInteger();
        this.d = aSN1Decoder.decodeOctetString();
        int n3 = aSN1Decoder.decodeSequenceOf();
        Vector<X509CertImpl> vector2 = vector;
        vector = new Vector<X509CertImpl>();
        while (!aSN1Decoder.endOf(n3)) {
            X509CertImpl x509CertImpl;
            X509CertImpl x509CertImpl2 = x509CertImpl;
            new X509CertImpl().decode(aSN1Decoder);
            vector2.addElement(x509CertImpl2);
        }
        this.e = new Certificate[vector2.size()];
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            this.e[n3] = (Certificate)vector2.elementAt(n3);
        }
        aSN1Decoder.endOf(n2);
    }
}

