/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs11;

import com.initech.pkcs.pkcs11.PKCS11Constants;
import com.initech.pkcs.pkcs11.data.CK_MECHANISM_INFO;

public class MechanismInfo
implements PKCS11Constants {
    public long a;
    public long b;
    public long c;

    public MechanismInfo(CK_MECHANISM_INFO cK_MECHANISM_INFO) {
        this.a = cK_MECHANISM_INFO.ulMinKeySize;
        this.b = cK_MECHANISM_INFO.ulMaxKeySize;
        this.c = cK_MECHANISM_INFO.flags;
    }

    public long getMinKeySize() {
        return this.a;
    }

    public long getMaxKeySize() {
        return this.b;
    }

    public long getFlags() {
        return this.c;
    }

    public boolean isCipher() {
        return (this.c & 0x300L) != 0L;
    }

    public boolean isMessageDigest() {
        return (this.c & 0x400L) != 0L;
    }

    public boolean isSignature() {
        return (this.c & 0x2800L) != 0L;
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3 = stringBuffer2 = stringBuffer;
        StringBuffer stringBuffer4 = stringBuffer2;
        StringBuffer stringBuffer5 = stringBuffer2;
        stringBuffer5();
        stringBuffer5.append("Min Key Size : ");
        stringBuffer4.append(this.a);
        stringBuffer4.append('\n');
        stringBuffer4.append("Max Key Size : ");
        stringBuffer3.append(this.b);
        stringBuffer3.append('\n');
        stringBuffer3.append("Flags : 0x");
        stringBuffer.append(Long.toString(this.c, 16));
        stringBuffer.append('\n');
        return new String(stringBuffer2);
    }
}

