/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pki.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    public byte[] buf;
    public int pos;

    public PushbackInputStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 > 0) {
            this.buf = new byte[n2];
            this.pos = n2;
            return;
        }
        throw new IllegalArgumentException("size <= 0");
    }

    public PushbackInputStream(InputStream inputStream) {
        this(inputStream, 1);
    }

    @Override
    public int read() throws IOException {
        PushbackInputStream pushbackInputStream = this;
        pushbackInputStream.a();
        int n2 = pushbackInputStream.pos;
        byte[] byArray = this.buf;
        if (n2 < this.buf.length) {
            this.pos = n2 + 1;
            return byArray[n2] & 0xFF;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this.a();
        if (n2 >= 0 && n2 <= byArray.length && n3 >= 0 && (n4 = n2 + n3) <= byArray.length && n4 >= 0) {
            if (n3 == 0) {
                return 0;
            }
            byte[] byArray2 = this.buf;
            int n5 = this.pos;
            int n6 = this.buf.length - n5;
            if (n6 > 0) {
                if (n3 < n6) {
                    n6 = n3;
                }
                System.arraycopy(byArray2, n5, byArray, n2, n6);
                this.pos += n6;
                n2 += n6;
                n3 -= n6;
            }
            if (n3 > 0) {
                int n7 = super.read(byArray, n2, n3);
                if (n7 == -1) {
                    if (n6 == 0) {
                        n6 = -1;
                    }
                    return n6;
                }
                return n6 + n7;
            }
            return n6;
        }
        throw new IndexOutOfBoundsException();
    }

    public void unread(int n2) throws IOException {
        PushbackInputStream pushbackInputStream = this;
        pushbackInputStream.a();
        int n3 = pushbackInputStream.pos;
        if (n3 != 0) {
            int n4;
            this.pos = n4 = n3 - 1;
            this.buf[n4] = (byte)n2;
            return;
        }
        throw new IOException("Push back buffer is full");
    }

    public void unread(byte[] byArray, int n2, int n3) throws IOException {
        PushbackInputStream pushbackInputStream = this;
        pushbackInputStream.a();
        int n4 = pushbackInputStream.pos;
        if (n3 <= n4) {
            int n5;
            this.pos = n5 = n4 - n3;
            System.arraycopy(byArray, n2, this.buf, n5, n3);
            return;
        }
        throw new IOException("Push back buffer is full");
    }

    public void unread(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.unread(byArray, 0, n2);
    }

    @Override
    public int available() throws IOException {
        PushbackInputStream pushbackInputStream = this;
        pushbackInputStream.a();
        return pushbackInputStream.buf.length - this.pos + super.available();
    }

    @Override
    public long skip(long l2) throws IOException {
        this.a();
        if (l2 <= 0L) {
            return 0L;
        }
        int n2 = this.pos;
        long l3 = this.buf.length - n2;
        if (l3 > 0L) {
            if (l2 < l3) {
                l3 = l2;
            }
            this.pos = (int)((long)n2 + l3);
            l2 -= l3;
        }
        if (l2 > 0L) {
            l3 += super.skip(l2);
        }
        return l3;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    public final void a() throws IOException {
        if (this.in != null) {
            return;
        }
        throw new IOException("Stream closed");
    }
}

