/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkix.cmp.client.util;

import com.initech.pkix.cmp.client.util.ParseException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;

public class URI {
    public static final boolean ENABLE_BACKWARDS_COMPATIBILITY = true;
    public static final Hashtable defaultPorts;
    public static final Hashtable usesGenericSyntax;
    public static final Hashtable usesSemiGenericSyntax;
    public static final BitSet alphanumChar;
    public static final BitSet markChar;
    public static final BitSet reservedChar;
    public static final BitSet unreservedChar;
    public static final BitSet uricChar;
    public static final BitSet pcharChar;
    public static final BitSet userinfoChar;
    public static final BitSet schemeChar;
    public static final BitSet hostChar;
    public static final BitSet opaqueChar;
    public static final BitSet reg_nameChar;
    public static final BitSet resvdSchemeChar;
    public static final BitSet resvdUIChar;
    public static final BitSet resvdHostChar;
    public static final BitSet resvdPathChar;
    public static final BitSet resvdQueryChar;
    public static final BitSet escpdPathChar;
    public static final BitSet escpdQueryChar;
    public static final BitSet escpdFragChar;
    public static final int OPAQUE = 0;
    public static final int SEMI_GENERIC = 1;
    public static final int GENERIC = 2;
    public static final char[] b;
    public int type;
    public String scheme;
    public String opaque;
    public String userinfo;
    public String host;
    public int port = -1;
    public String path;
    public String query;
    public String fragment;
    public URL url = null;
    public int a = -1;

    public URI(String string) throws ParseException {
        this((URI)null, string);
    }

    public URI(URI object, String string) throws ParseException {
        String string2;
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        for (n3 = 0; n3 < n4 && Character.isWhitespace(cArray[n3]); ++n3) {
        }
        while (n4 > 0 && Character.isWhitespace(cArray[n4 - 1])) {
            --n4;
        }
        if (!(n3 >= n4 - 3 || cArray[n3 + 3] != ':' || cArray[n3] != 'u' && cArray[n3] != 'U' || cArray[n2 = n3 + 1] != 'r' && cArray[n2] != 'R' || cArray[n2 = n3 + 2] != 'i' && cArray[n2] != 'I' && cArray[n2] != 'l' && cArray[n2] != 'L')) {
            n3 += 4;
        }
        for (n2 = n3; n2 < n4 && cArray[n2] != ':' && cArray[n2] != '/' && cArray[n2] != '?' && cArray[n2] != '#'; ++n2) {
        }
        if (n2 < n4 && cArray[n2] == ':') {
            this.scheme = string.substring(n3, n2).trim().toLowerCase();
            n3 = n2 + 1;
        }
        if ((string2 = this.scheme) == null) {
            if (object != null) {
                string2 = ((URI)object).scheme;
            } else {
                throw new ParseException("No scheme found");
            }
        }
        int n5 = URI.usesGenericSyntax(string2) ? 2 : (URI.usesSemiGenericSyntax(string2) ? 1 : 0);
        this.type = n5;
        if (n5 == 0) {
            if (object != null && this.scheme == null) {
                throw new ParseException("Can't resolve relative URI for scheme " + string2);
            }
            object = URI.escape(string.substring(n3), opaqueChar, true);
            this.opaque = object;
            if (((String)object).length() > 0 && this.opaque.charAt(0) == '/') {
                this.opaque = "%2F" + this.opaque.substring(1);
            }
            return;
        }
        n5 = n3 + 1;
        if (n5 < n4 && cArray[n3] == '/' && cArray[n5] == '/') {
            for (n5 = n3 += 2; n5 < n4 && cArray[n5] != '/' && cArray[n5] != '?' && cArray[n5] != '#'; ++n5) {
            }
            this.a(string.substring(n3, n5), string2);
        } else {
            n5 = n3;
        }
        if (this.type == 1) {
            this.path = string = URI.escape(string.substring(n5), uricChar, true);
            if (string.length() > 0 && this.path.charAt(0) != '/') {
                this.path = "/" + this.path;
            }
        } else {
            int n6;
            for (n3 = n5; n3 < n4 && cArray[n3] != '?' && cArray[n3] != '#'; ++n3) {
            }
            this.path = URI.escape(string.substring(n5, n3), escpdPathChar, true);
            if (n3 < n4 && cArray[n3] == '?') {
                for (n6 = ++n3; n6 < n4 && cArray[n6] != '#'; ++n6) {
                }
                this.query = URI.escape(string.substring(n3, n6), escpdQueryChar, true);
            } else {
                n6 = n3;
            }
            if (n6 < n4 && cArray[n6] == '#') {
                this.fragment = URI.escape(string.substring(n6 + 1, n4), escpdFragChar, true);
            }
        }
        if (object != null) {
            string = this.scheme;
            if (string != null && !string.equals(((URI)object).scheme)) {
                return;
            }
            this.scheme = ((URI)object).scheme;
            if (this.host != null) {
                return;
            }
            this.userinfo = ((URI)object).userinfo;
            this.host = ((URI)object).host;
            this.port = ((URI)object).port;
            if (this.type == 1) {
                return;
            }
            if (this.path.length() == 0 && this.query == null) {
                this.path = ((URI)object).path;
                this.query = ((URI)object).query;
                return;
            }
            if (this.path.length() == 0 || this.path.charAt(0) != '/') {
                string = ((URI)object).path;
                int n7 = string != null ? string.lastIndexOf(47) : -1;
                this.path = n7 < 0 ? "/" + this.path : ((URI)object).path.substring(0, n7 + 1) + this.path;
                this.path = URI.canonicalizePath(this.path);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String canonicalizePath(String var0) {
        block7: {
            v0 = var0;
            var1_2 = v0.length();
            var2_3 = v0.indexOf("/.");
            if (var2_3 == -1 || var2_3 != var1_2 - 2 && var0.charAt(var3_5 = var2_3 + 2) != '/' && (var0.charAt(var3_5) != '.' || var2_3 != var1_2 - 3 && var0.charAt(var2_3 + 3) != '/')) break block7;
            v1 = var0;
            var0_1 = v1.length();
            var2_4 = new char[var0_1];
            v1.getChars(0, var0_1, var2_4, 0);
            var0_1 = 0;
            var3_5 = 1;
            while (var3_5 < var1_2) {
                block9: {
                    block8: {
                        if (var2_4[var3_5] != '.' || var2_4[var4_6 = var3_5 - 1] != '/') ** GOTO lbl-1000
                        if (var3_5 != var1_2 - 1) break block8;
                        var4_6 = var3_5 + 1;
                        var5_7 = var3_5;
                        var3_5 = var4_6;
                        ** GOTO lbl37
                    }
                    var5_7 = var3_5 + 1;
                    if (var2_4[var5_7] != '/') break block9;
                    v2 = var5_7;
                    var5_7 = var4_6;
                    var3_5 = v2;
                    ** GOTO lbl37
                }
                if (var2_4[var5_7] != '.' || var3_5 != (var4_6 = var1_2 - 2) && var2_4[var3_5 + 2] != '/') ** GOTO lbl-1000
                if (var3_5 < var0_1 + 2) {
                    var0_1 = var3_5 + 2;
                    var5_7 = var3_5;
                } else {
                    for (var5_7 = var3_5 - 2; var5_7 > var0_1 && var2_4[var5_7] != '/'; --var5_7) {
                    }
                    if (var2_4[var5_7] == '/') {
                        if (var3_5 == var4_6) {
                            ++var5_7;
                        }
                        var3_5 += 2;
lbl37:
                        // 3 sources

                        v3 = var1_2;
                        System.arraycopy(var2_4, var3_5, var2_4, var5_7, var1_2 -= var3_5);
                        var1_2 = v3 - (var3_5 - var5_7);
                    } else lbl-1000:
                    // 3 sources

                    {
                        var5_7 = var3_5;
                    }
                }
                var3_5 = var5_7 + 1;
            }
            return new String(var2_4, 0, var1_2);
        }
        return var0;
    }

    public URI(URL uRL) throws ParseException {
        this((URI)null, uRL.toExternalForm());
    }

    public URI(String string, String string2, String string3) throws ParseException {
        this(string, null, string2, -1, string3, null, null);
    }

    public URI(String string, String string2, int n2, String string3) throws ParseException {
        this(string, null, string2, n2, string3, null, null);
    }

    public URI(String string, String string2, String string3, int n2, String string4, String string5, String string6) throws ParseException {
        if (string != null) {
            this.scheme = URI.escape(string.trim().toLowerCase(), schemeChar, true);
            if (string2 != null) {
                this.userinfo = URI.escape(string2.trim(), userinfoChar, true);
            }
            if (string3 != null) {
                string2 = string3.trim();
                if (!URI.a(string2)) {
                    string2 = URI.escape(string2, hostChar, true);
                }
                this.host = string2;
            }
            if (n2 != URI.defaultPort(string)) {
                this.port = n2;
            }
            if (string4 != null) {
                this.path = URI.escape(string4.trim(), escpdPathChar, true);
            }
            if (string5 != null) {
                this.query = URI.escape(string5.trim(), escpdQueryChar, true);
            }
            if (string6 != null) {
                this.fragment = URI.escape(string6.trim(), escpdFragChar, true);
            }
            int n3 = URI.usesGenericSyntax(string) ? 2 : 1;
            this.type = n3;
            return;
        }
        throw new ParseException("missing scheme");
    }

    public static final boolean a(String string) {
        if (string.indexOf(58) < 0) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 == ':') continue;
            return false;
        }
        return true;
    }

    public URI(String string, String string2) throws ParseException {
        if (string != null) {
            URI uRI = this;
            this.scheme = URI.escape(string.trim().toLowerCase(), schemeChar, true);
            uRI.opaque = URI.escape(string2, opaqueChar, true);
            uRI.type = 0;
            return;
        }
        throw new ParseException("missing scheme");
    }

    public static boolean usesGenericSyntax(String string) {
        return usesGenericSyntax.containsKey(string.trim().toLowerCase());
    }

    public static boolean usesSemiGenericSyntax(String string) {
        return usesSemiGenericSyntax.containsKey(string.trim().toLowerCase());
    }

    public static final int defaultPort(String object) {
        if ((object = (Integer)defaultPorts.get(((String)object).trim().toLowerCase())) != null) {
            return (Integer)object;
        }
        return 0;
    }

    public static final boolean b(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && (string.equals(string2) || URI.a(string, null).equals(URI.a(string2, null)));
    }

    public static final boolean c(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && (string.equalsIgnoreCase(string2) || URI.a(string, null).equalsIgnoreCase(URI.a(string2, null)));
    }

    public static final boolean d(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string2 != null) {
            if (string.equals(string2)) {
                return true;
            }
            int n2 = 0;
            int n3 = string.length();
            int n4 = 0;
            int n5 = string2.length();
            while (n2 < n3 && n4 < n5) {
                int n6;
                int n7;
                int n8;
                for (n8 = n2; n8 < n3; ++n8) {
                    char c2 = string.charAt(n8);
                    n7 = c2;
                    if (c2 == '/' || n7 == 59) break;
                }
                for (n7 = n4; n7 < n5 && (n6 = string2.charAt(n7)) != 47 && n6 != 59; ++n7) {
                }
                if (n8 == n3 && n7 < n5 || n7 == n5 && n8 < n3 || n8 < n3 && n7 < n5 && string.charAt(n8) != string2.charAt(n7)) {
                    return false;
                }
                n6 = n8 - n2;
                if (!(string.regionMatches(n2, string2, n4, n6) && n6 == n7 - n4 || URI.a(string.substring(n2, n8), null).equals(URI.a(string2.substring(n4, n7), null)))) {
                    return false;
                }
                n2 = n8 + 1;
                n4 = n7 + 1;
            }
            return n2 == n3 && n4 == n5;
        }
        return false;
    }

    public static String escape(String string, BitSet bitSet, boolean bl) {
        return new String(URI.escape(string.toCharArray(), bitSet, bl));
    }

    public static char[] escape(char[] cArray, BitSet bitSet, boolean bl) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < cArray.length; ++n3) {
            if (bitSet.get(cArray[n3])) continue;
            n4 += 2;
            if (!bl) continue;
            if (cArray[n3] >= '\u0080') {
                n4 += 3;
            }
            if (cArray[n3] >= '\u0800') {
                n4 += 3;
            }
            if ((cArray[n3] & 0xFC00) != 55296 || (n2 = n3 + 1) >= cArray.length || (cArray[n2] & 0xFC00) != 56320) continue;
            n4 -= 6;
        }
        if (n4 == 0) {
            return cArray;
        }
        char[] cArray2 = new char[cArray.length + n4];
        n3 = 0;
        n2 = 0;
        while (n3 < cArray.length) {
            int n5;
            char c2 = cArray[n3];
            if (bitSet.get(c2)) {
                n5 = n2 + 1;
                cArray2[n2] = c2;
                n2 = n5;
                n5 = n3;
            } else if (bl && c2 > '\u007f') {
                if (c2 <= '\u07ff') {
                    n2 = URI.a(cArray2, n2, c2 >> 6 & 0x1F | 0xC0);
                    n2 = n5 = URI.a(cArray2, n2, c2 & 0x3F | 0x80);
                    n5 = n3;
                } else if ((c2 & 0xFC00) == 55296 && (n5 = n3 + 1) < cArray.length && (cArray[n5] & 0xFC00) == 56320) {
                    int n6 = ((c2 & 0x3FF) << 10 | cArray[n5] & 0x3FF) + 65536;
                    int n7 = n3 = n6;
                    int n8 = n3;
                    n3 = URI.a(cArray2, n2, n3 >> 18 & 7 | 0xF0);
                    n3 = URI.a(cArray2, n3, n8 >> 12 & 0x3F | 0x80);
                    n3 = URI.a(cArray2, n3, n7 >> 6 & 0x3F | 0x80);
                    n2 = n3 = URI.a(cArray2, n3, n6 & 0x3F | 0x80);
                } else {
                    n2 = URI.a(cArray2, n2, c2 >> 12 & 0xF | 0xE0);
                    n2 = URI.a(cArray2, n2, c2 >> 6 & 0x3F | 0x80);
                    n2 = URI.a(cArray2, n2, c2 & 0x3F | 0x80);
                    n5 = n3;
                }
            } else {
                n2 = URI.a(cArray2, n2, c2);
                n5 = n3;
            }
            n3 = n5 + 1;
        }
        return cArray2;
    }

    public static final int a(char[] cArray, int n2, int n3) {
        cArray[n2++] = 37;
        int n4 = n2 + 1;
        char[] cArray2 = b;
        cArray[n2] = b[n3 >> 4 & 0xF];
        cArray[n4] = cArray2[n3 & 0xF];
        return n4 + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String unescape(String string, BitSet bitSet) throws ParseException {
        if (string == null || string.indexOf(37) == -1) return string;
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        char[] cArray3 = new char[4];
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            int n5;
            if (cArray[i2] == '%') {
                block23: {
                    n5 = i2 + 3;
                    if (n5 > cArray.length) throw new NumberFormatException();
                    n5 = Integer.parseInt(string.substring(i2 + 1, n5), 16);
                    if (n5 < 0) break block23;
                    i2 += 2;
                }
                try {
                    throw new NumberFormatException();
                }
                catch (NumberFormatException numberFormatException) {
                    n5 = cArray[i2];
                }
                if (n3 > 0) {
                    if ((n5 & 0xC0) != 128) {
                        n4 = URI.a(cArray3, n2, n5, cArray2, n4, bitSet, false);
                        n3 = -1;
                        int n6 = n2;
                        n2 = n4;
                        n5 = n6;
                    } else if (n2 == n3 - 1) {
                        n5 = (cArray3[0] & 0xE0) == 192 ? (cArray3[0] & 0x1F) << 6 | n5 & 0x3F : ((cArray3[0] & 0xF0) == 224 ? (cArray3[0] & 0xF) << 12 | (cArray3[1] & 0x3F) << 6 | n5 & 0x3F : (cArray3[0] & 7) << 18 | (cArray3[1] & 0x3F) << 12 | (cArray3[2] & 0x3F) << 6 | n5 & 0x3F);
                        if (bitSet != null && bitSet.get(n5)) {
                            n4 = n3 = URI.a(cArray3, n2, n5, cArray2, n4, null, true);
                        } else if (n3 < 4) {
                            n3 = n4 + 1;
                            cArray2[n4] = (char)n5;
                            n4 = n3;
                        } else {
                            int n7 = n5 - 65536;
                            int n8 = n3 = n7;
                            n3 = n4 + 1;
                            cArray2[n4] = (char)(n8 >> 10 | 0xD800);
                            n4 = n3 + 1;
                            cArray2[n3] = (char)(n7 & 0x3FF | 0xDC00);
                        }
                        n3 = -1;
                        int n9 = n2;
                        n2 = n4;
                        n5 = n9;
                    } else {
                        int n10 = n5;
                        n5 = n2 + 1;
                        cArray3[n2] = (char)n10;
                        n2 = n4;
                    }
                } else {
                    int n11 = n5 & 0xE0;
                    if (n11 != 192 && (n5 & 0xF0) != 224 && (n5 & 0xF8) != 240) {
                        if (bitSet != null && bitSet.get(n5)) {
                            n5 = n4 + 1;
                            cArray2[n4] = cArray[i2];
                            i2 -= 2;
                            int n12 = n2;
                            n2 = n5;
                            n5 = n12;
                        } else {
                            int n13 = n5;
                            n5 = n4 + 1;
                            cArray2[n4] = (char)n13;
                            int n14 = n2;
                            n2 = n5;
                            n5 = n14;
                        }
                    } else {
                        n2 = n11 == 192 ? 2 : ((n5 & 0xF0) == 224 ? 3 : 4);
                        cArray3[0] = (char)n5;
                        n5 = 1;
                        int n15 = n2;
                        n2 = n4;
                        n3 = n15;
                    }
                }
            } else if (n3 > 0) {
                n5 = URI.a(cArray3, n2, cArray[i2], cArray2, n4, bitSet, false);
                n3 = -1;
                int n16 = n2;
                n2 = n5;
                n5 = n16;
            } else {
                n5 = n4 + 1;
                cArray2[n4] = cArray[i2];
                int n17 = n2;
                n2 = n5;
                n5 = n17;
            }
            n4 = n2;
            n2 = n5;
        }
        if (n3 <= 0) return new String(cArray2, 0, n4);
        n4 = URI.a(cArray3, n2, -1, cArray2, n4, bitSet, false);
        return new String(cArray2, 0, n4);
    }

    public static final int a(char[] cArray, int n2, int n3, char[] cArray2, int n4, BitSet bitSet, boolean bl) {
        if (n3 >= 0) {
            int n5 = n3;
            n3 = n2 + 1;
            cArray[n2] = (char)n5;
        } else {
            n3 = n2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n6;
            if (bitSet != null && bitSet.get(cArray[n2]) || bl) {
                n6 = n4 = URI.a(cArray2, n4, cArray[n2]);
            } else {
                n6 = n4 + 1;
                cArray2[n4] = cArray[n2];
            }
            n4 = n6;
        }
        return n4;
    }

    public static final String a(String string, BitSet bitSet) {
        try {
            return URI.unescape(string, bitSet);
        }
        catch (ParseException parseException) {
            return string;
        }
    }

    static {
        BitSet bitSet;
        BitSet bitSet2;
        BitSet bitSet3;
        BitSet bitSet4;
        BitSet bitSet5;
        int n2;
        Integer n3;
        Integer n4;
        Integer n5;
        Integer n6;
        Integer n7;
        Integer n8;
        Integer n9;
        Integer n10;
        Integer n11;
        Integer n12;
        Integer n13;
        Integer n14;
        Integer n15;
        Integer n16;
        Integer n17;
        Integer n18;
        Integer n19;
        Integer n20;
        Integer n21;
        Integer n22;
        Integer n23;
        Integer n24;
        Integer n25;
        Integer n26;
        Integer n27;
        Integer n28;
        Integer n29;
        Integer n30;
        Hashtable hashtable;
        Hashtable hashtable2;
        Hashtable hashtable3;
        Serializable serializable = hashtable3;
        defaultPorts = new Hashtable();
        Cloneable cloneable = hashtable2;
        usesGenericSyntax = new Hashtable();
        Cloneable cloneable2 = hashtable;
        Hashtable hashtable4 = cloneable;
        Hashtable hashtable5 = serializable;
        Hashtable hashtable6 = cloneable2;
        hashtable6();
        usesSemiGenericSyntax = hashtable6;
        serializable = n30;
        n30 = new Integer(80);
        hashtable5.put("http", serializable);
        serializable = n29;
        n29 = new Integer(80);
        hashtable5.put("shttp", serializable);
        serializable = n28;
        n28 = new Integer(80);
        hashtable5.put("http-ng", serializable);
        serializable = n27;
        n27 = new Integer(80);
        hashtable5.put("coffee", serializable);
        serializable = n26;
        n26 = new Integer(443);
        hashtable5.put("https", serializable);
        serializable = n25;
        n25 = new Integer(21);
        hashtable5.put("ftp", serializable);
        serializable = n24;
        n24 = new Integer(23);
        hashtable5.put("telnet", serializable);
        serializable = n23;
        n23 = new Integer(119);
        hashtable5.put("nntp", serializable);
        serializable = n22;
        n22 = new Integer(119);
        hashtable5.put("news", serializable);
        serializable = n21;
        n21 = new Integer(563);
        hashtable5.put("snews", serializable);
        serializable = n20;
        n20 = new Integer(80);
        hashtable5.put("hnews", serializable);
        serializable = n19;
        n19 = new Integer(25);
        hashtable5.put("smtp", serializable);
        serializable = n18;
        n18 = new Integer(70);
        hashtable5.put("gopher", serializable);
        serializable = n17;
        n17 = new Integer(210);
        hashtable5.put("wais", serializable);
        serializable = n16;
        n16 = new Integer(43);
        hashtable5.put("whois", serializable);
        serializable = n15;
        n15 = new Integer(63);
        hashtable5.put("whois++", serializable);
        serializable = n14;
        n14 = new Integer(4321);
        hashtable5.put("rwhois", serializable);
        serializable = n13;
        n13 = new Integer(143);
        hashtable5.put("imap", serializable);
        serializable = n12;
        n12 = new Integer(110);
        hashtable5.put("pop", serializable);
        serializable = n11;
        n11 = new Integer(1525);
        hashtable5.put("prospero", serializable);
        serializable = n10;
        n10 = new Integer(194);
        hashtable5.put("irc", serializable);
        serializable = n9;
        n9 = new Integer(389);
        hashtable5.put("ldap", serializable);
        serializable = n8;
        n8 = new Integer(2049);
        hashtable5.put("nfs", serializable);
        serializable = n7;
        n7 = new Integer(210);
        hashtable5.put("z39.50r", serializable);
        serializable = n6;
        n6 = new Integer(210);
        hashtable5.put("z39.50s", serializable);
        serializable = n5;
        n5 = new Integer(575);
        hashtable5.put("vemmi", serializable);
        serializable = n4;
        n4 = new Integer(516);
        hashtable5.put("videotex", serializable);
        serializable = n3;
        n3 = new Integer(829);
        hashtable5.put("cmp", serializable);
        serializable = Boolean.TRUE;
        hashtable4.put("http", serializable);
        hashtable4.put("https", serializable);
        hashtable4.put("shttp", serializable);
        hashtable4.put("coffee", serializable);
        hashtable4.put("ftp", serializable);
        hashtable4.put("file", serializable);
        hashtable4.put("nntp", serializable);
        hashtable4.put("news", serializable);
        hashtable4.put("snews", serializable);
        hashtable4.put("hnews", serializable);
        hashtable4.put("imap", serializable);
        hashtable4.put("wais", serializable);
        hashtable4.put("nfs", serializable);
        hashtable4.put("sip", serializable);
        hashtable4.put("sips", serializable);
        hashtable4.put("sipt", serializable);
        hashtable4.put("sipu", serializable);
        hashtable.put("ldap", serializable);
        hashtable.put("irc", serializable);
        hashtable.put("gopher", serializable);
        hashtable.put("videotex", serializable);
        hashtable.put("rwhois", serializable);
        hashtable.put("whois++", serializable);
        hashtable.put("smtp", serializable);
        hashtable.put("telnet", serializable);
        hashtable.put("prospero", serializable);
        hashtable.put("pop", serializable);
        hashtable.put("vemmi", serializable);
        hashtable.put("z39.50r", serializable);
        hashtable.put("z39.50s", serializable);
        hashtable.put("stream", serializable);
        hashtable.put("cmp", serializable);
        alphanumChar = new BitSet(128);
        for (n2 = 48; n2 <= 57; ++n2) {
            alphanumChar.set(n2);
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            alphanumChar.set(n2);
        }
        for (n2 = 97; n2 <= 122; ++n2) {
            alphanumChar.set(n2);
        }
        BitSet bitSet6 = bitSet5;
        markChar = new BitSet(128);
        bitSet6.set(45);
        bitSet6.set(95);
        bitSet6.set(46);
        bitSet6.set(33);
        bitSet6.set(126);
        bitSet6.set(42);
        bitSet6.set(39);
        bitSet6.set(40);
        bitSet6.set(41);
        cloneable = bitSet4;
        reservedChar = new BitSet(128);
        ((BitSet)cloneable).set(59);
        ((BitSet)cloneable).set(47);
        ((BitSet)cloneable).set(63);
        ((BitSet)cloneable).set(58);
        ((BitSet)cloneable).set(64);
        ((BitSet)cloneable).set(38);
        ((BitSet)cloneable).set(61);
        ((BitSet)cloneable).set(43);
        ((BitSet)cloneable).set(36);
        ((BitSet)cloneable).set(44);
        cloneable2 = bitSet3;
        unreservedChar = new BitSet(128);
        BitSet bitSet7 = alphanumChar;
        ((BitSet)cloneable2).or(bitSet7);
        ((BitSet)cloneable2).or(bitSet6);
        bitSet6 = bitSet2;
        uricChar = new BitSet(128);
        bitSet6.or((BitSet)cloneable2);
        bitSet6.or((BitSet)cloneable);
        bitSet6.set(37);
        cloneable = bitSet;
        pcharChar = new BitSet(128);
        ((BitSet)cloneable).or((BitSet)cloneable2);
        ((BitSet)cloneable).set(37);
        ((BitSet)cloneable).set(58);
        ((BitSet)cloneable).set(64);
        ((BitSet)cloneable).set(38);
        ((BitSet)cloneable).set(61);
        ((BitSet)cloneable).set(43);
        ((BitSet)cloneable).set(36);
        ((BitSet)cloneable).set(44);
        userinfoChar = new BitSet(128);
        userinfoChar.or((BitSet)cloneable2);
        userinfoChar.set(37);
        userinfoChar.set(59);
        userinfoChar.set(58);
        userinfoChar.set(38);
        userinfoChar.set(61);
        userinfoChar.set(43);
        userinfoChar.set(36);
        userinfoChar.set(44);
        schemeChar = new BitSet(128);
        schemeChar.or(bitSet7);
        schemeChar.set(43);
        schemeChar.set(45);
        schemeChar.set(46);
        opaqueChar = new BitSet(128);
        opaqueChar.or(bitSet6);
        hostChar = new BitSet(128);
        hostChar.or(bitSet7);
        hostChar.set(45);
        hostChar.set(46);
        reg_nameChar = new BitSet(128);
        reg_nameChar.or((BitSet)cloneable2);
        reg_nameChar.set(36);
        reg_nameChar.set(44);
        reg_nameChar.set(59);
        reg_nameChar.set(58);
        reg_nameChar.set(64);
        reg_nameChar.set(38);
        reg_nameChar.set(61);
        reg_nameChar.set(43);
        resvdSchemeChar = new BitSet(128);
        resvdSchemeChar.set(58);
        resvdUIChar = new BitSet(128);
        resvdUIChar.set(64);
        resvdHostChar = new BitSet(128);
        resvdHostChar.set(58);
        resvdHostChar.set(47);
        resvdHostChar.set(63);
        resvdHostChar.set(35);
        resvdPathChar = new BitSet(128);
        resvdPathChar.set(47);
        resvdPathChar.set(59);
        resvdPathChar.set(63);
        resvdPathChar.set(35);
        resvdQueryChar = new BitSet(128);
        resvdQueryChar.set(35);
        escpdPathChar = new BitSet(128);
        escpdPathChar.or((BitSet)cloneable);
        escpdPathChar.set(37);
        escpdPathChar.set(47);
        escpdPathChar.set(59);
        escpdQueryChar = new BitSet(128);
        escpdQueryChar.or(bitSet6);
        escpdQueryChar.clear(35);
        escpdFragChar = new BitSet(128);
        escpdFragChar.or(bitSet6);
        b = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void a(String string, String string2) throws ParseException {
        block10: {
            int n2;
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = cArray.length;
            for (n2 = 0; n2 < n4 && cArray[n2] != '@'; ++n2) {
            }
            if (n2 < n4 && cArray[n2] == '@') {
                ((URI)((Object)stringBuilder2)).userinfo = URI.escape(string.substring(0, n2), userinfoChar, true);
                n3 = n2 + 1;
            }
            if (n3 < n4 && cArray[n3] == '[') {
                for (n2 = n3; n2 < n4 && cArray[n2] != ']'; ++n2) {
                }
                if (n2 == n4) throw new ParseException("No closing ']' found for opening '[' at position " + n3 + " in authority `" + string + "'");
                ((URI)((Object)stringBuilder2)).host = string.substring(n3 + 1, n2);
                n2 = n3 = n2 + 1;
            } else {
                for (n2 = n3; n2 < n4 && cArray[n2] != ':'; ++n2) {
                }
                ((URI)((Object)stringBuilder2)).host = URI.escape(string.substring(n3, n2), uricChar, true);
            }
            if (n2 >= n4 - 1 || cArray[n2] != ':') return;
            int n5 = n2 + 1;
            try {
                n3 = Integer.parseInt(URI.unescape(string.substring(n5, n4), null));
                if (n3 < 0) break block10;
            }
            catch (NumberFormatException numberFormatException) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2();
                throw new ParseException(stringBuilder.append(string.substring(n5, n4)).append(" is an invalid port number").toString());
            }
            if (n3 == URI.defaultPort(string2)) {
                ((URI)((Object)stringBuilder2)).port = -1;
                return;
            }
            ((URI)((Object)stringBuilder2)).port = n3;
            return;
        }
        throw new NumberFormatException();
    }

    public final void a(StringBuffer stringBuffer, boolean bl, boolean bl2, boolean bl3) {
        String string;
        String string2 = ((URI)((Object)string3)).path;
        if ((string2 == null || string2.length() == 0) && bl) {
            stringBuffer.append('/');
        }
        if ((string = ((URI)((Object)string3)).path) != null) {
            if (bl3) {
                string = URI.a(string, resvdPathChar);
            }
            stringBuffer.append(string);
        }
        if (((URI)((Object)string3)).query != null) {
            stringBuffer.append('?');
            string = bl3 ? URI.a(((URI)((Object)string3)).query, resvdQueryChar) : ((URI)((Object)string3)).query;
            stringBuffer.append(string);
        }
        if (((URI)((Object)string3)).fragment != null) {
            stringBuffer.append('#');
            String string3 = bl3 ? URI.a(((URI)((Object)string3)).fragment, null) : ((URI)((Object)string3)).fragment;
            stringBuffer.append(string3);
        }
    }

    public final String a(boolean bl) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer(100);
        String string = this.scheme;
        if (string != null) {
            if (bl) {
                string = URI.a(string, resvdSchemeChar);
            }
            StringBuffer stringBuffer3 = stringBuffer2;
            stringBuffer3.append(string);
            stringBuffer3.append(':');
        }
        if ((string = this.opaque) != null) {
            if (bl) {
                string = URI.a(string, null);
            }
            StringBuffer stringBuffer4 = stringBuffer2;
            stringBuffer4.append(string);
            return stringBuffer4.toString();
        }
        if (this.userinfo != null || this.host != null || this.port != -1) {
            stringBuffer2.append("//");
        }
        if ((string = this.userinfo) != null) {
            if (bl) {
                string = URI.a(string, resvdUIChar);
            }
            StringBuffer stringBuffer5 = stringBuffer2;
            stringBuffer5.append(string);
            stringBuffer5.append('@');
        }
        if ((string = this.host) != null) {
            if (string.indexOf(58) < 0) {
                string = bl ? URI.a(this.host, resvdHostChar) : this.host;
                stringBuffer2.append(string);
            } else {
                stringBuffer2.append('[').append(this.host).append(']');
            }
        }
        if (this.port != -1) {
            stringBuffer2.append(':');
            stringBuffer2.append(this.port);
        }
        this.a(stringBuffer2, false, true, bl);
        return stringBuffer2.toString();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPathAndQuery() {
        if (this.query == null) {
            return this.path;
        }
        if (this.path == null) {
            return "?" + this.query;
        }
        return this.path + "?" + this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isGenericURI() {
        return this.type == 2;
    }

    public boolean isSemiGenericURI() {
        return this.type == 1;
    }

    public URL toURL() throws MalformedURLException {
        URL uRL;
        StringBuffer stringBuffer;
        Object object = ((URI)((Object)string)).url;
        if (object != null) {
            return object;
        }
        if (((URI)((Object)string)).opaque != null) {
            ((URI)((Object)string)).url = new URL(((URI)((Object)string)).scheme + ":" + ((URI)((Object)string)).opaque);
            return ((URI)((Object)string)).url;
        }
        object = ((URI)((Object)string)).userinfo;
        object = object != null && ((URI)((Object)string)).host != null ? ((URI)((Object)string)).userinfo + "@" + ((URI)((Object)string)).host : (object != null ? ((URI)((Object)string)).userinfo + "@" : ((URI)((Object)string)).host);
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer(100);
        ((URI)((Object)string)).a(stringBuffer2, true, true, false);
        URL uRL2 = uRL;
        URI uRI = string;
        URI uRI2 = string;
        String string = uRI2.scheme;
        int n2 = uRI2.port;
        String string2 = stringBuffer2.toString();
        uRL2(string, (String)object, n2, string2);
        uRI.url = uRL2;
        return uRL;
    }

    public String toExternalForm() {
        return this.a(false);
    }

    public String toString() {
        return this.a(true);
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            object = (URI)object;
            return this.scheme.equals(((URI)object).scheme) && (this.type == 0 && URI.b(this.opaque, ((URI)object).opaque) || this.type == 1 && URI.b(this.userinfo, ((URI)object).userinfo) && URI.c(this.host, ((URI)object).host) && this.port == ((URI)object).port && URI.b(this.path, ((URI)object).path) || this.type == 2 && URI.b(this.userinfo, ((URI)object).userinfo) && URI.c(this.host, ((URI)object).host) && this.port == ((URI)object).port && URI.d(this.path, ((URI)object).path) && URI.b(this.query, ((URI)object).query) && URI.b(this.fragment, ((URI)object).fragment));
        }
        if (object instanceof URL) {
            object = (URL)object;
            String string = this.userinfo != null ? this.userinfo + "@" + this.host : this.host;
            URI uRI = this;
            String string2 = uRI.getPathAndQuery();
            return uRI.scheme.equalsIgnoreCase(((URL)object).getProtocol()) && (this.type == 0 && this.opaque.equals(((URL)object).getFile()) || this.type == 1 && URI.c(string, ((URL)object).getHost()) && (this.port == ((URL)object).getPort() || ((URL)object).getPort() == URI.defaultPort(this.scheme)) && URI.b(string2, ((URL)object).getFile()) || this.type == 2 && URI.c(string, ((URL)object).getHost()) && (this.port == ((URL)object).getPort() || ((URL)object).getPort() == URI.defaultPort(this.scheme)) && URI.d(string2, ((URL)object).getFile()) && URI.b(this.fragment, ((URL)object).getRef()));
        }
        return false;
    }

    public int hashCode() {
        if (this.a == -1) {
            int n2;
            String string = this.scheme;
            int n3 = string != null ? URI.a(string, null).hashCode() : 0;
            if (this.type == 0) {
                String string2 = this.opaque;
                n2 = (string2 != null ? URI.a(string2, null).hashCode() : 0) * 7;
            } else {
                String string3 = this.host;
                n2 = (string3 != null ? URI.a(string3, null).toLowerCase().hashCode() : 0) * 7;
                String string4 = this.path;
                int n4 = (string4 != null ? URI.a(string4, null).hashCode() : 0) * 13;
                n2 += n4;
                String string5 = this.query;
                n2 += (string5 != null ? URI.a(string5, null).hashCode() : 0) * 17;
            }
            this.a = n3 + n2;
        }
        return this.a;
    }
}

