/*
 * Decompiled with CFR 0.152.
 */
package com.initech.xsafe.util;

import android.content.Context;
import android.content.UriPermission;
import android.net.Uri;
import android.os.Build;
import androidx.documentfile.provider.DocumentFile;
import com.initech.core.crypto.INIMessageDigest;
import com.initech.core.exception.INICoreException;
import com.initech.core.x509.X509CertImpl;
import com.initech.core.x509.x509CertificateInfo;
import com.initech.keystore.KeyStore;
import com.initech.pki.util.Hex;
import com.initech.xsafe.cert.CertInfo;
import com.initech.xsafe.cert.INIXSAFEException;
import com.initech.xsafe.cert.InnerExtensionFilter;
import com.initech.xsafe.util.StorageUtil;
import com.initech.xsafe.util.mlog.IniSafeLog;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class CertUtil {
    public static final int STORAGE_EXTERNAL = 1;
    public static final int STORAGE_INTERNAL = 2;
    public static final int STORAGE_EXTERNAL_INTERNAL = 3;
    public static final int STORAGE_ATON_WHITEBOX = 4;
    public static final int STORAGE_EXTERNAL_FIRST = 5;
    public static final FileFilter CERT_FILTER;
    public static final FileFilter KEY_FILTER;
    public static final String[] CA_LIST;
    public static final /* synthetic */ boolean a;

    /*
     * WARNING - void declaration
     */
    public static void addCertInfo(int idx, String certPath, ArrayList<CertInfo> certInfos, String[] oidList, String issuerDnFilter, boolean isEnglish) throws INIXSAFEException {
        void var5_6;
        void var4_5;
        void var3_4;
        void var2_3;
        int n2;
        File[] fileArray;
        File file;
        void var1_2;
        String string;
        X509Certificate x509Certificate;
        block8: {
            try {
                x509Certificate = x509CertificateInfo.loadCertificateFromFile(certPath);
                string = null;
                file = new File((String)var1_2).getParentFile();
                boolean bl = a;
                if (!bl && file == null) {
                    throw new AssertionError();
                }
                fileArray = file.listFiles(KEY_FILTER);
                if (bl || fileArray != null) break block8;
                throw new AssertionError();
            }
            catch (Exception exception) {
                IniSafeLog.error("\uc778\uc99d\uc11c\ub97c \uc77d\ub294\ub370 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4: " + (String)var1_2, exception);
                throw new INIXSAFEException("\uc778\uc99d\uc11c\ub97c \uc77d\ub294\ub370 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4: " + (String)var1_2, exception, "6302");
            }
        }
        if (com.initech.xsafe.cert.CertUtil.getGPKIClass(x509Certificate) != 0) {
            if (fileArray.length > 0) {
                for (File file2 : fileArray) {
                    String string2 = file2.getName();
                    String string3 = string2.substring(0, string2.lastIndexOf("."));
                    String string4 = new File((String)var1_2).getName();
                    String string5 = string4.substring(0, string4.lastIndexOf("."));
                    if (!file2.exists() || !string3.equalsIgnoreCase(string5)) continue;
                    string = file2.getAbsolutePath();
                }
            }
        } else {
            String string6 = new File((String)var1_2).getName().toLowerCase();
            for (File file3 : fileArray) {
                String string7 = file3.getName().toLowerCase();
                if ((!string7.startsWith("sign") || !string6.startsWith("sign")) && (!string7.startsWith("km") || !string6.startsWith("km"))) continue;
                string = file3.getAbsolutePath();
            }
        }
        int n3 = n2;
        n2 = var1_2.contains(StorageUtil.getExternalBasePath()) ^ 1;
        CertUtil.addCertInfo(n3, file.getAbsolutePath(), (String)var1_2, string, x509Certificate, n2, (ArrayList<CertInfo>)var2_3, (String[])var3_4, (String)var4_5, (boolean)var5_6);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static void addCertInfo(int idx, String path, String certPath, String priPath, X509Certificate cert, int storage, ArrayList<CertInfo> certInfos, String[] oidList, String issuerDnFilter, boolean isEnglish) throws INIXSAFEException {
        CertInfo certInfo;
        void var5_5;
        void var3_3;
        void var2_2;
        void var1_1;
        int n2;
        void var6_6;
        SimpleDateFormat simpleDateFormat;
        void var9_9;
        String string;
        String string2;
        CertInfo certInfo2;
        void v02 = certInfo2;
        String string3 = CertUtil.getCertId((X509Certificate)v02);
        String string4 = CertUtil.getCNfromSubjectDN((X509Certificate)v02);
        String string5 = v02.getSubjectDN().toString();
        String string6 = v02.getIssuerDN().toString();
        if (issuerDnFilter != null && string2.equalsIgnoreCase("CN")) {
            string2 = CertUtil.getValueFromDN("CN=", string6);
        } else {
            try {
                string2 = CertUtil.getValueFromDN("O=", string6);
            }
            catch (Exception exception) {
                string2 = string6;
            }
        }
        void v2 = certInfo2;
        void v3 = string;
        void v4 = certInfo2;
        string = v4.getSerialNumber().toString();
        String string7 = v4.getSerialNumber().toString(16);
        String string8 = CertUtil.getCertType((X509Certificate)v2, (String[])v3, (boolean)var9_9);
        boolean bl = CertUtil.CertValidateCheck((X509Certificate)v2) ^ true;
        Object object = simpleDateFormat;
        ((SimpleDateFormat)object)("yyyy-MM-dd", Locale.getDefault());
        object = ((DateFormat)object).format(((X509Certificate)((Object)certInfo2)).getNotAfter());
        String string9 = simpleDateFormat.format(((X509Certificate)((Object)certInfo2)).getNotBefore());
        String string10 = x509CertificateInfo.getCertOID((X509Certificate)v2);
        if (var6_6 != null) {
            for (CertInfo certInfo3 : var6_6) {
                if (!string3.equals(certInfo3.certId)) continue;
                if (((X509Certificate)((Object)certInfo2)).getSerialNumber().compareTo(new BigInteger(certInfo3.serialNumber)) > 0) {
                    certInfo3.set(n2, string3, string4, string2, string8, bl, (String)object, string9, string, string7, (String)var1_1, (String)var2_2, (String)var3_3, string10, string5, string6, (int)var5_5);
                }
                return;
            }
        }
        certInfo2 = certInfo;
        certInfo = new CertInfo(n2, string3, string4, string2, string8, bl, (String)object, string9, string, string7, (String)var1_1, (String)var2_2, (String)var3_3, string10, string5, string6, (int)var5_5);
        var6_6.add(certInfo2);
    }

    public static String getCertId(X509Certificate cert) throws INIXSAFEException {
        String string;
        string = ((X509Certificate)((Object)string)).getIssuerDN().getName() + "_" + ((X509Certificate)((Object)string)).getSubjectDN().getName();
        try {
            return Hex.dumpHex(new INIMessageDigest().doDigest(string, "SHA256"));
        }
        catch (Exception exception) {
            throw new INIXSAFEException("\uc778\uc99d\uc11c ID \ucde8\ub4dd\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", exception, "4001");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getCertType(X509Certificate cert, String[] oidList, boolean isEnglish) {
        void var2_2;
        String string = x509CertificateInfo.getCertOID(cert);
        if (string != null && string.length() > 0) {
            void var1_1;
            for (String string2 : var1_1) {
                String string3;
                int n2 = string2.indexOf("[");
                String string4 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1, string2.length() - 1);
                String string5 = string3;
                try {
                    string3 = new String(string2.getBytes("8859_1"), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    IniSafeLog.error(unsupportedEncodingException.toString(), unsupportedEncodingException);
                    string5 = string2;
                }
                if (!string4.equals(string)) continue;
                return string5;
            }
            return var2_2 != false ? "Common Certificate" : "\uc77c\ubc18 \uc778\uc99d\uc11c";
        }
        return var2_2 != false ? "Private Certificate" : "\uc0ac\uc124 \uc778\uc99d\uc11c";
    }

    public static boolean CertValidateCheck(X509Certificate cert) {
        boolean bl;
        try {
            cert.checkValidity();
            bl = true;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            IniSafeLog.error(certificateNotYetValidException.toString());
            bl = false;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            IniSafeLog.error(certificateExpiredException.toString());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static String getValueFromDN(String delim, String dn) {
        void var1_2;
        String string;
        String string2 = dn;
        int n2 = string2.indexOf(string);
        int n3 = var1_2.indexOf(44, n2);
        return string2.substring(n2 + string.length(), n3);
    }

    public static boolean isKROID(X509Certificate cert) {
        String[] stringArray;
        String string;
        block5: {
            stringArray = new X509CertImpl(((Certificate)((Object)string)).getEncoded()).getPolicy();
            if (stringArray != null) break block5;
            try {
                IniSafeLog.debug("private certificate: policy is null");
                return false;
            }
            catch (Exception exception) {
                IniSafeLog.debug("private certificate" + exception);
                return false;
            }
        }
        if (!stringArray.contains("1.2.410.2")) {
            IniSafeLog.debug("private certificate: policy oid does not contain \"1.2.410.2\"");
            return false;
        }
        string = ((X509Certificate)((Object)string)).getSubjectDN().toString().toLowerCase();
        stringArray = CA_LIST;
        int n2 = CA_LIST.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.contains(stringArray[i2].toLowerCase())) continue;
            IniSafeLog.debug("public certificate: certificate is issued by public ca");
            return true;
        }
        IniSafeLog.debug("private certificate: certificate is not issued by public ca: " + (String)string);
        return false;
    }

    public static boolean isSignCert(X509Certificate cert) {
        int n2;
        Object object;
        try {
            object = new X509CertImpl(((Certificate)object).getEncoded()).getKeyUsage();
            n2 = 0;
        }
        catch (Exception exception) {
            return true;
        }
        while (true) {
            block8: {
                block7: {
                    if (n2 >= ((Object)object).length) break;
                    if (n2 >= 2) break block7;
                    if (object[n2] != false) {
                        break;
                    }
                    break block8;
                }
                if (n2 >= 4) break;
                if (object[n2] == false) break block8;
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int getGPKIClass(X509Certificate cert) {
        block9: {
            String string;
            block11: {
                block10: {
                    string = new X509CertImpl(((Certificate)((Object)string)).getEncoded()).getPolicy();
                    if (string == null) break block9;
                    if (!string.contains("1.2.410.100001.2.1.")) break block10;
                    IniSafeLog.debug("GPKI class 1");
                    return 1;
                }
                if (!string.contains("1.2.410.100001.2.2.")) break block11;
                IniSafeLog.debug("GPKI class 2");
                return 2;
            }
            if (!string.contains("1.2.410.100001.5.")) break block9;
            IniSafeLog.debug("GPKI class 2");
            return 2;
        }
        try {
            IniSafeLog.debug("not GPKI certificate");
        }
        catch (Exception exception) {
            IniSafeLog.debug("not GPKI certificate: Fail to load certificate : " + exception);
        }
        return 0;
    }

    public static boolean isGPKICert(X509Certificate cert) {
        return CertUtil.getGPKIClass(cert) != 0;
    }

    public static String getHashAlgorithm(X509Certificate cert) {
        Object object = "SHA-256";
        String string = cert.getSigAlgName();
        if (string.contains("SHA1")) {
            object = "SHA1";
        } else if (!string.contains("SHA-256") && !string.contains("SHA256")) {
            if (!string.contains("SHA-384") && !string.contains("SHA384")) {
                if (!string.contains("SHA-512") && !string.contains("SHA512")) {
                    if (string.contains("MD5")) {
                        object = "MD5";
                    }
                } else {
                    object = "SHA-512";
                }
            } else {
                object = "SHA-384";
            }
        } else {
            object = "SHA-256";
        }
        return object;
    }

    public static String getCNfromSubjectDN(X509Certificate cert) {
        Object object = cert.getSubjectDN().toString();
        IniSafeLog.debug("Full DN: " + (String)object);
        int n2 = ((String)object).indexOf("CN=");
        if (n2 != -1) {
            int n3 = ((String)object).indexOf(",", n2);
            object = ((String)object).substring(n2 + 3, n3);
        } else {
            n2 = ((String)object).indexOf("cn=");
            if (n2 != -1) {
                int n4 = ((String)object).indexOf(",", n2);
                object = ((String)object).substring(n2 + 3, n4);
            } else {
                n2 = ((String)object).indexOf("OU=");
                if (n2 != -1) {
                    int n5 = ((String)object).indexOf(",", n2);
                    object = ((String)object).substring(n2 + 3, n5);
                } else {
                    n2 = ((String)object).indexOf("ou=");
                    if (n2 != -1) {
                        int n6 = ((String)object).indexOf(",", n2);
                        object = ((String)object).substring(n2 + 3, n6);
                    }
                }
            }
        }
        return object;
    }

    public static String getCertStoragePath(X509Certificate cert) {
        X509Certificate x509Certificate;
        if (CertUtil.isKROID(cert)) {
            return "NPKI/" + CertUtil.getValueFromDN("O=", x509Certificate.getIssuerDN().getName()) + "/USER/" + x509Certificate.getSubjectDN().getName();
        }
        if (CertUtil.isGPKICert(x509Certificate)) {
            return "GPKI/certificate/class" + CertUtil.getGPKIClass(x509Certificate);
        }
        return "PPKI/Initech/INITECH CA/USER/" + x509Certificate.getSubjectDN().getName();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getEncryptedPrivateKey(Context context, String priPath, byte[] priKey, boolean useTwoFactorEncryption) throws Exception {
        void var2_2;
        Context context2;
        void var3_3;
        void var1_1;
        return StorageUtil.isInternalPath(context, (String)var1_1) && var3_3 != false ? KeyStore.encrypt((Context)context2, (byte[])var2_2) : (byte[])var2_2.clone();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getDecryptedPrivateKey(Context context, byte[] priKey) throws Exception {
        void var1_1;
        Context context2;
        return KeyStore.isEncrypted((byte[])priKey) ? KeyStore.decrypt((Context)context2, (byte[])var1_1) : (byte[])var1_1.clone();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] filePathToByteArray(String filePath) throws INICoreException, FileNotFoundException {
        FileInputStream fileInputStream;
        Object object;
        Object object2;
        block28: {
            block29: {
                block27: {
                    byte[] byArray;
                    Object object3;
                    Object object4;
                    FileInputStream fileInputStream2;
                    DataInputStream dataInputStream;
                    FileInputStream fileInputStream3;
                    object2 = null;
                    FileInputStream fileInputStream4 = null;
                    if (filePath == null) throw new NullPointerException("\ud30c\uc77c \uacbd\ub85c\uac00 null \uc785\ub2c8\ub2e4.");
                    try {
                        if (!new File((String)object).exists()) break block27;
                    }
                    catch (Throwable throwable) {
                        FileInputStream fileInputStream5 = object2;
                        object2 = fileInputStream4;
                        fileInputStream = fileInputStream5;
                        break block28;
                    }
                    catch (IOException iOException) {
                        FileInputStream fileInputStream6 = object2;
                        object2 = fileInputStream4;
                        fileInputStream = fileInputStream6;
                        break block29;
                    }
                    catch (NullPointerException nullPointerException) {
                        FileInputStream fileInputStream7 = object2;
                        object2 = fileInputStream4;
                        fileInputStream = fileInputStream7;
                        throw new NullPointerException(((NullPointerException)object).getMessage());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        FileInputStream fileInputStream8 = object2;
                        object2 = fileInputStream4;
                        fileInputStream = fileInputStream8;
                        throw new FileNotFoundException(((Throwable)object).getMessage());
                    }
                    fileInputStream = fileInputStream3;
                    {
                        fileInputStream3 = new FileInputStream((String)object);
                    }
                    object = dataInputStream;
                    try {
                        fileInputStream2 = fileInputStream;
                        Object object5 = object;
                        object4 = object5;
                        object3 = object5;
                        ((DataInputStream)object5)(fileInputStream);
                    }
                    catch (Throwable throwable) {
                        object2 = fileInputStream4;
                        object = throwable;
                        break block28;
                    }
                    catch (IOException iOException) {
                        object2 = fileInputStream4;
                        object = iOException;
                        break block29;
                    }
                    catch (NullPointerException nullPointerException) {
                        FileInputStream fileInputStream9 = fileInputStream4;
                        object = nullPointerException;
                        throw new NullPointerException(((NullPointerException)object).getMessage());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        FileInputStream fileInputStream10 = fileInputStream4;
                        object = fileNotFoundException;
                        throw new FileNotFoundException(((Throwable)object).getMessage());
                    }
                    try {
                        byArray = new byte[((FilterInputStream)object3).available()];
                    }
                    catch (Throwable throwable) {
                        object2 = object;
                        object = throwable;
                        break block28;
                    }
                    catch (IOException iOException) {
                        object2 = object;
                        object = iOException;
                        break block29;
                    }
                    catch (NullPointerException nullPointerException) {
                        Object object6 = object;
                        object = nullPointerException;
                        throw new NullPointerException(((NullPointerException)object).getMessage());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Object object7 = object;
                        object = fileNotFoundException;
                        throw new FileNotFoundException(((Throwable)object).getMessage());
                    }
                    object2 = byArray;
                    {
                        ((DataInputStream)object4).readFully(byArray);
                    }
                    try {
                        fileInputStream2.close();
                        dataInputStream.close();
                        return object2;
                    }
                    catch (IOException iOException) {}
                    return object2;
                }
                throw new FileNotFoundException((String)object);
            }
            try {
                throw new INICoreException("IOException : " + object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw object;
            }
        }
        if (object2 == null) throw object;
        {
            ((FilterInputStream)object2).close();
        }
        throw object;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] concat(char[] first, char[] ... rest) {
        void var1_1;
        char[] cArray;
        int n2 = cArray.length;
        int n3 = rest.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += ((void)var1_1[i2]).length;
        }
        cArray = Arrays.copyOf(cArray, n2);
        n2 = cArray.length;
        for (void v02 : var1_1) {
            int n4 = ((void)v02).length;
            System.arraycopy(v02, 0, cArray, n2, n4);
            n2 += ((void)v02).length;
        }
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<byte[][]> getCertPriListFromNpkiDir(Context context, DocumentFile file) {
        void var1_1;
        return CertUtil.b(context, var1_1.listFiles());
    }

    public static ArrayList<byte[][]> b(Context context, DocumentFile[] documentFileArray) {
        ArrayList<byte[][]> arrayList;
        ArrayList<byte[][]> arrayList2 = arrayList;
        arrayList = new ArrayList<byte[][]>();
        for (DocumentFile documentFile : documentFileArray) {
            if (!documentFile.isDirectory()) continue;
            arrayList2.addAll(CertUtil.d(context, documentFile.listFiles()));
        }
        return arrayList2;
    }

    public static ArrayList<byte[][]> d(Context context, DocumentFile[] documentFileArray) {
        ArrayList<byte[][]> arrayList;
        ArrayList<byte[][]> arrayList2 = arrayList;
        arrayList = new ArrayList<byte[][]>();
        for (DocumentFile documentFile : documentFileArray) {
            if (!documentFile.isDirectory() || !documentFile.getUri().toString().toUpperCase().contains("USER")) continue;
            arrayList2.addAll(CertUtil.c(context, documentFile.listFiles()));
        }
        return arrayList2;
    }

    public static ArrayList<byte[][]> c(Context context, DocumentFile[] documentFileArray) {
        ArrayList<byte[][]> arrayList;
        ArrayList<byte[][]> arrayList2 = arrayList;
        arrayList = new ArrayList<byte[][]>();
        for (DocumentFile documentFile : documentFileArray) {
            byte[][] byArray;
            if (!documentFile.isDirectory() || (byArray = CertUtil.a(context, documentFile.listFiles()))[0] == null || byArray[1] == null) continue;
            arrayList2.add(CertUtil.a(context, documentFile.listFiles()));
        }
        return arrayList2;
    }

    public static byte[][] a(Context context, DocumentFile[] documentFileArray) {
        byte[][] byArrayArray = new byte[4][];
        for (DocumentFile documentFile : documentFileArray) {
            if (documentFile.getUri().toString().toLowerCase().contains("signcert.der")) {
                byArrayArray[0] = CertUtil.a(context, documentFile);
                continue;
            }
            if (documentFile.getUri().toString().toLowerCase().contains("signpri.key")) {
                byArrayArray[1] = CertUtil.a(context, documentFile);
                continue;
            }
            if (documentFile.getUri().toString().toLowerCase().contains("kmcert.der")) {
                byArrayArray[2] = CertUtil.a(context, documentFile);
                continue;
            }
            if (!documentFile.getUri().toString().toLowerCase().contains("kmpri.key")) continue;
            byArrayArray[3] = CertUtil.a(context, documentFile);
        }
        return byArrayArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] a(Context object, DocumentFile object2) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        Object object3 = object;
        object = null;
        object2 = object3.getContentResolver().openInputStream(object2.getUri());
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byArray = new byte[1024];
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        while (true) {
            int n2 = ((InputStream)object2).read(byArray);
            if (n2 == -1) return byteArrayOutputStream2.toByteArray();
            byteArrayOutputStream2.write(byArray, 0, n2);
            continue;
            break;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isReadPermissionGranted(Context context, Uri uri) {
        Object object;
        if (Build.VERSION.SDK_INT < 19) {
            return true;
        }
        for (UriPermission uriPermission : object.getContentResolver().getPersistedUriPermissions()) {
            void var1_1;
            if (!var1_1.toString().startsWith(uriPermission.getUri().toString()) || !uriPermission.isReadPermission()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWritePermissionGranted(Context context, Uri uri) {
        Object object;
        if (Build.VERSION.SDK_INT < 19) {
            return true;
        }
        for (UriPermission uriPermission : object.getContentResolver().getPersistedUriPermissions()) {
            void var1_1;
            if (!var1_1.toString().startsWith(uriPermission.getUri().toString()) || !uriPermission.isWritePermission()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentFile getCreatedDirectory(DocumentFile file, String dirName) {
        DocumentFile documentFile;
        void var1_1;
        if (CertUtil.hasDirectory(file, (String)var1_1)) {
            return CertUtil.getDirectory(documentFile, (String)var1_1);
        }
        return documentFile.createDirectory((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentFile getCreatedFile(DocumentFile file, String fileName) {
        DocumentFile documentFile;
        void var1_1;
        if (CertUtil.hasFile(file, (String)var1_1)) {
            return CertUtil.getFile(documentFile, (String)var1_1);
        }
        return documentFile.createFile("application/octet-stream", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasDirectory(DocumentFile file, String dirName) {
        for (DocumentFile documentFile : file.listFiles()) {
            void var1_1;
            if (!Objects.requireNonNull(documentFile.getName()).equalsIgnoreCase((String)var1_1) || !documentFile.isDirectory()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasFile(DocumentFile file, String fileName) {
        for (DocumentFile documentFile : file.listFiles()) {
            void var1_1;
            if (!Objects.requireNonNull(documentFile.getName()).equalsIgnoreCase((String)var1_1) || !documentFile.isFile()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentFile getDirectory(DocumentFile file, String dirName) {
        for (DocumentFile documentFile : file.listFiles()) {
            void var1_1;
            if (!Objects.requireNonNull(documentFile.getName()).equalsIgnoreCase((String)var1_1) || !documentFile.isDirectory()) continue;
            return documentFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentFile getFile(DocumentFile file, String fileName) {
        for (DocumentFile documentFile : file.listFiles()) {
            void var1_1;
            if (!Objects.requireNonNull(documentFile.getName()).equalsIgnoreCase((String)var1_1) || !documentFile.isFile()) continue;
            return documentFile;
        }
        return null;
    }

    static {
        a = CertUtil.class.desiredAssertionStatus() ^ true;
        CERT_FILTER = new InnerExtensionFilter(new String[]{"cer", "der", "cert", "0"});
        KEY_FILTER = new InnerExtensionFilter(new String[]{"key", "priv"});
        CA_LIST = new String[]{"CrossCert", "KICA", "KISA", "NCASign", "SignKorea", "TradeSign", "yessign", "INIPASS"};
    }
}

