/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.crypto;

import com.initech.asn1.ASN1Exception;
import com.initech.core.INISAFECore;
import com.initech.core.crypto.CryptoVerification;
import com.initech.core.util.LogUtil;
import com.initech.pki.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.kcdsa.KCDSAPublicKeyImpl;
import com.initech.provider.crypto.kcdsa.KCDSASignedData;
import com.initech.provider.crypto.kcdsa.SHA1withKCDSA;
import com.initech.provider.crypto.rsa.RSAAutoSignature;
import com.initech.provider.crypto.rsa.RSAPKCS1v15Signature;
import com.initech.provider.crypto.rsa.RSAPSSSignature;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class INISignature
extends CryptoVerification {
    public byte[] RSAPKCS1v15Sign(PrivateKey privateKey, byte[] byArray) throws Exception {
        return this.RSAPKCS1v15Sign(privateKey, "SHA1", byArray);
    }

    public byte[] RSAPKCS1v15Sign(PrivateKey privateKey, String string, byte[] byArray) throws Exception {
        RSAPKCS1v15Signature rSAPKCS1v15Signature;
        INISignature iNISignature = rSAPKCS1v15Signature;
        try {
            iNISignature(string);
            ((Signature)((Object)iNISignature)).initSign(privateKey);
            rSAPKCS1v15Signature.update(byArray);
            return rSAPKCS1v15Signature.sign();
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "RSAPKCSv1.5 \uc11c\uba85 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. privatekey=[" + Hex.dumpHex(privateKey.getEncoded()) + "],alg=[" + string + "], msg=[" + Hex.dumpHex(byArray) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such Algorithm: " + string);
        }
    }

    public byte[] RSAPSSSign(PrivateKey privateKey, String string, byte[] byArray) throws Exception {
        RSAPSSSignature rSAPSSSignature;
        MessageDigest.getInstance(string);
        INISignature iNISignature = rSAPSSSignature;
        try {
            iNISignature(string);
            ((Signature)((Object)iNISignature)).initSign(privateKey);
            rSAPSSSignature.update(byArray);
            return rSAPSSSignature.sign();
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "RSAPSS\uc11c\uba85 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.privatekey=[" + Hex.dumpHex(privateKey.getEncoded()) + "], msg=[" + Hex.dumpHex(byArray) + "], alg=sha1");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such Algorithm");
        }
    }

    public byte[] KCDSASign(PrivateKey privateKey, byte[] byArray) throws Exception {
        INISignature iNISignature = string;
        String string = InitechProvider.NAME;
        return iNISignature.doSign(privateKey, byArray, "HAS160withKCDSA", string);
    }

    public byte[] doSign(PrivateKey privateKey, byte[] byArray, String string) throws Exception {
        INISignature iNISignature = string2;
        String string2 = InitechProvider.NAME;
        return iNISignature.doSign(privateKey, byArray, string, string2);
    }

    public byte[] doSign(PrivateKey privateKey, byte[] byArray, String string, String string2) throws Exception {
        Signature signature = Signature.getInstance(string, string2);
        try {
            signature.initSign(privateKey);
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "\uc804\uc790\uc11c\uba85 \uc218\ud589 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. privateKey=[" + Hex.dumpHex(privateKey.getEncoded()) + "], msg=[" + Hex.dumpHex(byArray) + "], alg=[" + string + "], provider=[" + string2 + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception(exception);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            INISAFECore.CoreLogger(1, "provider\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. (provider: " + string2 + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchProviderException);
            throw new NoSuchProviderException("No such Provider: " + string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such Algorithm: " + string);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] doSign(PrivateKey privateKey, String string, byte[] byArray, String string2) throws Exception {
        Signature signature;
        Object object = null;
        try {
            Object object2;
            byte[] byArray2;
            if (string.equalsIgnoreCase("kcdsa1")) {
                if (string2.equalsIgnoreCase("HAS160")) {
                    byArray2 = ((INISignature)object2).doSign(privateKey, byArray, "HAS160withKCDSA");
                    object2 = byArray2;
                    return object2;
                } else {
                    if (!string2.equalsIgnoreCase("SHA256")) return object;
                    byArray2 = ((INISignature)object2).doSign(privateKey, byArray, "SHA256withKCDSA");
                }
                object2 = byArray2;
                return object2;
            }
            if (string.equalsIgnoreCase("RSA15")) {
                byArray2 = ((INISignature)object2).RSAPKCS1v15Sign(privateKey, string2, byArray);
                while (true) {
                    object2 = byArray2;
                    return object2;
                }
            }
            if (string.equalsIgnoreCase("PSS")) {
                byArray2 = ((INISignature)object2).RSAPSSSign(privateKey, string2, byArray);
                object2 = byArray2;
                return object2;
            }
            signature = Signature.getInstance(string, "Initech");
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "\uc804\uc790\uc11c\uba85 \uc218\ud589 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. privateKey=[" + Hex.dumpHex(privateKey.getEncoded()) + "], msg=[" + Hex.dumpHex(byArray) + "], alg=[" + string + "], hashalg=[" + string2 + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception(exception);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such Algorithm: " + string);
        }
        {
            signature.initSign(privateKey);
            signature.update(byArray);
            return signature.sign();
        }
    }

    public boolean RSAPKCS1v15SignVerify(PublicKey publicKey, byte[] byArray, byte[] byArray2) throws Exception {
        return this.RSAPKCS1v15SignVerify(publicKey, byArray, "SHA1", byArray2);
    }

    public boolean RSAPKCS1v15SignVerify(PublicKey publicKey, byte[] byArray, String string, byte[] byArray2) throws Exception {
        RSAPKCS1v15Signature rSAPKCS1v15Signature;
        INISignature iNISignature = rSAPKCS1v15Signature;
        try {
            iNISignature(string);
            ((Signature)((Object)iNISignature)).initVerify(publicKey);
            ((Signature)((Object)iNISignature)).update(byArray);
            return rSAPKCS1v15Signature.verify(byArray2);
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "RSAPKCSv1.5 \uc11c\uba85 \uac80\uc99d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. publickey=[" + Hex.dumpHex(publicKey.getEncoded()) + "], msg=[" + Hex.dumpHex(byArray) + "], alg=[" + string + "], signature=[" + Hex.dumpHex(byArray2) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such Algorithm: " + string);
        }
    }

    public boolean RSAPSSSignVerify(PublicKey publicKey, byte[] byArray, byte[] byArray2) throws Exception {
        return this.RSAPSSSignVerify(publicKey, byArray, "SHA1", byArray2);
    }

    public boolean RSAPSSSignVerify(PublicKey publicKey, byte[] byArray, String string, byte[] byArray2) throws Exception {
        RSAPSSSignature rSAPSSSignature;
        MessageDigest.getInstance(string);
        INISignature iNISignature = rSAPSSSignature;
        try {
            iNISignature(string);
            ((Signature)((Object)iNISignature)).initVerify(publicKey);
            ((Signature)((Object)iNISignature)).update(byArray);
            return rSAPSSSignature.verify(byArray2);
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "RSAPSS \uc11c\uba85 \uac80\uc99d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. publickey=[" + Hex.dumpHex(publicKey.getEncoded()) + "], msg=[" + Hex.dumpHex(byArray) + "],alg=[" + string + "], signature=[" + Hex.dumpHex(byArray2) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such Algorithm: " + string);
        }
    }

    public boolean KCDSASignVerify(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, byte[] byArray2) {
        SHA1withKCDSA sHA1withKCDSA;
        KCDSAPublicKeyImpl kCDSAPublicKeyImpl;
        boolean bl = false;
        KCDSAPublicKeyImpl kCDSAPublicKeyImpl2 = kCDSAPublicKeyImpl;
        kCDSAPublicKeyImpl = new KCDSAPublicKeyImpl(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        bigInteger = sHA1withKCDSA;
        try {
            bigInteger();
            bigInteger.initVerify((PublicKey)kCDSAPublicKeyImpl2);
            bigInteger.update(byArray);
            bl = sHA1withKCDSA.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        return bl;
    }

    public boolean KCDSASignVerify(PublicKey publicKey, byte[] byArray, byte[] byArray2) throws Exception {
        return this.doVerify(publicKey, byArray, "HAS160withKCDSA", byArray2);
    }

    public boolean doVerify(PublicKey publicKey, byte[] byArray, String string, byte[] byArray2) throws Exception {
        INISignature iNISignature = string2;
        String string2 = InitechProvider.NAME;
        return iNISignature.doVerify(publicKey, byArray, string, string2, byArray2);
    }

    public boolean doVerify(PublicKey publicKey, byte[] byArray, String string, String string2, byte[] byArray2) throws Exception {
        Signature signature = Signature.getInstance(string, string2);
        try {
            signature.initVerify(publicKey);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "\uc804\uc790\uc11c\uba85 \uac80\uc99d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. publickey=[" + Hex.dumpHex(publicKey.getEncoded()) + "], msg=[" + Hex.dumpHex(byArray) + "], alg=[" + string + "], provider=[" + string2 + "], signature=[" + Hex.dumpHex(byArray2) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such Algorithm: " + string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean doVerify(PublicKey publicKey, byte[] byArray, byte[] byArray2, String string) {
        boolean bl;
        void var3_6;
        void var2_5;
        void var1_4;
        String bl2;
        block4: {
            int bl22 = bl2.indexOf("with");
            if (bl22 < 0) break block4;
            bl2 = bl2.substring(0, bl22);
        }
        try {
            boolean exception;
            bl = exception = new RSAAutoSignature((PublicKey)var1_4, (byte[])var2_5, (byte[])var3_6, bl2).verify();
        }
        catch (Exception exception) {
            bl = false;
            INISAFECore.CoreLogger(1, "\uc804\uc790\uc11c\uba85 \uac80\uc99d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. publickey=[" + Hex.dumpHex(var1_4.getEncoded()) + "], msg=[" + Hex.dumpHex((byte[])var2_5) + "], signature=[" + Hex.dumpHex((byte[])var3_6) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
        }
        return bl;
    }

    public boolean doVerify(PublicKey publicKey, String string, byte[] byArray, String string2, byte[] byArray2) throws Exception {
        INISignature iNISignature = string3;
        String string3 = InitechProvider.NAME;
        return iNISignature.doVerify(publicKey, string, byArray, string2, string3, byArray2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doVerify(PublicKey publicKey, String string, byte[] byArray, String string2, String string3, byte[] byArray2) throws Exception {
        boolean bl;
        try {
            if (string2.equalsIgnoreCase("RSA15")) {
                bl = ((INISignature)((Object)signature)).RSAPKCS1v15SignVerify(publicKey, byArray, string, byArray2);
                return bl;
            }
            if (string2.equalsIgnoreCase("PSS")) {
                bl = ((INISignature)((Object)signature)).RSAPSSSignVerify(publicKey, byArray, string, byArray2);
                return bl;
            }
            Signature signature = Signature.getInstance(string2, string3);
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "\uc804\uc790\uc11c\uba85 \uac80\uc99d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. publickey=[" + Hex.dumpHex(publicKey.getEncoded()) + "], msg=[" + Hex.dumpHex(byArray) + "], alg=[" + string2 + "], provider=[" + string3 + "], signature=[" + Hex.dumpHex(byArray2) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string2 + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such Algorithm: " + string2);
        }
        signature.initVerify(publicKey);
        signature.update(byArray);
        bl = signature.verify(byArray2);
        return bl;
    }

    public byte[] getR(byte[] byArray) throws Exception {
        try {
            return new KCDSASignedData(byArray).getR();
        }
        catch (ASN1Exception aSN1Exception) {
            INISAFECore.CoreLogger(1, "\uc798\ubabb\ub41c KCDSA \uc11c\uba85 \ub370\uc774\ud130 \uc785\ub2c8\ub2e4. signature=[" + Hex.dumpHex(byArray) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, (Exception)((Object)aSN1Exception));
            throw new Exception();
        }
    }

    public byte[] getS(byte[] byArray) throws Exception {
        try {
            return new KCDSASignedData(byArray).getS().toByteArray();
        }
        catch (ASN1Exception aSN1Exception) {
            INISAFECore.CoreLogger(1, "\uc798\ubabb\ub41c KCDSA \uc11c\uba85 \ub370\uc774\ud130 \uc785\ub2c8\ub2e4. signature=[" + Hex.dumpHex(byArray) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, (Exception)((Object)aSN1Exception));
            throw new Exception();
        }
    }
}

