/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.ocsp;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.Extensions;
import com.initech.core.crypto.INISignature;
import com.initech.core.ocsp.CertID;
import com.initech.core.ocsp.OCSPException;
import com.initech.core.ocsp.OCSPResponseType;
import com.initech.core.ocsp.ResponderID;
import com.initech.core.ocsp.SingleResponse;
import com.initech.x509.Certificates;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class BasicResponse
extends ASN1Object
implements OCSPResponseType {
    public static final ASN1OID i = new ASN1OID("1.3.6.1.5.5.7.48.1.1");
    public int a = 1;
    public ResponderID b;
    public Date c;
    public Vector d;
    public Extensions e;
    public byte[] encodedTBSRep;
    public boolean tbsModified;
    public AlgorithmID f;
    public ASN1BitString g;
    public Certificates h;

    public BasicResponse() {
        Certificates certificates;
        AlgorithmID algorithmID;
        Extensions extensions;
        Vector vector;
        ResponderID responderID;
        Object object = responderID;
        responderID = new ResponderID();
        v1.b = object;
        object = vector;
        vector = new Vector(4);
        v1.d = object;
        object = extensions;
        extensions = new Extensions();
        v1.e = object;
        object = algorithmID;
        algorithmID = new AlgorithmID();
        v1.f = object;
        object = certificates;
        certificates = new Certificates();
        v1.h = object;
    }

    @Override
    public ASN1OID getType() {
        return i;
    }

    @Override
    public void set(ASN1OID aSN1OID, byte[] byArray) throws ASN1Exception {
        DERDecoder dERDecoder;
        BasicResponse basicResponse = basicResponse2;
        BasicResponse basicResponse2 = dERDecoder;
        dERDecoder = new DERDecoder(byArray);
        basicResponse.decode((ASN1Decoder)basicResponse2);
        basicResponse.tbsModified = true;
        basicResponse.modified = true;
    }

    public byte[] getTBSResponse() throws ASN1Exception {
        int n2;
        DEREncoder dEREncoder;
        Object object;
        if (!this.tbsModified) {
            object = this.encodedTBSRep;
            if (this.encodedTBSRep != null) {
                return object;
            }
        }
        object = dEREncoder;
        dEREncoder = new DEREncoder();
        int n3 = dEREncoder.encodeSequence();
        if (this.a > 1) {
            n2 = object.encodeExplicit(ASN1Tag.makeContextTag((int)0));
            object.encodeInteger(this.a - 1);
            object.endOf(n2);
        }
        object.encodeAny(this.b.getEncoded());
        if (this.c == null) {
            Date date;
            Date date2 = date;
            date = new Date();
            this.c = date2;
        }
        object.encodeGeneralizedTime(this.c);
        n2 = object.encodeSequenceOf();
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            ((SingleResponse)((Object)this.d.elementAt(i2))).encode((ASN1Encoder)object);
        }
        object.endOf(n2);
        if (this.e.size() > 0) {
            int n4 = object.encodeExplicit(ASN1Tag.makeContextTag((int)1));
            this.e.encode((ASN1Encoder)object);
            object.endOf(n4);
        }
        object.endOf(n3);
        this.encodedTBSRep = object.toByteArray();
        object.finish();
        this.tbsModified = false;
        return this.encodedTBSRep;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        BasicResponse basicResponse = this;
        int n2 = aSN1Encoder.encodeSequence();
        aSN1Encoder.encodeAny(this.getTBSResponse());
        basicResponse.f.encode(aSN1Encoder);
        aSN1Encoder.encodeBitString(basicResponse.g);
        if (this.h.size() > 0) {
            ASN1Encoder aSN1Encoder2 = aSN1Encoder;
            int n3 = aSN1Encoder2.encodeExplicit(ASN1Tag.makeContextTag((int)0));
            this.h.encode(aSN1Encoder);
            aSN1Encoder2.endOf(n3);
        }
        aSN1Encoder.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        int n2;
        ASN1Decoder aSN1Decoder2 = aSN1Decoder;
        int n3 = aSN1Decoder2.decodeSequence();
        int n4 = aSN1Decoder2.decodeSequence();
        if (aSN1Decoder2.nextIsDefault(ASN1Tag.makeExplicitTag((int)0))) {
            this.a = 1;
        } else {
            ASN1Decoder aSN1Decoder3 = aSN1Decoder;
            n2 = aSN1Decoder3.decodeExplicit(ASN1Tag.makeContextTag((int)0));
            this.a = aSN1Decoder3.decodeIntegerAsInt();
            ++this.a;
            aSN1Decoder.endOf(n2);
        }
        this.b.decode(aSN1Decoder);
        this.c = aSN1Decoder.decodeGeneralizedTime();
        this.d.clear();
        n2 = aSN1Decoder.decodeSequenceOf();
        while (!aSN1Decoder.endOf(n2)) {
            SingleResponse singleResponse;
            SingleResponse singleResponse2 = singleResponse;
            singleResponse2();
            singleResponse.decode(aSN1Decoder);
            this.d.addElement(singleResponse2);
        }
        this.e.clear();
        if (!aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)1))) {
            ASN1Decoder aSN1Decoder4 = aSN1Decoder;
            int n5 = aSN1Decoder4.decodeExplicit(ASN1Tag.makeContextTag((int)1));
            this.e.decode(aSN1Decoder);
            aSN1Decoder4.endOf(n5);
        }
        aSN1Decoder.endOf(n4);
        this.f.decode(aSN1Decoder);
        this.g = aSN1Decoder.decodeBitString();
        this.h.clear();
        if (!aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)0))) {
            ASN1Decoder aSN1Decoder5 = aSN1Decoder;
            int n6 = aSN1Decoder5.decodeExplicit(ASN1Tag.makeContextTag((int)0));
            this.h.decode(aSN1Decoder);
            aSN1Decoder5.endOf(n6);
        }
        aSN1Decoder.endOf(n3);
    }

    public byte[] getSignature() {
        return this.g.getAsByteArray();
    }

    public String getSigAlgName() {
        return this.f.getAlgName();
    }

    public String getSigAlgOID() {
        return this.f.getAlg();
    }

    public byte[] getSigAlgParams() {
        return this.f.getParameter();
    }

    public boolean isSigned() {
        return this.f != null && this.g != null;
    }

    public void addCert(X509Certificate x509Certificate) {
        this.h.add(x509Certificate);
        this.modified = true;
    }

    @Override
    public void verify(PublicKey publicKey) throws OCSPException {
        this.verify(publicKey, "Initech");
    }

    public void verify(PublicKey object, String object2) throws OCSPException {
        block6: {
            BasicResponse basicResponse;
            BasicResponse basicResponse2;
            PublicKey publicKey;
            INISignature iNISignature;
            object2 = iNISignature;
            try {
                publicKey = object;
                BasicResponse basicResponse3 = object3;
                basicResponse2 = basicResponse3;
                basicResponse = basicResponse3;
                ((INISignature)object2)();
                Object object3 = basicResponse3.getTBSResponse();
            }
            catch (Exception exception) {
                throw new OCSPException(exception);
            }
            object = basicResponse.getSignature();
            object2 = basicResponse2.getSigAlgName();
            if (!iNISignature.doVerify(publicKey, (byte[])object3, (byte[])object, (String)object2)) break block6;
            return;
        }
        throw new OCSPException("Bad Signature");
    }

    public void sign(PrivateKey privateKey, AlgorithmID algorithmID) throws OCSPException {
        this.sign(privateKey, algorithmID, "Initech");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sign(PrivateKey privateKey, AlgorithmID algorithmID, String object) throws OCSPException {
        INISignature iNISignature;
        BasicResponse basicResponse;
        try {
            ((BasicResponse)object2).f = (AlgorithmID)algorithmID.clone();
            ((BasicResponse)object2).tbsModified = true;
            if (((BasicResponse)object2).g == null) {
                ((BasicResponse)object2).g = new ASN1BitString();
            }
            BasicResponse basicResponse2 = object2;
            basicResponse = basicResponse2;
            BasicResponse basicResponse3 = basicResponse2;
        }
        catch (Exception exception) {
            throw new OCSPException(exception);
        }
        object = iNISignature;
        {
            ((INISignature)object)();
            Object object2 = ((BasicResponse)object2).getTBSResponse();
            object2 = iNISignature.doSign(privateKey, (byte[])object2, algorithmID.getAlgName());
            basicResponse.g.setByteArray((byte[])object2);
            basicResponse3.modified = true;
            return;
        }
    }

    public void setSigAlg(AlgorithmID algorithmID) {
        this.f = algorithmID;
    }

    public void setSignature(byte[] byArray) {
        if (this.g == null) {
            ASN1BitString aSN1BitString;
            ASN1BitString aSN1BitString2 = aSN1BitString;
            aSN1BitString = new ASN1BitString();
            this.g = aSN1BitString2;
        }
        this.g.setByteArray(byArray);
        this.modified = true;
    }

    public byte[] getExtensionValue(String string) {
        BasicResponse basicResponse = basicResponse.e.getExtension(string);
        if (basicResponse != null) {
            return basicResponse.getExtValue();
        }
        return null;
    }

    public void addExtension(Extension extension) {
        this.tbsModified = true;
        this.e.add(extension);
    }

    public void clearExtensions() {
        this.tbsModified = true;
        this.e.clear();
    }

    public void removeExtension(String string) {
        this.tbsModified = true;
        this.e.remove(string);
    }

    public void setVersion(int n2) {
        BasicResponse basicResponse = this;
        basicResponse.tbsModified = true;
        basicResponse.a = n2;
    }

    public int getVersion() {
        return this.a;
    }

    public void setProducedAt(Date date) {
        BasicResponse basicResponse = this;
        basicResponse.tbsModified = true;
        basicResponse.c = new Date(date.getTime());
    }

    public Date getProducedAt() {
        return new Date(this.c.getTime());
    }

    public void add(SingleResponse singleResponse) {
        this.d.addElement(singleResponse);
    }

    public void add(CertID certID, int n2, Date date) {
        this.add(certID, n2, null, date, null);
    }

    public void add(CertID certID, int n2, Date date, Date date2) {
        this.add(certID, n2, null, date, date2);
    }

    public void add(CertID certID, int n2, Date date, Date date2, Date date3) {
        SingleResponse singleResponse;
        SingleResponse singleResponse2 = singleResponse;
        new SingleResponse().setCertID(certID);
        singleResponse2.setStatus(n2);
        singleResponse2.setThisUpdate(date2);
        if (date3 != null) {
            singleResponse2.setNextUpdate(date3);
        }
        if (date != null) {
            singleResponse2.setStatusRevoked(date);
        }
        this.add(singleResponse2);
    }

    public void setResponderID(ResponderID responderID) {
        BasicResponse basicResponse = this;
        basicResponse.b = responderID;
        basicResponse.tbsModified = true;
    }

    @Override
    public Enumeration getResponses() {
        return this.d.elements();
    }

    public int size() {
        return this.d.size();
    }

    public SingleResponse getResponseAt(int n2) {
        if (n2 >= 0 && n2 <= this.d.size() - 1) {
            return (SingleResponse)((Object)this.d.elementAt(n2));
        }
        return null;
    }

    @Override
    public X509Certificate[] getCerts() {
        return this.h.getCertificates();
    }
}

