/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.ocsp;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.core.ocsp.BasicResponse;
import com.initech.core.ocsp.OCSPResponseType;
import com.initech.core.ocsp.RAWResponse;
import java.io.InputStream;

public class OCSPResponse
extends ASN1Object {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;
    public int a;
    public OCSPResponseType b;

    public OCSPResponse(int n2) {
        this.a = n2;
        this.modified = true;
        this.b = null;
    }

    public OCSPResponse(int n2, OCSPResponseType oCSPResponseType) {
        this.a = n2;
        this.b = oCSPResponseType;
        this.modified = true;
    }

    public OCSPResponse(InputStream inputStream) throws ASN1Exception {
        DERDecoder dERDecoder;
        OCSPResponse oCSPResponse = oCSPResponse2;
        oCSPResponse();
        OCSPResponse oCSPResponse2 = dERDecoder;
        dERDecoder = new DERDecoder(inputStream);
        oCSPResponse.decode((ASN1Decoder)oCSPResponse2);
        oCSPResponse.modified = true;
    }

    public OCSPResponse(byte[] byArray) throws ASN1Exception {
        OCSPResponse oCSPResponse = this;
        OCSPResponse oCSPResponse2 = this;
        oCSPResponse2();
        oCSPResponse2.decode((ASN1Decoder)new DERDecoder(byArray));
        oCSPResponse.encoded = (byte[])byArray.clone();
        oCSPResponse.modified = false;
    }

    public OCSPResponse() {
        this.modified = true;
        this.a = 0;
        this.b = null;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        int n2 = aSN1Encoder.encodeSequence();
        aSN1Encoder.encodeEnumeration(this.a);
        if (this.b != null) {
            ASN1Encoder aSN1Encoder2 = aSN1Encoder;
            ASN1Encoder aSN1Encoder3 = aSN1Encoder;
            int n3 = aSN1Encoder3.encodeExplicit(ASN1Tag.makeContextTag((int)0));
            int n4 = aSN1Encoder3.encodeSequence();
            aSN1Encoder.encodeObjectIdentifier(this.b.getType());
            aSN1Encoder2.encodeOctetString(this.b.getEncoded());
            aSN1Encoder2.endOf(n4);
            aSN1Encoder2.endOf(n3);
        }
        aSN1Encoder.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        ASN1Decoder aSN1Decoder2 = aSN1Decoder;
        int n2 = aSN1Decoder2.decodeSequence();
        object.a = aSN1Decoder2.decodeEnumeration();
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)0))) {
            object.b = null;
        } else {
            Object object;
            ASN1Decoder aSN1Decoder3 = aSN1Decoder;
            int n3 = aSN1Decoder3.decodeExplicit(ASN1Tag.makeContextTag((int)0));
            int n4 = aSN1Decoder3.decodeSequence();
            ASN1OID aSN1OID = aSN1Decoder3.decodeObjectIdentifier();
            byte[] byArray = aSN1Decoder.decodeOctetString();
            if (aSN1OID.equals((Object)"1.3.6.1.5.5.7.48.1.1")) {
                BasicResponse basicResponse;
                OCSPResponse oCSPResponse = object;
                object = basicResponse;
                new BasicResponse().set(aSN1OID, byArray);
                oCSPResponse.b = object;
            } else {
                RAWResponse rAWResponse;
                OCSPResponse oCSPResponse = object;
                object = rAWResponse;
                new RAWResponse().set(aSN1OID, byArray);
                oCSPResponse.b = object;
            }
            ASN1Decoder aSN1Decoder4 = aSN1Decoder;
            aSN1Decoder4.endOf(n4);
            aSN1Decoder4.endOf(n3);
        }
        aSN1Decoder.endOf(n2);
    }

    public String getResponseType() {
        OCSPResponseType oCSPResponseType = ((OCSPResponse)((Object)oCSPResponseType)).b;
        if (oCSPResponseType == null) {
            return null;
        }
        return oCSPResponseType.getType().get();
    }

    public OCSPResponseType getResponse() {
        return this.b;
    }

    public void setResponse(OCSPResponseType oCSPResponseType) {
        OCSPResponse oCSPResponse = this;
        oCSPResponse.modified = true;
        oCSPResponse.b = oCSPResponseType;
    }

    public void setStatus(int n2) {
        OCSPResponse oCSPResponse = this;
        oCSPResponse.modified = true;
        oCSPResponse.a = n2;
        if (n2 != 0) {
            this.b = null;
        }
    }

    public int getStatus() {
        return this.a;
    }
}

