/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.ocsp;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.Extensions;
import com.initech.core.ocsp.CertID;
import com.initech.core.ocsp.OCSPException;
import java.security.cert.X509Certificate;

public class Request
extends ASN1Object {
    public CertID a;
    public Extensions b;

    public Request() {
        CertID certID;
        Extensions extensions;
        ASN1Object aSN1Object = extensions;
        extensions = new Extensions();
        v1.b = aSN1Object;
        aSN1Object = certID;
        certID = new CertID();
        v1.a = aSN1Object;
    }

    public Request(String string, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws OCSPException {
        Extensions extensions;
        Request request = request2;
        Request request2 = extensions;
        extensions = new Extensions();
        request.b = request2;
        request.modified = true;
        request.set(string, x509Certificate, x509Certificate2);
    }

    public void set(String string, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws OCSPException {
        if (string.equals("SHA1")) {
            this.a = new CertID(AlgorithmID.SHA1, x509Certificate, x509Certificate2);
            return;
        }
        if (!string.equals("SHA256") && !string.equals("SHA-256")) {
            if (!string.equals("SHA384") && !string.equals("SHA-384")) {
                if (!string.equals("SHA512") && !string.equals("SHA-512")) {
                    if (string.equals("MD5")) {
                        this.a = new CertID(AlgorithmID.MD5, x509Certificate, x509Certificate2);
                        return;
                    }
                    throw new OCSPException("No such algorithm exist");
                }
                this.a = new CertID(AlgorithmID.SHA512, x509Certificate, x509Certificate2);
                return;
            }
            this.a = new CertID(AlgorithmID.SHA384, x509Certificate, x509Certificate2);
            return;
        }
        this.a = new CertID(AlgorithmID.SHA256, x509Certificate, x509Certificate2);
    }

    public CertID getCertID() {
        return this.a;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        Request request = this;
        int n2 = aSN1Encoder.encodeSequence();
        request.a.encode(aSN1Encoder);
        if (request.b.size() > 0) {
            ASN1Encoder aSN1Encoder2 = aSN1Encoder;
            int n3 = aSN1Encoder2.encodeExplicit(ASN1Tag.makeContextTag((int)0));
            this.b.encode(aSN1Encoder);
            aSN1Encoder2.endOf(n3);
        }
        aSN1Encoder.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        Request request = this;
        int n2 = aSN1Decoder.decodeSequence();
        request.a.decode(aSN1Decoder);
        request.b.clear();
        if (!aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)0))) {
            ASN1Decoder aSN1Decoder2 = aSN1Decoder;
            int n3 = aSN1Decoder2.decodeExplicit(ASN1Tag.makeContextTag((int)0));
            this.b.decode(aSN1Decoder);
            aSN1Decoder2.endOf(n3);
        }
        aSN1Decoder.endOf(n2);
    }

    public byte[] getExtensionValue(String string) {
        Request request = request.b.getExtension(string);
        if (request != null) {
            return request.getExtValue();
        }
        return null;
    }

    public void addExtension(Extension extension) {
        this.modified = true;
        this.b.add(extension);
    }

    public void clearExtensions() {
        this.modified = true;
        this.b.clear();
    }

    public void removeExtension(String string) {
        this.modified = true;
        this.b.remove(string);
    }
}

