/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cpv;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.IssuerAndSerialNumber;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.core.INISAFECore;
import com.initech.cpv.CertPathContext;
import com.initech.cpv.PolicyNode;
import com.initech.cpv.exception.BasicConstraintsViolateException;
import com.initech.cpv.exception.CertRevokedException;
import com.initech.cpv.exception.CertSigVerifyFailException;
import com.initech.cpv.exception.CertTimeVerifyFailException;
import com.initech.cpv.exception.ExplicitPolicyRequiredException;
import com.initech.cpv.exception.InvalidPolicyMappingException;
import com.initech.cpv.exception.IssuerNotMatchedException;
import com.initech.cpv.exception.KeyUsageViolateException;
import com.initech.cpv.exception.MaxPathLengthLimitException;
import com.initech.cpv.exception.NameConstraintsViolationException;
import com.initech.cpv.exception.NotCACertificateException;
import com.initech.cpv.exception.PathValidateException;
import com.initech.cpv.exception.PublicKeyInfoFailException;
import com.initech.cpv.exception.UndeterminedCertStatusException;
import com.initech.cpv.util.Debug;
import com.initech.pki.util.Hex;
import com.initech.x509.X509CertImpl;
import com.initech.x509.extensions.BasicConstraints;
import com.initech.x509.extensions.CertificatePolicies;
import com.initech.x509.extensions.GeneralSubTrees;
import com.initech.x509.extensions.InhibitAnyPolicy;
import com.initech.x509.extensions.KeyUsage;
import com.initech.x509.extensions.NameConstraints;
import com.initech.x509.extensions.PolicyConstraints;
import com.initech.x509.extensions.PolicyInfo;
import com.initech.x509.extensions.PolicyMappings;
import com.initech.x509.extensions.PolicyQualifier;
import com.initech.x509.extensions.SubjectAltName;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class CertChainEntry {
    public static final int ROOTCA_CERT = 0;
    public static final int RELAYCA_CERT = 1;
    public static final int USER_CERT = 2;
    public static boolean certVerifyFlag = false;
    public CertPathContext a;
    public HashSet b;
    public GeneralSubTrees c;
    public GeneralSubTrees d;
    public int e;
    public int f;
    public int g;
    public int h;
    public AlgorithmID i;
    public PublicKey j;
    public AlgorithmParameters k;
    public Name l;
    public X509CertImpl m;
    public int n;
    public IssuerAndSerialNumber o;
    public boolean p;

    public CertChainEntry(int n2, CertPathContext certPathContext, X509Certificate x509Certificate, int n3) {
        IssuerAndSerialNumber issuerAndSerialNumber;
        IssuerAndSerialNumber issuerAndSerialNumber2;
        this.n = n2;
        this.a = certPathContext;
        if (x509Certificate != null && x509Certificate instanceof X509Certificate) {
            try {
                this.m = new X509CertImpl(x509Certificate.getEncoded());
            }
            catch (Exception exception) {
                Debug.handleException(exception);
            }
        } else if (x509Certificate != null && x509Certificate instanceof X509CertImpl) {
            this.m = (X509CertImpl)x509Certificate;
        }
        IssuerAndSerialNumber issuerAndSerialNumber3 = issuerAndSerialNumber2 = issuerAndSerialNumber;
        issuerAndSerialNumber3();
        this.o = issuerAndSerialNumber3;
        issuerAndSerialNumber.set((X509Certificate)this.m);
    }

    public final BasicConstraints a() {
        CertChainEntry certChainEntry;
        block4: {
            BasicConstraints basicConstraints;
            CertChainEntry certChainEntry2 = certChainEntry3;
            CertChainEntry certChainEntry3 = null;
            byte[] byArray = certChainEntry2.m.getExtensionValue("2.5.29.19");
            if (byArray == null) break block4;
            certChainEntry = basicConstraints;
            try {
                basicConstraints = new BasicConstraints(byArray);
            }
            catch (ASN1Exception aSN1Exception) {
                aSN1Exception.printStackTrace();
                certChainEntry = certChainEntry3;
            }
        }
        certChainEntry = certChainEntry3;
        return certChainEntry;
    }

    public final void a(HashSet object, PolicyInfo policyInfo, boolean bl) {
        object = ((HashSet)object).iterator();
        while (object.hasNext()) {
            PolicyNode policyNode = (PolicyNode)object.next();
            for (ASN1OID aSN1OID : policyNode.getExpectedPolicies().keySet()) {
                PolicyInfo policyInfo2;
                PolicyNode policyNode2;
                PolicyNode policyNode3 = policyNode2;
                policyNode2 = new PolicyNode();
                PolicyInfo policyInfo3 = policyInfo2;
                policyInfo2 = new PolicyInfo(aSN1OID);
                Enumeration enumeration = policyInfo.elementsQualifiers();
                while (enumeration.hasMoreElements()) {
                    policyInfo3.addQualifier((PolicyQualifier)enumeration.nextElement());
                }
                PolicyNode policyNode4 = policyNode3;
                policyNode3.setValidPolicy(policyInfo3);
                policyNode3.setCritical(bl);
                policyNode3.addExpectedPolicy(aSN1OID);
                policyNode4.setParent(policyNode);
                policyNode.addChild(policyNode4);
                this.b.add(policyNode3);
            }
        }
    }

    public final void b(HashSet object, PolicyInfo policyInfo, boolean bl) {
        object = ((HashSet)object).iterator();
        while (object.hasNext()) {
            PolicyInfo policyInfo2;
            PolicyNode policyNode;
            PolicyNode policyNode2 = (PolicyNode)object.next();
            if (!policyNode2.hasExpectedPolicy(policyInfo.getPolicyID())) continue;
            PolicyNode policyNode3 = policyNode;
            policyNode = new PolicyNode();
            PolicyInfo policyInfo3 = policyInfo2;
            policyInfo2 = new PolicyInfo(policyInfo.getPolicyID());
            Enumeration enumeration = policyInfo.elementsQualifiers();
            while (enumeration.hasMoreElements()) {
                policyInfo3.addQualifier((PolicyQualifier)enumeration.nextElement());
            }
            PolicyNode policyNode4 = policyNode3;
            policyNode3.setValidPolicy(policyInfo3);
            policyNode3.setCritical(bl);
            policyNode3.addExpectedPolicy(policyInfo.getPolicyID());
            policyNode4.setParent(policyNode2);
            policyNode2.addChild(policyNode4);
            this.b.add(policyNode3);
        }
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("PermittedSubtrees : \n");
        Object object = certChainEntry.c;
        if (object != null) {
            object.toString(stringBuffer2, 1);
        }
        stringBuffer2.append("ExcludedSubtrees : \n");
        object = certChainEntry.d;
        if (object != null) {
            object.toString(stringBuffer2, 1);
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        StringBuffer stringBuffer4 = stringBuffer2;
        StringBuffer stringBuffer5 = stringBuffer2;
        StringBuffer stringBuffer6 = stringBuffer2;
        stringBuffer2.append("Explicit Policy : ");
        stringBuffer6.append(certChainEntry.e);
        stringBuffer6.append("\n");
        stringBuffer6.append("Policy Mapping : ");
        stringBuffer5.append(certChainEntry.g);
        stringBuffer5.append("\n");
        stringBuffer5.append("Inhibit Any-Policy : ");
        stringBuffer4.append(certChainEntry.f);
        stringBuffer4.append("\n");
        stringBuffer4.append("Max Path Length : ");
        stringBuffer3.append(certChainEntry.h);
        stringBuffer3.append("\n");
        stringBuffer3.append("Valid Policy Nodes : \n");
        object = certChainEntry.b;
        if (object != null) {
            object = ((HashSet)object).iterator();
            while (object.hasNext()) {
                StringBuffer stringBuffer7 = stringBuffer2;
                stringBuffer7.append(((PolicyNode)object.next()).toString(1));
                stringBuffer7.append("\n");
            }
        }
        stringBuffer2.append("Working Issuer Name : ");
        object = certChainEntry.l;
        if (object != null) {
            stringBuffer2.append(object.toString(true));
        }
        StringBuffer stringBuffer8 = stringBuffer2;
        stringBuffer8.append("\n");
        stringBuffer8.append("Working PublicKey : \n");
        object = certChainEntry.j;
        if (object != null) {
            stringBuffer2.append(Hex.prettyDump(object.getEncoded()));
        }
        StringBuffer stringBuffer9 = stringBuffer2;
        stringBuffer9.append("\n");
        stringBuffer9.append("Working PublicKey Algorithm : \n");
        object = certChainEntry.i;
        if (object != null) {
            stringBuffer2.append(object.toString());
        }
        StringBuffer stringBuffer10 = stringBuffer2;
        stringBuffer10.append("\n");
        stringBuffer10.append("Working PublicKey Parameters : \n");
        object = certChainEntry.k;
        if (object != null) {
            stringBuffer2.append(((AlgorithmParameters)object).toString());
        }
        StringBuffer stringBuffer11 = stringBuffer2;
        stringBuffer11.append("\n");
        stringBuffer11.append("Current Certificate : \n");
        CertChainEntry certChainEntry = certChainEntry.m;
        if (certChainEntry != null) {
            stringBuffer2.append(certChainEntry.toString());
        }
        return stringBuffer2.toString();
    }

    public void setFromEntry(CertChainEntry certChainEntry) {
        this.setPermittedSubTrees(certChainEntry.getPermittedSubTrees());
        this.setExcludedSubTrees(certChainEntry.getExcludedSubTrees());
        this.setExplicitPolicy(certChainEntry.getExplicitPolicy());
        this.setPolicyMapping(certChainEntry.getPolicyMapping());
        this.setInhibitAnyPolicy(certChainEntry.getInhibitAnyPolicy());
        this.setMaxPathLength(certChainEntry.getMaxPathLength());
        this.setWorkingIssuerName(certChainEntry.getWorkingIssuerName());
        this.setWorkingPublicKey(certChainEntry.getWorkingPublicKey());
        this.setWorkingPublicKeyAlgorithm(certChainEntry.getWorkingPublicKeyAlgorithm());
        this.setWorkingPublicKeyParameters(certChainEntry.getWorkingPublicKeyParameters());
    }

    public boolean verify(byte[] byArray, byte[] byArray2, String object, PublicKey publicKey, String string) {
        boolean bl = false;
        object = Signature.getInstance((String)object, string);
        try {
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(byArray);
            bl = ((Signature)object).verify(byArray2);
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public void process(CertChainEntry var1_6) throws PathValidateException {
        block71: {
            block75: {
                block79: {
                    block80: {
                        block81: {
                            block83: {
                                block84: {
                                    block85: {
                                        block86: {
                                            block70: {
                                                block69: {
                                                    block82: {
                                                        block68: {
                                                            block67: {
                                                                block66: {
                                                                    block77: {
                                                                        block78: {
                                                                            block76: {
                                                                                block65: {
                                                                                    block73: {
                                                                                        block74: {
                                                                                            block72: {
                                                                                                v0 = this;
                                                                                                v0.setFromEntry((CertChainEntry)var1_6);
                                                                                                var2_7 = v0.m;
                                                                                                if (var2_7 == null) break block71;
                                                                                                v1 = this;
                                                                                                var2_8 = false;
                                                                                                var3_17 /* !! */  = var2_7.getKeyUsage();
                                                                                                var4_21 /* !! */  = v1.a();
                                                                                                if (v1.m.getKeyUsage() == null && var4_21 /* !! */  != null ? var4_21 /* !! */ .isCA() : false) break block72;
                                                                                                v2 = this;
                                                                                                var4_21 /* !! */  = v2.a();
                                                                                                if (!(v2.m.getKeyUsage() != null && var4_21 /* !! */  != null ? var4_21 /* !! */ .isCA() : false)) break block73;
                                                                                                if (var3_17 /* !! */  == null) break block65;
                                                                                                if (!var3_17 /* !! */ [5] || !var3_17 /* !! */ [6]) break block74;
                                                                                            }
lbl16:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                var2_8 = true;
                                                                                                break block65;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        while (true) {
                                                                                            var2_8 = false;
                                                                                            break block65;
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    if (var3_17 /* !! */  != null) {
                                                                                        if (!var3_17 /* !! */ [0] && !var3_17 /* !! */ [1] && !var3_17 /* !! */ [2]) ** continue;
                                                                                        ** continue;
                                                                                    }
                                                                                }
                                                                                if (!var2_8) break block75;
                                                                                v3 = this;
                                                                                var2_8 = false;
                                                                                var3_17 /* !! */  = (boolean[])v3.a();
                                                                                var4_21 /* !! */  = v3.a();
                                                                                if (!(v3.m.getKeyUsage() == null && var4_21 /* !! */  != null ? var4_21 /* !! */ .isCA() : false)) break block76;
                                                                                if (var3_17 /* !! */  == null) break block66;
                                                                                if (!var3_17 /* !! */ .isCA() || 0x7FFFFFFF != var3_17 /* !! */ .getPathLen()) lbl-1000:
                                                                                // 3 sources

                                                                                {
                                                                                    while (true) {
                                                                                        var2_8 = false;
                                                                                        break block66;
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break block77;
                                                                            }
                                                                            v4 = this;
                                                                            var4_21 /* !! */  = v4.a();
                                                                            if (!(v4.m.getKeyUsage() != null && var4_21 /* !! */  != null ? var4_21 /* !! */ .isCA() : false)) break block78;
                                                                            if (var3_17 /* !! */  == null) break block66;
                                                                            if (!var3_17 /* !! */ .isCA() || var3_17 /* !! */ .getPathLen() < 0) ** GOTO lbl-1000
                                                                            break block77;
                                                                        }
                                                                        if (var3_17 /* !! */  == null || !var3_17 /* !! */ .isCA() && var3_17 /* !! */ .getPathLen() == -1) ** break;
                                                                        ** while (true)
                                                                    }
                                                                    var2_8 = true;
                                                                }
                                                                if (!var2_8) break block79;
                                                                INISAFECore.CoreLogger(4, "\ud604\uc7ac \uac80\uc99d \ud558\ub294 \uc778\uc99d\uc11c dn: " + this.m.getSubjectDN().toString());
                                                                if (!this.a.getHSMSelecte().equals("1")) ** GOTO lbl84
                                                                INISAFECore.CoreLogger(4, "\uc778\uc99d\uc11c \uac80\uc99d \uc2dc HSM(nCipher)\uc744 \uc0ac\uc6a9\ud569\ub2c8\ub2e4.");
                                                                if (this.m.isSelfSigned() && this.a.isVerifyCertSign()) {
                                                                    if (CertChainEntry.certVerifyFlag) break block67;
                                                                    v5 = this;
                                                                    INISAFECore.CoreLogger(4, "\ucd5c\uc0c1\uc704 \uc778\uc99d\uc11c \uc11c\uba85 \uac80\uc99d\uc744 \uc218\ud589\ud569\ub2c8\ub2e4.");
                                                                    v6 = this;
                                                                    var2_9 = v6.m.getSignature();
                                                                    var3_17 /* !! */  = (boolean[])v6.m.getSigAlgName();
                                                                    var4_21 /* !! */  = v6.m.getPublicKey();
                                                                    if (v5.verify(v5.m.getTBSCertificate(), var2_9, (String)var3_17 /* !! */ , (PublicKey)var4_21 /* !! */ , "nCipherKM")) lbl-1000:
                                                                    // 2 sources

                                                                    {
                                                                        while (true) {
                                                                            CertChainEntry.certVerifyFlag = true;
                                                                            break block67;
                                                                            break;
                                                                        }
                                                                    }
                                                                    INISAFECore.CoreLogger(1, "\ucd5c\uc0c1\uc704 \uc778\uc99d\uc11c \uc11c\uba85 \uac80\uc99d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                                                                    throw new PathValidateException("an error occurred during the root certificate signature validation .");
                                                                }
                                                                if (!this.a.isVerifyCertSign()) break block67;
                                                                v7 = this;
                                                                var2_10 = v7.m.getTBSCertificate();
                                                                if (v7.verify(var2_10, (byte[])(var3_17 /* !! */  = (boolean[])v7.m.getSignature()), (String)(var4_21 /* !! */  = v7.m.getSigAlgName()), (PublicKey)(var5_22 = v7.j), "nCipherKM")) break block67;
                                                                v8 = 1;
                                                                INISAFECore.CoreLogger(v8, "\uc778\uc99d\uc11c \uc11c\uba85 \uac80\uc99d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. Certificate SubjectDN=[" + this.m.getSubjectDN().toString() + "]");
                                                                v9 = v10;
                                                                v11 = v10;
                                                                v9("an error occurred during the certificate signature validation. Certificate SubjectDN=[" + this.m.getSubjectDN().toString() + "]");
                                                                throw v11;
lbl84:
                                                                // 1 sources

                                                                if (this.m.isSelfSigned() && this.a.isVerifyCertSign()) {
                                                                    if (!CertChainEntry.certVerifyFlag) {
                                                                        INISAFECore.CoreLogger(4, "\ucd5c\uc0c1\uc704 \uc778\uc99d\uc11c \uc11c\uba85 \uac80\uc99d\uc744 \uc218\ud589\ud569\ub2c8\ub2e4.");
                                                                        v12 = this.m;
                                                                        v12.verify(v12.getPublicKey());
                                                                        ** continue;
                                                                    }
                                                                    break block67;
                                                                }
                                                                if (!this.a.isVerifyCertSign()) break block67;
                                                                this.m.verify(this.j);
                                                            }
                                                            if (INISAFECore.NTPEnable()) {
                                                                var2_11 = INISAFECore.getNTPnSysTimeDiff();
                                                                var4_21 /* !! */  = v13;
                                                                v13 = new Date(System.currentTimeMillis() + var2_11);
                                                            } else {
                                                                var4_21 /* !! */  = this.a.getCurrentTime();
                                                            }
                                                            var2_12 = this.m.getNotAfter();
                                                            if (var4_21 /* !! */ .before(this.m.getNotBefore())) break block80;
                                                            if (var4_21 /* !! */ .after(var2_12)) break block81;
                                                            if (this.a.isCheckCertStatus()) {
                                                                v14 = this.a.getCertStatusChecker();
                                                                v14.setCertificate((X509Certificate)this.m);
                                                                try {
                                                                    if (!v14.isValid()) {
                                                                        throw new CertRevokedException("Certificate is revoked.");
                                                                    }
                                                                }
                                                                catch (Exception var2_13) {
                                                                    v15 = var2_13;
                                                                    Debug.handleException(v15);
                                                                    if (!(v15 instanceof CertRevokedException)) {
                                                                        if (!this.a.isIgnoreUndeterminedCertStatus()) {
                                                                            throw new UndeterminedCertStatusException(var2_13);
                                                                        }
                                                                    }
                                                                    throw (PathValidateException)var2_13;
                                                                }
                                                                catch (UndeterminedCertStatusException var2_14) {
                                                                    Debug.handleException(var2_14);
                                                                    if (this.a.isIgnoreUndeterminedCertStatus()) break block68;
                                                                    throw var2_14;
                                                                }
                                                            }
                                                        }
                                                        v16 = this;
                                                        var2_15 = v16.l.toString().equals(this.m.getIssuerDN().toString());
                                                        if (v16.a.isVerifyCertSign() && var2_15 == 0) {
                                                            System.out.println("workingIssuerName : " + this.l);
                                                            System.out.println("cert.getIssuerDN(): " + this.m.getIssuerDN());
                                                            throw new IssuerNotMatchedException("Issuer not matched.");
                                                        }
                                                        if (this.m.isSelfSigned() && this.n != this.a.getCertChain().length) break block82;
                                                        var2_15 = 0;
                                                        var3_18 = false;
                                                        var4_21 /* !! */  = v17;
                                                        v17 = new Name(this.m.getSubjectDN().getName());
                                                        v18 = this.m.getExtensionValue("2.5.29.17");
                                                        var5_22 = v18;
                                                        var6_27 = null;
                                                        if (v18 != null) {
                                                            var7_30 = v19;
                                                            try {
                                                                v19 = new SubjectAltName((byte[])var5_22);
                                                            }
                                                            catch (ASN1Exception v20) {
                                                                Debug.handleException((Exception)v20);
                                                                var7_30 = var6_27;
                                                            }
                                                        } else {
                                                            var7_30 = var6_27;
                                                        }
                                                        if (this.c == null) break block83;
                                                        if (var4_21 /* !! */ .isNullDN()) {
                                                            var2_15 = 1;
                                                        } else {
                                                            for (var5_23 = 0; var5_23 < this.c.size(); ++var5_23) {
                                                                var6_27 = this.c.getName(var5_23);
                                                                var8_31 = var4_21 /* !! */ .constrains(var6_27.getGeneralNameInterface());
                                                                if (var8_31 == -1) continue;
                                                                if (var8_31 != 0 && var8_31 != 1) {
                                                                    if (var6_27.getType() == var4_21 /* !! */ .getType()) continue;
                                                                    var2_15 = 0;
                                                                    break;
                                                                }
                                                                var2_15 = 1;
                                                            }
                                                        }
                                                        if (var7_30 == null) {
                                                            var3_18 = true;
                                                        } else {
                                                            var5_24 = var7_30.elements();
                                                            block26: while (var5_24.hasMoreElements()) {
                                                                var6_27 = (GeneralName)var5_24.nextElement();
                                                                if (var6_27.isNullName()) {
                                                                    while (true) {
                                                                        var3_18 = true;
                                                                        continue block26;
                                                                        break;
                                                                    }
                                                                }
                                                                if (var6_27.getType() == 8 || var6_27.getType() == 3 || var6_27.getType() == 5 || var6_27.getType() == 0) ** continue;
                                                                for (var8_31 = 0; var8_31 < this.c.size(); ++var8_31) {
                                                                    var9_32 = this.c.getName(var8_31);
                                                                    var10_33 = var6_27.getGeneralNameInterface().constrains(var9_32.getGeneralNameInterface());
                                                                    if (var10_33 == -1) continue;
                                                                    if (var10_33 != 0 && var10_33 != 1) {
                                                                        if (var9_32.getType() == var6_27.getType()) continue;
                                                                        var3_18 = false;
                                                                        break;
                                                                    }
                                                                    var3_18 = true;
                                                                }
                                                                if (var3_18) continue;
                                                            }
                                                        }
                                                        if (var2_15 == 0) break block84;
                                                        if (!var3_18) break block85;
                                                        if (this.d != null) {
                                                            for (var2_15 = 0; var2_15 < this.d.size(); ++var2_15) {
                                                                var3_19 = this.d.getName(var2_15);
                                                                var5_25 = var4_21 /* !! */ .constrains(var3_19.getGeneralNameInterface());
                                                                if (var5_25 != 0 && var5_25 != 1) {
                                                                    if (var7_30 == null) continue;
                                                                    var5_26 = var7_30.elements();
                                                                    while (var5_26.hasMoreElements()) {
                                                                        var6_28 = ((GeneralName)var5_26.nextElement()).getGeneralNameInterface().constrains(var3_19.getGeneralNameInterface());
                                                                        if (var6_28 == -1 || var6_28 != 0 && var6_28 != 1) continue;
                                                                        throw new NameConstraintsViolationException("Subject Alternative Name violates name constraints. (Exist in excluded names.)");
                                                                    }
                                                                    continue;
                                                                }
                                                                throw new NameConstraintsViolationException("Subject Name violates name constraints. (Exist in excluded names.)");
                                                            }
                                                        }
                                                        break block86;
                                                    }
                                                    var2_16 = v21;
                                                    v21 = new HashSet();
                                                    this.b = var2_16;
                                                    var2_16 = var1_6.getValidPolicySet();
                                                    var3_20 = null;
                                                    if (var2_16 == null) ** GOTO lbl-1000
                                                    v22 = this.m.getExtensionValue("2.5.29.32");
                                                    var4_21 /* !! */  = (BasicConstraints)v22;
                                                    if (v22 != null) {
                                                        v23 = this;
                                                        var5_22 = v24;
                                                        v24 = new CertificatePolicies((byte[])var4_21 /* !! */ );
                                                        try {
                                                            v23.p = true;
                                                        }
                                                        catch (ASN1Exception v25) {
                                                            break block69;
                                                        }
                                                    }
                                                    try {
                                                        this.p = false;
                                                        var5_22 = var3_20;
                                                        break block70;
                                                    }
                                                    catch (ASN1Exception v25) {
                                                        var5_22 = var3_20;
                                                    }
                                                }
                                                Debug.handleException((Exception)v25);
                                            }
                                            if (var5_22 != null) {
                                                var3_20 = var5_22.elements();
                                                while (var3_20.hasMoreElements()) {
                                                    var4_21 /* !! */  = (PolicyInfo)var3_20.nextElement();
                                                    if (!var4_21 /* !! */ .isAnyPolicy()) {
                                                        var6_29 = var5_22.isCritical();
                                                        this.b(var2_16, (PolicyInfo)var4_21 /* !! */ , var6_29);
                                                        continue;
                                                    }
                                                    if (var1_6.getInhibitAnyPolicy() <= 0 && (this.n >= this.a.getCertChain().length || !this.m.isSelfSigned())) continue;
                                                    var6_29 = var5_22.isCritical();
                                                    this.a(var2_16, (PolicyInfo)var4_21 /* !! */ , var6_29);
                                                }
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                this.b = null;
                                            }
                                            if ((var1_6 = this.b) != null && var1_6.size() <= 0) {
                                                this.b = null;
                                            }
                                            if (this.p && this.e <= 0 && this.b == null) {
                                                throw new ExplicitPolicyRequiredException("explicit_policy is required, but valid policy set is null.");
                                            }
                                            return;
                                        }
                                        throw new PathValidateException("excludedSubTrees is null");
                                    }
                                    throw new NameConstraintsViolationException("Subject Alternative Name violates name constraints. (Not exist in permitted names.)");
                                }
                                throw new NameConstraintsViolationException("Subject Name violates name constraints. (Not exist in permitted names.)");
                            }
                            throw new PathValidateException("permittedSubTrees is null");
                        }
                        INISAFECore.CoreLogger(4, "========================================");
                        INISAFECore.CoreLogger(4, "cert: " + this.m);
                        INISAFECore.CoreLogger(4, "currentTime: " + var4_21 /* !! */ );
                        INISAFECore.CoreLogger(4, "notAfter: " + var2_12);
                        INISAFECore.CoreLogger(4, "========================================");
                        throw new CertTimeVerifyFailException("Certificate is expired.");
                    }
                    throw new CertTimeVerifyFailException("Certificate is not valid yet.");
                    catch (SignatureException var0_1) {
                        Debug.handleException(var0_1);
                        throw new CertSigVerifyFailException(var0_1);
                    }
                    catch (NoSuchProviderException var0_2) {
                        Debug.handleException(var0_2);
                        throw new CertSigVerifyFailException(var0_2);
                    }
                    catch (NoSuchAlgorithmException var0_3) {
                        Debug.handleException(var0_3);
                        throw new CertSigVerifyFailException(var0_3);
                    }
                    catch (CertificateException var0_4) {
                        Debug.handleException(var0_4);
                        throw new CertSigVerifyFailException(var0_4);
                    }
                    catch (InvalidKeyException var0_5) {
                        Debug.handleException(var0_5);
                        throw new CertSigVerifyFailException(var0_5);
                    }
                }
                throw new BasicConstraintsViolateException(this.m.toString());
            }
            throw new KeyUsageViolateException("[" + this.m.getSubjectDN() + "][" + this.m.getKeyUsage() + "]");
        }
        throw new PathValidateException("Cert is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare() throws PathValidateException {
        int n2;
        PolicyMappings policyMappings;
        PolicyMappings policyMappings2;
        block57: {
            PublicKeyInfo publicKeyInfo;
            CertChainEntry certChainEntry;
            byte[] byArray = ((CertChainEntry)object).m.getExtensionValue("2.5.29.33");
            policyMappings2 = null;
            if (byArray != null) {
                PolicyMappings policyMappings3;
                policyMappings = policyMappings3;
                try {
                    policyMappings3 = new PolicyMappings(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    aSN1Exception.printStackTrace();
                    policyMappings = policyMappings2;
                }
            } else {
                policyMappings = policyMappings2;
            }
            if (policyMappings != null && ((CertChainEntry)object).b != null) {
                Enumeration enumeration = policyMappings.elements();
                while (enumeration.hasMoreElements()) {
                    policyMappings2 = (PolicyMappings.PolicyMapping)enumeration.nextElement();
                    policyMappings = policyMappings2.getIssuerPolicy();
                    policyMappings2 = policyMappings2.getSubjectPolicy();
                    if (policyMappings.equals((Object)PolicyInfo.anyPolicy)) throw new InvalidPolicyMappingException("Any-policy is not allowed in policy mappings.");
                    if (policyMappings2.equals((Object)PolicyInfo.anyPolicy)) throw new InvalidPolicyMappingException("Any-policy is not allowed in policy mappings.");
                    Iterator iterator = ((CertChainEntry)object).b.iterator();
                    while (iterator.hasNext()) {
                        PolicyNode policyNode = (PolicyNode)iterator.next();
                        if (((CertChainEntry)object).g > 0) {
                            PolicyInfo policyInfo;
                            PolicyNode policyNode2;
                            if (policyNode.isPolicy((ASN1OID)policyMappings)) {
                                if (policyNode.getExpectedPolicies().containsKey(policyMappings)) {
                                    policyNode.getExpectedPolicies().remove(policyMappings);
                                }
                                policyNode.addExpectedPolicy((ASN1OID)policyMappings2);
                                continue;
                            }
                            if (!policyNode.isPolicy(PolicyInfo.anyPolicy)) continue;
                            if (policyNode.getExpectedPolicies().containsKey(policyMappings)) {
                                policyNode.getExpectedPolicies().remove(policyMappings);
                            }
                            PolicyNode policyNode3 = policyNode2;
                            policyNode2 = new PolicyNode();
                            PolicyInfo policyInfo2 = policyInfo;
                            policyInfo = new PolicyInfo((ASN1OID)policyMappings);
                            Enumeration enumeration2 = policyNode.getValidPolicy().elementsQualifiers();
                            while (enumeration2.hasMoreElements()) {
                                policyInfo2.addQualifier((PolicyQualifier)enumeration2.nextElement());
                            }
                            PolicyNode policyNode4 = policyNode3;
                            PolicyNode policyNode5 = policyNode;
                            policyNode3.setCritical(policyNode.isCritical());
                            policyNode3.setValidPolicy(policyInfo2);
                            policyNode5.addExpectedPolicy((ASN1OID)policyMappings2);
                            policyNode4.setParent(policyNode5);
                            policyNode.addChild(policyNode4);
                            ((CertChainEntry)object).b.add(policyNode3);
                            continue;
                        }
                        if (!policyNode.isPolicy((ASN1OID)policyMappings)) continue;
                        iterator.remove();
                    }
                }
            }
            ((CertChainEntry)object).l = new Name(((CertChainEntry)object).m.getSubjectDN().getName());
            if (((CertChainEntry)object).m.getPublicKey().getFormat().equals("X.509")) {
                certChainEntry = object;
            }
            ((CertChainEntry)object).j = ((CertChainEntry)object).m.getPublicKey();
            break block57;
            PublicKeyInfo publicKeyInfo2 = publicKeyInfo;
            try {
                publicKeyInfo = new PublicKeyInfo(((CertChainEntry)object).m.getPublicKey().getEncoded());
                if (certChainEntry.j.getAlgorithm().equals(publicKeyInfo2.getAlgorithm()) && publicKeyInfo2.getAlgParameter() == null) {
                    publicKeyInfo2.setAlgParameter(new PublicKeyInfo(((CertChainEntry)object).j.getEncoded()).getAlgParameter());
                }
                ((CertChainEntry)object).j = publicKeyInfo2.getPublicKey();
            }
            catch (Exception exception) {
                throw new PublicKeyInfoFailException("PublicKey(X.509 format) key fails. : " + exception.getMessage());
            }
        }
        byte[] byArray = ((CertChainEntry)object).m.getExtensionValue("2.5.29.30");
        policyMappings2 = null;
        if (byArray != null) {
            NameConstraints nameConstraints;
            policyMappings = nameConstraints;
            try {
                nameConstraints = new NameConstraints(byArray);
            }
            catch (ASN1Exception aSN1Exception) {
                Debug.handleException((Exception)((Object)aSN1Exception));
                policyMappings = policyMappings2;
            }
        } else {
            policyMappings = policyMappings2;
        }
        if (policyMappings != null) {
            PolicyMappings policyMappings4 = policyMappings;
            GeneralSubTrees generalSubTrees = policyMappings4.getPermittedSubTrees();
            policyMappings2 = policyMappings4.getExcludedSubTrees();
            if (generalSubTrees.size() > 0) {
                ((CertChainEntry)object).c = ((CertChainEntry)object).c.intersect(generalSubTrees);
            }
            if (policyMappings2.size() > 0) {
                ((CertChainEntry)object).d.union((GeneralSubTrees)policyMappings2);
            }
        }
        if (!((CertChainEntry)object).m.isSelfSigned()) {
            int n3;
            int n4;
            int n5 = ((CertChainEntry)object).e;
            if (n5 > 0) {
                ((CertChainEntry)object).e = n5 - 1;
            }
            if ((n4 = ((CertChainEntry)object).g) > 0) {
                ((CertChainEntry)object).g = n4 - 1;
            }
            if ((n3 = ((CertChainEntry)object).f) > 0) {
                ((CertChainEntry)object).f = n3 - 1;
            }
        }
        byte[] byArray2 = ((CertChainEntry)object).m.getExtensionValue("2.5.29.36");
        policyMappings2 = null;
        if (byArray2 != null) {
            PolicyConstraints policyConstraints;
            policyMappings = policyConstraints;
            try {
                policyConstraints = new PolicyConstraints(byArray2);
            }
            catch (ASN1Exception aSN1Exception) {
                Debug.handleException((Exception)((Object)aSN1Exception));
                policyMappings = policyMappings2;
            }
        } else {
            policyMappings = policyMappings2;
        }
        if (policyMappings != null) {
            int n6;
            int n7 = policyMappings.getRequireExplicitPolicy();
            if (n7 >= 0 && n7 < ((CertChainEntry)object).e) {
                ((CertChainEntry)object).e = n7;
            }
            if ((n6 = policyMappings.getInhibitPolicyMapping()) >= 0 && n6 < ((CertChainEntry)object).g) {
                ((CertChainEntry)object).g = n6;
            }
        }
        byte[] byArray3 = ((CertChainEntry)object).m.getExtensionValue("2.5.29.54");
        policyMappings2 = null;
        if (byArray3 != null) {
            InhibitAnyPolicy inhibitAnyPolicy;
            policyMappings = inhibitAnyPolicy;
            try {
                inhibitAnyPolicy = new InhibitAnyPolicy(byArray3);
            }
            catch (ASN1Exception aSN1Exception) {
                Debug.handleException((Exception)((Object)aSN1Exception));
                policyMappings = policyMappings2;
            }
        } else {
            policyMappings = policyMappings2;
        }
        if (policyMappings != null && (n2 = policyMappings.getSkipCerts()) >= 0 && n2 < ((CertChainEntry)object).f) {
            ((CertChainEntry)object).f = n2;
        }
        byte[] byArray4 = ((CertChainEntry)object).m.getExtensionValue("2.5.29.19");
        policyMappings2 = null;
        if (byArray4 != null) {
            BasicConstraints basicConstraints;
            policyMappings = basicConstraints;
            try {
                basicConstraints = new BasicConstraints(byArray4);
            }
            catch (ASN1Exception aSN1Exception) {
                Debug.handleException((Exception)((Object)aSN1Exception));
                policyMappings = policyMappings2;
            }
        } else {
            policyMappings = policyMappings2;
        }
        if (policyMappings == null) throw new NotCACertificateException("Certificate is not a CA certificate : Basic Constraints extension not exist.");
        if (!policyMappings.isCA()) throw new NotCACertificateException("Certificate is not a CA certificate : Not a CA certificate.");
        CertChainEntry certChainEntry = object;
        BasicConstraints basicConstraints = certChainEntry.a();
        if (!(certChainEntry.m.getKeyUsage() == null && basicConstraints != null ? basicConstraints.isCA() : false)) {
            CertChainEntry certChainEntry2 = object;
            BasicConstraints basicConstraints2 = certChainEntry2.a();
            if (!(certChainEntry2.m.getKeyUsage() != null && basicConstraints2 != null ? basicConstraints2.isCA() : false)) {
                int n8 = ((CertChainEntry)object).h;
                if (n8 <= 0) throw new MaxPathLengthLimitException("Max path length is exceeded.");
                ((CertChainEntry)object).h = n8 - 1;
            }
        }
        if (policyMappings != null && policyMappings.getPathLen() < ((CertChainEntry)object).h) {
            ((CertChainEntry)object).h = policyMappings.getPathLen();
        }
        byte[] byArray5 = ((CertChainEntry)object).m.getExtensionValue("2.5.29.15");
        Object object = byArray5;
        Object var1_22 = null;
        if (byArray5 != null) {
            KeyUsage keyUsage;
            policyMappings2 = keyUsage;
            try {
                keyUsage = new KeyUsage((byte[])object);
            }
            catch (ASN1Exception aSN1Exception) {
                Debug.handleException((Exception)((Object)aSN1Exception));
                policyMappings2 = var1_22;
            }
        } else {
            policyMappings2 = var1_22;
        }
        if (policyMappings2 == null) return;
        if (!policyMappings2.isProperUsage(1024)) throw new KeyUsageViolateException("Key usage is not correct : Key usage does not include keyCertSign bit.");
    }

    public void wrapUp() throws PathValidateException {
        Object object;
        Object object2;
        block27: {
            int n2;
            int n3;
            if (!this.m.isSelfSigned() && (n3 = this.e) > 0) {
                this.e = n3 - 1;
            }
            byte[] byArray = this.m.getExtensionValue("2.5.29.36");
            object2 = null;
            if (byArray != null) {
                PolicyConstraints policyConstraints;
                object = policyConstraints;
                try {
                    policyConstraints = new PolicyConstraints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    object = object2;
                }
            } else {
                object = object2;
            }
            if (object != null && (n2 = object.getRequireExplicitPolicy()) == 0) {
                this.e = n2;
            }
            if (this.m.getPublicKey().getFormat().equals("X.509")) {
                PublicKeyInfo publicKeyInfo;
                CertChainEntry certChainEntry;
                try {
                    certChainEntry = this;
                }
                catch (Exception exception) {
                    throw new PublicKeyInfoFailException("PublicKey(X.509 format) key fails. : " + exception.getMessage());
                }
                PublicKeyInfo publicKeyInfo2 = publicKeyInfo;
                publicKeyInfo = new PublicKeyInfo(this.m.getPublicKey().getEncoded());
                if (!certChainEntry.j.getAlgorithm().equals(publicKeyInfo2.getAlgorithm())) break block27;
                if (publicKeyInfo2.getAlgParameter() != null) break block27;
                PublicKeyInfo publicKeyInfo3 = publicKeyInfo2;
                publicKeyInfo3.setAlgParameter(new PublicKeyInfo(this.j.getEncoded()).getAlgParameter());
                this.j = publicKeyInfo3.getPublicKey();
            } else {
                this.j = this.m.getPublicKey();
            }
        }
        CertChainEntry certChainEntry = this;
        Cloneable cloneable = certChainEntry.a.getUserInitialPolicySet();
        if (certChainEntry.b != null && cloneable != null) {
            if (((HashMap)cloneable).get(PolicyInfo.anyPolicy) != null) {
                this.b.clone();
            } else {
                HashSet hashSet;
                ASN1OID aSN1OID2;
                Object object3;
                HashMap hashMap;
                object2 = hashMap;
                hashMap = new HashMap();
                object = this.b.iterator();
                block8: while (object.hasNext()) {
                    object3 = (PolicyNode)object.next();
                    aSN1OID2 = ((PolicyNode)object3).getParent();
                    while (aSN1OID2 != null) {
                        if (aSN1OID2.isPolicy(PolicyInfo.anyPolicy)) {
                            ((HashMap)object2).put(((PolicyNode)object3).getValidPolicy().getPolicyID(), object3);
                            object3 = ((PolicyNode)object3).getValidPolicy().getPolicyID();
                            if (!object3.equals((Object)PolicyInfo.anyPolicy) && ((HashMap)cloneable).get(object3) == null) {
                                object.remove();
                                continue block8;
                            }
                        }
                        Object object4 = object3 = aSN1OID2.getParent();
                        object3 = aSN1OID2;
                        aSN1OID2 = object4;
                    }
                }
                object = hashSet;
                hashSet = new HashSet();
                for (ASN1OID aSN1OID2 : ((HashMap)cloneable).keySet()) {
                    if (((HashMap)object2).containsKey(aSN1OID2)) continue;
                    ((HashSet)object).add(aSN1OID2);
                }
                object2 = this.b.iterator();
                while (object2.hasNext()) {
                    object3 = (PolicyNode)object2.next();
                    if (!((PolicyNode)object3).isPolicy(PolicyInfo.anyPolicy) || ((HashMap)cloneable).get(PolicyInfo.anyPolicy) != null) continue;
                    aSN1OID2 = ((HashSet)object).iterator();
                    while (aSN1OID2.hasNext()) {
                        PolicyInfo policyInfo;
                        PolicyNode policyNode;
                        ASN1OID aSN1OID3 = (ASN1OID)aSN1OID2.next();
                        PolicyNode policyNode2 = policyNode;
                        policyNode = new PolicyNode();
                        PolicyInfo policyInfo2 = policyInfo;
                        policyInfo = new PolicyInfo(aSN1OID3);
                        Enumeration enumeration = ((PolicyNode)object3).getValidPolicy().elementsQualifiers();
                        while (enumeration.hasMoreElements()) {
                            policyInfo2.addQualifier((PolicyQualifier)enumeration.nextElement());
                        }
                        policyNode2.setValidPolicy(policyInfo2);
                        policyNode2.setCritical(((PolicyNode)object3).isCritical());
                        policyNode2.addExpectedPolicy(aSN1OID3);
                        policyNode2.setParent(((PolicyNode)object3).getParent());
                        ((PolicyNode)object3).getParent().addChild(policyNode2);
                        this.b.add(policyNode2);
                    }
                    object2.remove();
                }
            }
        }
        if ((cloneable = this.b) != null && ((HashSet)cloneable).size() <= 0) {
            this.b = null;
        }
        if (this.p && this.e <= 0 && this.b == null) {
            throw new ExplicitPolicyRequiredException("explicit_policy is required, but valid policy set is null.");
        }
    }

    public X509Certificate getCert() {
        return this.m;
    }

    public void setCert(X509Certificate x509Certificate) {
        if (x509Certificate instanceof X509Certificate) {
            try {
                this.m = new X509CertImpl(x509Certificate.getEncoded());
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        if (x509Certificate instanceof X509CertImpl) {
            this.m = (X509CertImpl)x509Certificate;
        }
    }

    public GeneralSubTrees getExcludedSubTrees() {
        return this.d;
    }

    public void setExcludedSubTrees(GeneralSubTrees generalSubTrees) {
        this.d = generalSubTrees;
    }

    public int getExplicitPolicy() {
        return this.e;
    }

    public void setExplicitPolicy(int n2) {
        this.e = n2;
    }

    public int getInhibitAnyPolicy() {
        return this.f;
    }

    public void setInhibitAnyPolicy(int n2) {
        this.f = n2;
    }

    public int getMaxPathLength() {
        return this.h;
    }

    public void setMaxPathLength(int n2) {
        this.h = n2;
    }

    public GeneralSubTrees getPermittedSubTrees() {
        return this.c;
    }

    public void setPermittedSubTrees(GeneralSubTrees generalSubTrees) {
        this.c = generalSubTrees;
    }

    public int getPolicyMapping() {
        return this.g;
    }

    public void setPolicyMapping(int n2) {
        this.g = n2;
    }

    public HashSet getValidPolicySet() {
        return this.b;
    }

    public void setValidPolicySet(HashSet hashSet) {
        this.b = hashSet;
    }

    public void addValidPolicy(PolicyNode policyNode) {
        if (this.b == null) {
            HashSet hashSet;
            HashSet hashSet2 = hashSet;
            hashSet = new HashSet();
            this.b = hashSet2;
        }
        this.b.add(policyNode);
    }

    public Name getWorkingIssuerName() {
        return this.l;
    }

    public void setWorkingIssuerName(Name name) {
        this.l = name;
    }

    public PublicKey getWorkingPublicKey() {
        return this.j;
    }

    public void setWorkingPublicKey(PublicKey publicKey) {
        this.j = publicKey;
    }

    public AlgorithmID getWorkingPublicKeyAlgorithm() {
        return this.i;
    }

    public void setWorkingPublicKeyAlgorithm(AlgorithmID algorithmID) {
        this.i = algorithmID;
    }

    public AlgorithmParameters getWorkingPublicKeyParameters() {
        return this.k;
    }

    public void setWorkingPublicKeyParameters(AlgorithmParameters algorithmParameters) {
        this.k = algorithmParameters;
    }

    public CertPathContext getContext() {
        return this.a;
    }

    public void setContext(CertPathContext certPathContext) {
        this.a = certPathContext;
    }

    public int getDepth() {
        return this.n;
    }

    public void setDepth(int n2) {
        this.n = n2;
    }
}

