/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cpv;

import com.initech.asn1.ASN1OID;
import com.initech.x509.extensions.PolicyInfo;
import com.initech.x509.extensions.PolicyQualifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class PolicyNode
implements Cloneable {
    public PolicyNode a;
    public ArrayList b;
    public PolicyInfo c;
    public boolean d;
    public HashMap e;

    public PolicyNode() {
    }

    public PolicyNode(PolicyNode policyNode, PolicyInfo policyInfo, boolean bl, HashMap hashMap) {
        this.a = policyNode;
        this.c = policyInfo;
        this.d = bl;
        this.e = hashMap;
    }

    public boolean isPolicy(ASN1OID aSN1OID) {
        PolicyNode policyNode = policyNode.c;
        if (policyNode == null) {
            return false;
        }
        return policyNode.getPolicyID().equals((Object)aSN1OID);
    }

    public boolean isPolicy(PolicyInfo policyInfo) {
        PolicyNode policyNode = policyNode.c;
        if (policyNode == null) {
            return false;
        }
        return policyNode.equals(policyInfo);
    }

    public boolean hasExpectedPolicy(ASN1OID aSN1OID) {
        if (this.e == null) {
            return false;
        }
        PolicyInfo policyInfo = this.c;
        if (policyInfo != null && policyInfo.getPolicyID().equals((Object)PolicyInfo.anyPolicy)) {
            return true;
        }
        return this.e.get(aSN1OID) != null;
    }

    public boolean hasParent(PolicyNode policyNode) {
        PolicyNode policyNode2 = policyNode2.getParent();
        if (policyNode != null && policyNode2 != null) {
            do {
                if (!policyNode2.equals(policyNode)) continue;
                return true;
            } while ((policyNode2 = policyNode2.getParent()) != null);
            return false;
        }
        return false;
    }

    public boolean hasParent() {
        return this.a != null;
    }

    public PolicyNode getRootNode() {
        PolicyNode policyNode = this.a;
        if (policyNode == null) {
            return this;
        }
        if ((policyNode = policyNode.getParent()) == null) {
            return this.a;
        }
        while (policyNode != null && policyNode.hasParent()) {
            policyNode = policyNode.getParent();
        }
        return policyNode;
    }

    public Object clone() {
        PolicyNode policyNode = policyNode2;
        PolicyNode policyNode2 = policyNode.a;
        PolicyInfo policyInfo = policyNode.c;
        boolean bl = policyNode.d;
        HashMap hashMap = policyNode.e;
        return new PolicyNode(policyNode2, policyInfo, bl, hashMap);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PolicyNode)) {
            return false;
        }
        return object == this;
    }

    public void indent(StringBuffer stringBuffer, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("    ");
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n2) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3 = stringBuffer2 = stringBuffer;
        PolicyNode policyNode = this;
        StringBuffer stringBuffer4 = stringBuffer2;
        StringBuffer stringBuffer5 = stringBuffer2;
        stringBuffer5(64);
        this.indent(stringBuffer5, n2);
        stringBuffer4.append("Valid Policy : ");
        stringBuffer4.append("\n");
        int n3 = n2 + 1;
        policyNode.indent(stringBuffer4, n3);
        stringBuffer3.append(policyNode.c.getPolicyID().toString());
        stringBuffer3.append("\n");
        this.indent(stringBuffer3, n2);
        stringBuffer.append("Policy Qualifiers : ");
        stringBuffer.append("\n");
        Enumeration enumeration = this.c.elementsQualifiers();
        while (enumeration.hasMoreElements()) {
            ((PolicyQualifier)enumeration.nextElement()).toString(stringBuffer2, n3);
        }
        PolicyNode policyNode2 = this;
        StringBuffer stringBuffer6 = stringBuffer2;
        StringBuffer stringBuffer7 = stringBuffer2;
        PolicyNode policyNode3 = this;
        StringBuffer stringBuffer8 = stringBuffer2;
        this.indent(stringBuffer2, n2);
        stringBuffer8.append("Criticality : ");
        stringBuffer8.append("\n");
        policyNode3.indent(stringBuffer8, n3);
        stringBuffer7.append(policyNode3.d);
        stringBuffer7.append("\n");
        this.indent(stringBuffer7, n2);
        stringBuffer6.append("Expected Policy Set : ");
        stringBuffer6.append("\n");
        policyNode2.indent(stringBuffer6, n3);
        Iterator iterator = policyNode2.e.keySet().iterator();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer9 = stringBuffer2;
            stringBuffer9.append(((ASN1OID)iterator.next()).toString());
            stringBuffer9.append(" ");
        }
        StringBuffer stringBuffer10 = stringBuffer2;
        stringBuffer10.append("\n");
        stringBuffer10.append("\n");
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                stringBuffer2.append(((PolicyNode)this.b.get(i2)).toString(n3));
            }
        }
        return stringBuffer2.toString();
    }

    public boolean isCritical() {
        return this.d;
    }

    public void setCritical(boolean bl) {
        this.d = bl;
    }

    public HashMap getExpectedPolicies() {
        return this.e;
    }

    public void setExpectedPolicies(HashMap hashMap) {
        this.e = hashMap;
    }

    public PolicyInfo getValidPolicy() {
        return this.c;
    }

    public void setValidPolicy(PolicyInfo policyInfo) {
        this.c = policyInfo;
    }

    public void addExpectedPolicy(ASN1OID aSN1OID) {
        if (this.e == null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            this.e = hashMap2;
        }
        ASN1OID aSN1OID2 = aSN1OID;
        this.e.put(aSN1OID2, aSN1OID2);
    }

    public PolicyNode getParent() {
        return this.a;
    }

    public void setParent(PolicyNode policyNode) {
        this.a = policyNode;
    }

    public ArrayList getChildren() {
        return this.b;
    }

    public void setChildren(ArrayList arrayList) {
        this.b = arrayList;
    }

    public void addChild(PolicyNode policyNode) {
        if (this.b == null) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            this.b = arrayList2;
        }
        this.b.add(policyNode);
    }

    public void removeChild(PolicyNode policyNode) {
        Object object = ((PolicyNode)object).b;
        if (object == null) {
            return;
        }
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            if (!((PolicyNode)object.next()).equals(policyNode)) continue;
            object.remove();
        }
    }

    public void removeChildren() {
        Object object = this.b;
        if (object == null) {
            return;
        }
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            ((PolicyNode)object.next()).removeChildren();
        }
        this.b.clear();
        this.b = null;
    }
}

